<!-- Transaction Modals Component -->
<script src="assets/js/date_picker.js"></script>
<!-- View Modal (Compact Receipt Style) -->
<div id="viewTransactionModal" class="fixed inset-0 z-[100] hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="fixed inset-0 bg-gray-900/60 backdrop-blur-sm transition-opacity" onclick="closeViewModal()"></div>
    <div class="fixed inset-0 z-10 w-screen overflow-y-auto">
        <div class="flex min-h-full items-center justify-center p-4">
            <div class="relative transform overflow-hidden rounded-2xl bg-white dark:bg-slate-900 text-left shadow-2xl transition-all w-full max-w-xl border border-gray-100 dark:border-gray-700 mx-auto">
                <button type="button" onclick="closeViewModal()" class="absolute top-3 right-3 z-50 p-1.5 text-gray-400 hover:text-gray-600 hover:bg-gray-100 dark:hover:bg-slate-800 rounded-lg transition-colors"><ion-icon name="close-outline" class="text-xl"></ion-icon></button>
                <div class="p-6">
                    <!-- Receipt Header -->
                    <div class="flex flex-col items-center mb-6">
                        <div class="w-12 h-12 bg-orange-50 dark:bg-orange-900/10 rounded-xl flex items-center justify-center text-[#E65100] mb-3"><ion-icon name="receipt-outline" class="text-2xl"></ion-icon></div>
                        <h2 class="text-xl font-bold text-gray-800 dark:text-white tracking-tight">Transaction #492054</h2>
                        <div class="flex items-center gap-2 mt-1">
                            <span class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-bold bg-[#DCFCE7] text-[#166534] uppercase tracking-wide">Completed</span>
                            <span class="text-xs text-gray-400">•</span>
                            <span class="text-xs font-medium text-gray-500 dark:text-gray-400">04 Sep 2025, 06:27</span>
                        </div>
                    </div>
                    <!-- Details Grid -->
                    <div class="bg-gray-50 dark:bg-slate-800/50 rounded-xl p-4 mb-6 border border-gray-100 dark:border-gray-700/50">
                        <div class="grid grid-cols-2 gap-y-4 gap-x-4">
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 rounded-full bg-white dark:bg-slate-700 flex items-center justify-center text-gray-400 shadow-sm"><ion-icon name="person" class="text-xs"></ion-icon></div>
                                <div class="flex flex-col"><span class="text-[10px] font-bold text-gray-400 uppercase tracking-wider">Customer</span><span class="text-xs font-bold text-gray-800 dark:text-gray-200">Alan Cain</span></div>
                            </div>
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 rounded-full bg-white dark:bg-slate-700 flex items-center justify-center text-[#E65100] shadow-sm"><span class="text-[10px] font-black">M</span></div>
                                <div class="flex flex-col"><span class="text-[10px] font-bold text-gray-400 uppercase tracking-wider">Sales By</span><span class="text-xs font-bold text-gray-800 dark:text-gray-200">Madu</span></div>
                            </div>
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 rounded-full bg-white dark:bg-slate-700 flex items-center justify-center text-[#E65100] shadow-sm"><ion-icon name="card" class="text-xs"></ion-icon></div>
                                <div class="flex flex-col"><span class="text-[10px] font-bold text-gray-400 uppercase tracking-wider">Payment</span><span class="text-xs font-bold text-gray-800 dark:text-gray-200">CARD</span></div>
                            </div>
                            <div class="flex items-center justify-end gap-2">
                                <button class="p-2 bg-white dark:bg-slate-700 border border-gray-200 dark:border-gray-600 rounded-lg text-gray-500 hover:text-primary transition-colors shadow-sm"><ion-icon name="print-outline"></ion-icon></button>
                                <button class="p-2 bg-white dark:bg-slate-700 border border-gray-200 dark:border-gray-600 rounded-lg text-gray-500 hover:text-primary transition-colors shadow-sm"><ion-icon name="mail-outline"></ion-icon></button>
                            </div>
                        </div>
                    </div>
                    <!-- Items List -->
                    <div class="mb-6">
                        <div class="text-[10px] font-bold text-gray-400 uppercase tracking-wider mb-2">Order Items</div>
                        <div class="border border-gray-100 dark:border-gray-700 rounded-xl overflow-hidden divide-y divide-gray-100 dark:divide-gray-700/50">
                            <!-- Items populated by PHP/JS ideally, hardcoded for preview -->
                            <div class="p-3 bg-white dark:bg-slate-900">
                                <div class="flex justify-between items-start mb-2">
                                    <div>
                                        <div class="text-sm font-bold text-gray-800 dark:text-gray-200">Coca-Cola Original Taste 8 x 330ml</div>
                                        <div class="text-[10px] font-semibold text-orange-600/80 dark:text-orange-400/80 uppercase tracking-wider mb-0.5">Soft Drinks</div>
                                        <div class="text-[10px] text-gray-400 font-mono">7393714518903</div>
                                    </div>
                                    <div class="text-sm font-black text-gray-800 dark:text-white">£ 1700.00</div>
                                </div>
                                <div class="grid grid-cols-4 gap-2 text-[10px]">
                                    <div class="flex flex-col"><span class="text-gray-400">Qty</span><span class="font-bold text-gray-700 dark:text-gray-300">5</span></div>
                                    <div class="flex flex-col"><span class="text-gray-400">Unit</span><span class="font-medium text-gray-600 dark:text-gray-400">£ 340.00</span></div>
                                    <div class="flex flex-col"><span class="text-gray-400">VAT</span><span class="font-medium text-gray-600 dark:text-gray-400">20%</span></div>
                                    <div class="flex flex-col text-right"><span class="text-gray-400">Disc.</span><span class="font-medium text-gray-400">-</span></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Totals -->
                    <div class="border-t border-dashed border-gray-200 dark:border-gray-700 pt-4 space-y-2">
                        <div class="flex justify-between text-xs text-gray-500 dark:text-gray-400"><span>Subtotal</span><span class="font-medium text-gray-800 dark:text-gray-200">£ 6215.00</span></div>
                        <div class="flex justify-between text-xs text-gray-500 dark:text-gray-400"><span>Total VAT</span><span class="font-medium text-gray-800 dark:text-gray-200">£ 1240.00</span></div>
                        <div class="flex justify-between text-xs text-green-600 dark:text-green-400"><span>Total Discount</span><span class="font-bold">- £ 2.00</span></div>
                        <div class="flex justify-between items-center pt-2"><span class="text-sm font-bold text-gray-800 dark:text-white">Grand Total</span><span class="text-2xl font-black text-[#E65100]">£ 7453.00</span></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit Modal (Compact Receipt Style) -->
<div id="editTransactionModal" class="fixed inset-0 z-[100] hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="fixed inset-0 bg-gray-900/60 backdrop-blur-sm transition-opacity" onclick="closeEditModal()"></div>
    <div class="fixed inset-0 z-10 w-screen overflow-y-auto">
        <div class="flex min-h-full items-center justify-center p-4">
            <div class="relative transform overflow-visible rounded-2xl bg-white dark:bg-slate-900 text-left shadow-2xl transition-all w-full max-w-xl border border-gray-100 dark:border-gray-700 mx-auto">
                <button type="button" onclick="closeEditModal()" class="absolute top-3 right-3 z-50 p-1.5 text-gray-400 hover:text-gray-600 hover:bg-gray-100 dark:hover:bg-slate-800 rounded-lg transition-colors"><ion-icon name="close-outline" class="text-xl"></ion-icon></button>

                <div class="p-6">
                     <!-- Header -->
                     <div class="flex flex-col items-center mb-6">
                        <div class="w-12 h-12 bg-orange-50 dark:bg-orange-900/10 rounded-xl flex items-center justify-center text-[#E65100] mb-3"><ion-icon name="create-outline" class="text-2xl"></ion-icon></div>
                        <h2 class="text-xl font-bold text-gray-800 dark:text-white tracking-tight">Edit Transaction</h2>
                    </div>

                    <!-- Editable Details Grid -->
                    <div class="bg-gray-50 dark:bg-slate-800/50 rounded-xl p-4 mb-6 border border-gray-100 dark:border-gray-700/50">
                        <div class="grid grid-cols-2 gap-4">
                            <div class="col-span-2 relative z-40">
                                <label class="text-[10px] font-bold text-gray-400 uppercase tracking-wider mb-1 block">Customer</label>
                                <div id="customer_dropdown_container" class="relative"></div>
                            </div>
                            <div class="relative z-30">
                                <label class="text-[10px] font-bold text-gray-400 uppercase tracking-wider mb-1 block">Sales By</label>
                                 <div id="sales_dropdown_container" class="relative"></div>
                            </div>
                             <div class="relative z-30">
                                <label class="text-[10px] font-bold text-gray-400 uppercase tracking-wider mb-1 block">Payment</label>
                                <button onclick="togglePaymentDropdown(event)" class="w-full flex items-center justify-between bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-600 rounded-xl px-3 py-2 text-xs font-bold text-gray-800 dark:text-white hover:border-orange-500 hover:ring-2 hover:ring-orange-500/10 transition-all h-[38px] group">
                                     <div class="flex items-center gap-2"><ion-icon id="selectedPaymentIcon" name="card" class="text-[#E65100] text-sm"></ion-icon><span id="selectedPaymentText">CARD</span></div>
                                    <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 group-hover:text-[#E65100] transition-colors"></ion-icon>
                                </button>
                                <div id="paymentDropdown" class="absolute top-full left-0 right-0 mt-2 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 p-1.5 hidden">
                                    <div onclick="selectPayment('CARD', 'card', 'text-[#E65100]')" class="flex items-center gap-2 p-2 rounded-lg hover:bg-orange-50 dark:hover:bg-orange-900/10 cursor-pointer text-xs font-bold"><ion-icon name="card" class="text-[#E65100]"></ion-icon>CARD</div>
                                    <div onclick="selectPayment('CASH', 'cash', 'text-green-500')" class="flex items-center gap-2 p-2 rounded-lg hover:bg-orange-50 dark:hover:bg-orange-900/10 cursor-pointer text-xs font-bold"><ion-icon name="cash" class="text-green-500"></ion-icon>CASH</div>
                                    <div onclick="selectPayment('ONLINE', 'globe', 'text-indigo-500')" class="flex items-center gap-2 p-2 rounded-lg hover:bg-orange-50 dark:hover:bg-orange-900/10 cursor-pointer text-xs font-bold"><ion-icon name="globe" class="text-indigo-500"></ion-icon>ONLINE</div>
                                </div>
                            </div>
                             <div class="relative z-20">
                                <label class="text-[10px] font-bold text-gray-400 uppercase tracking-wider mb-1 block">Date & Time</label>
                                <div id="date_picker_container" class="relative"></div>
                            </div>
                             <div class="relative z-20">
                                <label class="text-[10px] font-bold text-gray-400 uppercase tracking-wider mb-1 block">Status</label>
                                 <button onclick="toggleStatusDropdown(event)" class="w-full flex items-center justify-between bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-600 rounded-xl px-3 py-2 text-xs font-bold text-gray-800 dark:text-white hover:border-orange-500 hover:ring-2 hover:ring-orange-500/10 transition-all h-[38px] group">
                                     <div class="flex items-center gap-2"><div id="selectedStatusDot" class="w-1.5 h-1.5 rounded-full bg-green-500"></div><span id="selectedStatusText" class="truncate">Completed</span></div>
                                    <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 group-hover:text-[#E65100] transition-colors"></ion-icon>
                                </button>
                                <div id="statusDropdown" class="absolute top-full left-0 right-0 mt-2 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 p-1.5 hidden">
                                    <div onclick="selectStatus('Completed', 'bg-green-500')" class="flex items-center gap-2 p-2 rounded-lg hover:bg-orange-50 dark:hover:bg-orange-900/10 cursor-pointer text-xs font-bold"><div class="w-1.5 h-1.5 bg-green-500 rounded-full"></div>Completed</div>
                                    <div onclick="selectStatus('Refund', 'bg-blue-500')" class="flex items-center gap-2 p-2 rounded-lg hover:bg-orange-50 dark:hover:bg-orange-900/10 cursor-pointer text-xs font-bold"><div class="w-1.5 h-1.5 bg-blue-500 rounded-full"></div>Refund</div>
                                    <div onclick="selectStatus('Void', 'bg-red-500')" class="flex items-center gap-2 p-2 rounded-lg hover:bg-orange-50 dark:hover:bg-orange-900/10 cursor-pointer text-xs font-bold"><div class="w-1.5 h-1.5 bg-red-500 rounded-full"></div>Void</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Editable Items -->
                     <div class="mb-6 relative">
                        <div class="flex items-center justify-between mb-2">
                             <div class="text-[10px] font-bold text-gray-400 uppercase tracking-wider">Order Items</div>
                             <!-- Add Item Toggle -->
                             <button id="addItemBtn" onclick="toggleProductSearch()" class="flex items-center gap-1 text-[10px] font-bold text-[#E65100] hover:text-orange-700 transition-colors">
                                 <ion-icon name="add-circle"></ion-icon> Add Item
                             </button>
                        </div>
                        
                        <!-- Product Search Overlay (Initially Hidden) -->
                        <div id="productSearchContainer" class="hidden mb-3 animate-fade-in-down relative z-50">
                            <div class="relative">
                                <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400"></ion-icon>
                                <input type="text" id="productSearchInput" class="w-full pl-9 pr-10 py-2 bg-white dark:bg-slate-800 border border-orange-300 dark:border-orange-500/50 rounded-xl text-sm font-medium text-gray-800 dark:text-white placeholder-gray-400 focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 outline-none shadow-lg shadow-orange-500/5" placeholder="Scan barcode or type name..." aria-label="Search Product">
                                <button onclick="toggleProductSearch()" class="absolute right-3 top-2.5 text-gray-400 hover:text-gray-600"><ion-icon name="close-circle"></ion-icon></button>
                            </div>
                            <!-- Search Results Dropdown -->
                            <div id="productSearchResults" class="absolute top-full left-0 right-0 mt-2 bg-white dark:bg-slate-800 rounded-xl shadow-2xl border border-gray-100 dark:border-gray-700 max-h-60 overflow-y-auto hidden">
                                <!-- Populated by JS -->
                            </div>
                        </div>

                        <!-- List Container (Full Height) -->
                        <div id="modalItemsList" class="border border-gray-100 dark:border-gray-700 rounded-xl divide-y divide-gray-100 dark:divide-gray-700/50">
                             <!-- Pre-filled Row -->
                            <div class="p-3 bg-white dark:bg-slate-900 group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors item-row">
                                <div class="flex justify-between items-start mb-2 gap-2">
                                    <div class="w-full">
                                        <input type="text" value="Coca-Cola Original Taste 8 x 330ml" class="text-sm font-bold text-gray-800 dark:text-gray-200 bg-transparent border-none outline-none p-0 focus:ring-0 w-full mb-0.5 placeholder-gray-400" placeholder="Item Name" readonly>
                                        <input type="text" value="Soft Drinks" class="text-[10px] font-semibold text-orange-600/80 dark:text-orange-400/80 uppercase tracking-wider bg-transparent border-none outline-none p-0 focus:ring-0 w-full placeholder-gray-300" placeholder="Sub Category" readonly>
                                    </div>
                                    <button class="text-red-400 hover:text-red-500 p-1 transition-colors" onclick="this.closest('.item-row').remove(); updateGlobalTotals();"><ion-icon name="trash-outline"></ion-icon></button>
                                </div>
                                <div class="relative z-10 grid grid-cols-4 gap-3">
                                    <div class="space-y-1">
                                         <label class="text-[9px] text-gray-400 uppercase font-bold">Qty</label>
                                         <input type="number" value="5" class="qty-input w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-lg text-xs font-bold text-center py-1 h-7 text-gray-800 dark:text-gray-200 focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 outline-none transition-all shadow-sm [appearance:textfield] [&::-webkit-outer-spin-button]:appearance-none [&::-webkit-inner-spin-button]:appearance-none" oninput="updateRowTotal(this)">
                                    </div>
                                    <div class="space-y-1 relative group/vat">
                                         <label class="text-[9px] text-gray-400 uppercase font-bold">VAT</label>
                                         <button type="button" class="vat-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-lg text-[10px] font-bold py-0 pl-2 pr-1 h-7 text-gray-800 dark:text-gray-200 focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 outline-none transition-all shadow-sm flex items-center justify-between hover:border-orange-500">
                                             <span class="vat-value">20%</span>
                                             <ion-icon name="chevron-down-outline" class="text-[10px] text-gray-400 group-hover:text-orange-500"></ion-icon>
                                         </button>
                                    </div>
                                     <div class="space-y-1">
                                         <label class="text-[9px] text-gray-400 uppercase font-bold">Disc</label>
                                         <input type="text" value="0.00" class="disc-input w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-lg text-xs font-bold text-right text-red-500 py-1 h-7 focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 outline-none transition-all shadow-sm" oninput="updateRowTotal(this)">
                                    </div>
                                    <div class="space-y-1 text-right">
                                         <label class="text-[9px] text-gray-400 uppercase font-bold">Total</label>
                                         <div class="row-total text-xs font-black text-gray-800 dark:text-white py-1" data-unit-price="340.00">£ 1700.00</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Totals & Actions -->
                     <div class="border-t border-dashed border-gray-200 dark:border-gray-700 pt-4 space-y-4">
                         <div class="space-y-2">
                             <div class="flex justify-between text-xs text-gray-500 dark:text-gray-400"><span>Subtotal</span><span id="editSubtotal" class="font-medium text-gray-800 dark:text-gray-200">£ 1700.00</span></div>
                             <div class="flex justify-between text-xs text-gray-500 dark:text-gray-400"><span>Total VAT</span><span id="editVat" class="font-medium text-gray-800 dark:text-gray-200">£ 340.00</span></div>
                              <div class="flex justify-between text-xs text-green-600 dark:text-green-400"><span>Total Discount</span><span id="editDisc" class="font-bold">- £ 0.00</span></div>
                             <div class="flex justify-between items-center pt-2"><span class="text-sm font-bold text-gray-800 dark:text-white">Grand Total</span><span id="editGrandTotal" class="text-2xl font-black text-[#E65100]">£ 2040.00</span></div>
                         </div>
                        <div class="flex gap-3">
                             <button onclick="closeEditModal()" class="flex-1 py-2.5 bg-gray-100 hover:bg-gray-200 text-gray-600 font-bold rounded-xl text-sm transition-all">Cancel</button>
                             <button onclick="validateAndSubmit()" class="flex-[2] py-2.5 bg-[#E65100] hover:bg-[#F57C00] text-white font-bold rounded-xl shadow-lg shadow-orange-500/20 text-sm transition-all transform hover:-translate-y-0.5">Update Transaction</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // --- Mock Product Database ---
    const MOCK_PRODUCTS = [
        { id: 101, name: 'Coca-Cola Original Taste 8 x 330ml', sub: 'Soft Drinks', price: 6.50, discount: 0, barcode: '5449000000996' },
        { id: 102, name: 'Walkers Classic Variety Multipack', sub: 'Crisps', price: 2.25, discount: 0, barcode: '5000328987654' },
        { id: 103, name: 'Ferrero Rocher Collection 24 Pieces', sub: 'Chocolate', price: 12.00, discount: 2.50, barcode: '8000500123456' },
        { id: 104, name: 'Heineken Lager Beer 12 x 330ml', sub: 'Alcohol', price: 14.00, discount: 0, barcode: '8712000025684' },
        { id: 105, name: 'Hovis Soft White Medium Loaf 800g', sub: 'Bakery', price: 1.45, discount: 0.20, barcode: '5010003000123' },
        { id: 106, name: 'Fairy Washing Up Liquid 433ml', sub: 'Household', price: 1.00, discount: 0, barcode: '8001090000012' }
    ];

    // --- Modal Control ---
    // --- Blur Helper ---
    function toggleBlur(blur) {
        const elementsToBlur = [
            document.getElementById('sidebar'),
            document.getElementById('topbar'),
            document.getElementById('transactionContent')
        ];
        elementsToBlur.forEach(el => {
            if (el) {
                el.classList.add('transition-all', 'duration-300');
                if(blur) el.classList.add('blur-sm');
                else el.classList.remove('blur-sm');
            }
        });
    }

    // --- Modal Control ---
    function openViewModal(id) { 
        document.getElementById('viewTransactionModal').classList.remove('hidden'); 
        document.body.style.overflow='hidden'; 
        toggleBlur(true);
    }
    function closeViewModal() { 
        document.getElementById('viewTransactionModal').classList.add('hidden'); 
        document.body.style.overflow=''; 
        toggleBlur(false);
    }
    function openEditModal(id) { 
        document.getElementById('editTransactionModal').classList.remove('hidden'); 
        document.body.style.overflow='hidden'; 
        updateGlobalTotals(); 
        toggleBlur(true);
    }
    function closeEditModal() { 
        document.getElementById('editTransactionModal').classList.add('hidden'); 
        document.body.style.overflow=''; 
        toggleBlur(false);
    }

    // --- Product Search Logic ---
    function toggleProductSearch() {
        const container = document.getElementById('productSearchContainer');
        const input = document.getElementById('productSearchInput');
        container.classList.toggle('hidden');
        if(!container.classList.contains('hidden')) { input.focus(); input.value = ''; document.getElementById('productSearchResults').classList.add('hidden'); }
    }

    document.getElementById('productSearchInput').addEventListener('input', function(e) {
        const val = e.target.value.toLowerCase();
        const resultsContainer = document.getElementById('productSearchResults');
        
        if(val.length < 1) { resultsContainer.classList.add('hidden'); return; }
        
        const matches = MOCK_PRODUCTS.filter(p => p.name.toLowerCase().includes(val) || p.barcode.includes(val) || p.sub.toLowerCase().includes(val));
        
        resultsContainer.innerHTML = '';
        if(matches.length > 0) {
            resultsContainer.classList.remove('hidden');
            matches.forEach(p => {
                const finalPrice = p.price - p.discount;
                const priceDisplay = p.discount > 0 
                    ? `<span class="text-xs text-gray-400 line-through mr-1">£${p.price.toFixed(2)}</span><span class="text-sm font-bold text-red-500">£${finalPrice.toFixed(2)}</span>` 
                    : `<span class="text-sm font-bold text-gray-800 dark:text-gray-200">£${p.price.toFixed(2)}</span>`;
                
                const div = document.createElement('div');
                div.className = 'p-3 flex items-center justify-between hover:bg-orange-50 dark:hover:bg-slate-700 cursor-pointer border-b border-gray-50 dark:border-gray-700 last:border-0';
                div.innerHTML = `
                    <div class="flex gap-3 items-center">
                         <div class="w-10 h-10 rounded-lg bg-gray-100 dark:bg-slate-600 flex items-center justify-center text-gray-400">
                             <ion-icon name="cube-outline" class="text-lg"></ion-icon>
                         </div>
                         <div>
                             <div class="text-xs font-bold text-gray-800 dark:text-white">${p.name}</div>
                             <div class="flex items-center gap-2">
                                 <span class="text-[10px] font-semibold text-orange-600/80 uppercase tracking-wider bg-orange-100/50 px-1.5 rounded">${p.sub}</span>
                                 <span class="text-[10px] text-gray-400 font-mono">${p.barcode}</span>
                             </div>
                         </div>
                    </div>
                    <div>${priceDisplay}</div>
                `;
                div.onclick = () => addProductToTable(p);
                resultsContainer.appendChild(div);
            });
        } else {
            resultsContainer.classList.add('hidden');
        }
    });

    function addProductToTable(product) {
        const qty = 1;
        const discount = product.discount || 0;
        const unitPrice = product.price; // We use base price for unit
        const total = (unitPrice * qty) - discount;

        const row = document.createElement('div');
        row.className = 'p-3 bg-white dark:bg-slate-900 group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors item-row animate-fade-in-down';
        row.innerHTML = `
            <div class="flex justify-between items-start mb-2 gap-2">
                <div class="w-full">
                    <input type="text" value="${product.name}" class="text-sm font-bold text-gray-800 dark:text-gray-200 bg-transparent border-none p-0 focus:ring-0 w-full mb-0.5" readonly>
                    <input type="text" value="${product.sub}" class="text-[10px] font-semibold text-orange-600/80 dark:text-orange-400/80 uppercase tracking-wider bg-transparent border-none p-0 focus:ring-0 w-full" readonly>
                </div>
                <button class="text-red-400 hover:text-red-500 p-1 transition-colors" onclick="this.closest('.item-row').remove(); updateGlobalTotals();"><ion-icon name="trash-outline"></ion-icon></button>
            </div>
            <div class="grid grid-cols-4 gap-3 relative z-10">
                <div class="space-y-1">
                        <label class="text-[9px] text-gray-400 uppercase font-bold">Qty</label>
                        <input type="number" value="${qty}" class="qty-input w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-lg text-xs font-bold text-center py-1 h-7 text-gray-800 dark:text-gray-200 focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 outline-none transition-all shadow-sm [appearance:textfield] [&::-webkit-outer-spin-button]:appearance-none [&::-webkit-inner-spin-button]:appearance-none" oninput="updateRowTotal(this)">
                </div>
                <div class="space-y-1 relative">
                        <label class="text-[9px] text-gray-400 uppercase font-bold">VAT</label>
                        <button type="button" class="vat-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-lg text-[10px] font-bold py-0 pl-2 pr-1 h-7 text-gray-800 dark:text-gray-200 focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 outline-none transition-all shadow-sm flex items-center justify-between group">
                            <span class="vat-value">20%</span>
                            <ion-icon name="chevron-down-outline" class="text-[10px] text-gray-400 group-hover:text-orange-500"></ion-icon>
                        </button>
                </div>
                <div class="space-y-1">
                        <label class="text-[9px] text-gray-400 uppercase font-bold">Disc</label>
                        <input type="text" value="${discount.toFixed(2)}" class="disc-input w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-lg text-xs font-bold text-right text-red-500 py-1 h-7 focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 outline-none transition-all shadow-sm" oninput="updateRowTotal(this)">
                </div>
                <div class="space-y-1 text-right">
                        <label class="text-[9px] text-gray-400 uppercase font-bold">Total</label>
                        <div class="row-total text-xs font-black text-gray-800 dark:text-white py-1" data-unit-price="${product.price}">£ ${total.toFixed(2)}</div>
                </div>
            </div>
        `;
        document.getElementById('modalItemsList').appendChild(row);
        toggleProductSearch();
        updateGlobalTotals();
    }

    // --- Calculation Logic ---
    function updateRowTotal(input) {
        const row = input.closest('.grid');
        const qty = parseFloat(row.querySelector('.qty-input').value) || 0;
        const totalDiv = row.querySelector('.row-total');
        const unitPrice = parseFloat(totalDiv.dataset.unitPrice) || 0;
        const disc = parseFloat(row.querySelector('.disc-input').value) || 0;
        
        const total = (qty * unitPrice) - disc;
        totalDiv.innerText = "£ " + total.toFixed(2);
        updateGlobalTotals();
    }

    function updateGlobalTotals() {
        let subtotal = 0;
        let totalDisc = 0;
        let totalVat = 0; // Simplified VAT calc for demo

        document.querySelectorAll('.row-total').forEach(el => {
            const rowVal = parseFloat(el.innerText.replace('£','').trim()) || 0;
            // Re-calc from inputs for accuracy? Rely on UI for now.
            // Let's assume row total is inclusive of VAT but exclusive of row-disc? Layout implies row total is final.
            // Simplified: Sum row totals for Grand Total. 
            // Sum Discounts.
            const row = el.closest('.grid');
            const disc = parseFloat(row.querySelector('.disc-input').value) || 0;
            totalDisc += disc;
            subtotal += rowVal + disc; // Subtotal before discount
        });
        
        // Approximate VAT (20% of Subtotal / 1.2) - Just mock logic
        const grandTotal = subtotal - totalDisc;
        totalVat = grandTotal - (grandTotal / 1.2); 

        document.getElementById('editSubtotal').innerText = "£ " + subtotal.toFixed(2);
        document.getElementById('editDisc').innerText = "- £ " + totalDisc.toFixed(2);
        document.getElementById('editVat').innerText = "£ " + totalVat.toFixed(2);
        document.getElementById('editGrandTotal').innerText = "£ " + grandTotal.toFixed(2);
    }

    // --- Global Dropdown Manager ---
    const activeDropdowns = new Set();
    function closeAllDropdowns(exceptId = null) {
        // Close ID-based dropdowns
        document.querySelectorAll('[id^="dropdown_"], [id$="Dropdown"]').forEach(el => {
            if (el.id !== exceptId) el.classList.add('hidden');
        });
        // Close class-based dropdowns (like VAT)
        if (!exceptId || !exceptId.includes('vat')) {
             document.querySelectorAll('.vat-dropdown-menu').forEach(el => el.remove());
        }
    }

    // --- Dynamic Dropdowns (Icons + Text) ---
    function togglePaymentDropdown(e) { 
        if(e) e.stopPropagation();
        const dd = document.getElementById('paymentDropdown');
        const isHidden = dd.classList.contains('hidden');
        closeAllDropdowns('paymentDropdown');
        if(isHidden) dd.classList.remove('hidden');
    }
    function selectPayment(val, icon, colorClass) { 
        document.getElementById('selectedPaymentText').innerText = val;
        const iconEl = document.getElementById('selectedPaymentIcon');
        iconEl.setAttribute('name', icon);
        iconEl.className = colorClass + ' text-sm'; // Reset classes
        document.getElementById('paymentDropdown').classList.add('hidden'); 
    }

    function toggleStatusDropdown(e) { 
        if(e) e.stopPropagation();
        const dd = document.getElementById('statusDropdown');
        const isHidden = dd.classList.contains('hidden');
        closeAllDropdowns('statusDropdown');
        if(isHidden) dd.classList.remove('hidden');
    }
    function selectStatus(status, bgClass) { 
        document.getElementById('selectedStatusText').innerText = status;
        const dot = document.getElementById('selectedStatusDot');
        dot.className = 'w-1.5 h-1.5 rounded-full ' + bgClass;
        document.getElementById('statusDropdown').classList.add('hidden'); 
    }

    // --- Components Classes ---
    class SearchableDropdown {
        constructor(id, placeholder, options, defaultSelected) { this.id = id; this.options = options; this.selected = defaultSelected; this.container = document.getElementById(id + '_container'); if(this.container) this.init(); }
        init() {
            this.container.innerHTML = `<button id="btn_${this.id}" type="button" class="w-full flex items-center justify-between bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-600 rounded-xl px-3 py-2 text-xs font-bold text-gray-800 dark:text-white hover:border-orange-500 hover:ring-2 hover:ring-orange-500/10 transition-all h-[38px]"><span id="label_${this.id}" class="truncate">${this.selected}</span><ion-icon name="chevron-down-outline" class="text-xs text-gray-400 shrink-0"></ion-icon></button><div id="dropdown_${this.id}" class="absolute top-full left-0 right-0 mt-2 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 z-50 p-2 hidden flex flex-col gap-2"><input type="text" id="search_${this.id}" placeholder="Search..." class="w-full pl-3 pr-3 py-1.5 bg-gray-50 dark:bg-slate-700/50 border-none rounded-lg text-xs font-medium outline-none"><div id="list_${this.id}" class="max-h-[150px] overflow-y-auto space-y-0.5 custom-scrollbar">${this.renderOptions()}</div></div>`;
            const btn = document.getElementById(`btn_${this.id}`), dd = document.getElementById(`dropdown_${this.id}`), search = document.getElementById(`search_${this.id}`);
            
            btn.onclick = (e) => { 
                e.stopPropagation(); 
                const isHidden = dd.classList.contains('hidden');
                closeAllDropdowns(`dropdown_${this.id}`);
                if(isHidden) { dd.classList.remove('hidden'); search.focus(); }
            };
            
            search.oninput = (e) => document.getElementById(`list_${this.id}`).innerHTML = this.renderOptions(e.target.value);
            document.getElementById(`list_${this.id}`).addEventListener('click', (e) => { const item = e.target.closest('.dropdown-item'); if(item) { this.selected = item.dataset.name; document.getElementById(`label_${this.id}`).innerText = this.selected; dd.classList.add('hidden'); } });
        }
        renderOptions(filter="") { return this.options.filter(o => o.name.toLowerCase().includes(filter.toLowerCase())).map(o => `<div class="dropdown-item flex items-center gap-2 p-2 rounded-lg cursor-pointer hover:bg-orange-50 dark:hover:bg-orange-900/10" data-name="${o.name}"><ion-icon name="${o.icon}" class="text-xs text-gray-500"></ion-icon><span class="text-xs font-medium">${o.name}</span></div>`).join(''); }
    }

    // --- Global Click Handler for VAT Dropdowns ---
    document.addEventListener('click', function(e) {
        // Toggle Open VAT
        if(e.target.closest('.vat-trigger')) {
            const trigger = e.target.closest('.vat-trigger');
            const container = trigger.parentElement;
            
            // Check if already open
            const existing = container.querySelector('.vat-dropdown-menu');
            const isHidden = !!existing;

            closeAllDropdowns(); // Close others

            if(!isHidden) {
                const dd = document.createElement('div');
                dd.className = 'vat-dropdown-menu absolute top-full left-0 mt-1 w-24 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 z-[60] overflow-hidden animate-fade-in-down';
                dd.innerHTML = `
                    <div class="p-1">
                        <div class="vat-opt px-2 py-1.5 hover:bg-orange-50 dark:hover:bg-orange-900/10 cursor-pointer rounded-lg text-[10px] font-bold text-gray-700 dark:text-gray-200">20%</div>
                        <div class="vat-opt px-2 py-1.5 hover:bg-orange-50 dark:hover:bg-orange-900/10 cursor-pointer rounded-lg text-[10px] font-bold text-gray-700 dark:text-gray-200">5%</div>
                        <div class="vat-opt px-2 py-1.5 hover:bg-orange-50 dark:hover:bg-orange-900/10 cursor-pointer rounded-lg text-[10px] font-bold text-gray-700 dark:text-gray-200">0%</div>
                    </div>
                `;
                container.appendChild(dd);
                
                // Handle Selection
                dd.querySelectorAll('.vat-opt').forEach(opt => {
                    opt.onclick = function(ev) {
                        ev.stopPropagation();
                        trigger.querySelector('.vat-value').innerText = this.innerText;
                        dd.remove();
                    }
                });
            }
        }
        else {
             // Close everything if clicking outside valid dropdown areas
             // This is handled by closeAllDropdowns being called on triggers, but we also need a global close
             if(!e.target.closest('.searchable-dropdown') && !e.target.closest('#date_picker_container') && !e.target.closest('#paymentDropdown') && !e.target.closest('#statusDropdown')) {
                 closeAllDropdowns();
             }
        }
    });

    const customers = [{ name: 'Alan Cain', icon: 'person' }, { name: 'Maggie Sullivan', icon: 'person' }];
    const staff = [{ name: 'Madu', icon: 'id-card' }, { name: 'John Doe', icon: 'id-card' }];
    document.addEventListener('DOMContentLoaded', () => {
        if(document.getElementById('editTransactionModal')) {
             new SearchableDropdown('customer_dropdown', 'Search...', customers, 'Alan Cain');
             new SearchableDropdown('sales_dropdown', 'Search...', staff, 'Madu');
             // SingleDatePicker is now loaded from assets/js/date_picker.js
             if(typeof SingleDatePicker !== 'undefined') {
                 new SingleDatePicker('date_picker', '2025-09-04T06:27:00');
             }
        }
    });

    function validateAndSubmit() {
        let valid = true;
        document.querySelectorAll('.qty-input').forEach(i => { if(i.value <= 0) { i.classList.add('ring-2','ring-red-500'); valid=false; } else { i.classList.remove('ring-2','ring-red-500'); } });
        if(valid) { 
            if(window.showToast) {
                showToast('Transaction Updated!', 'success');
            } else {
                alert('Transaction Updated!');
            }
            closeEditModal(); 
        } else { 
            if(window.showToast) {
                showToast('Please fix invalid quantities.', 'error');
            } else {
                alert('Please fix invalid quantities.');
            }
        }
    }
</script>
