<?php
// Reusable Time Picker Component
// Usage: 
// $pickerId = 'start_time'; $value = '09:00'; $nextPickerId = 'end_time'; include 'includes/components/time_picker.php';

// Reset variable for this include scope
$pickerValue = $value ?? '09:00';
$pickerInstanceId = $pickerId ?? 'time_' . uniqid();
$nextInstanceId = $nextPickerId ?? '';
unset($nextPickerId); // Prevent persistence

// Split time into parts
$parts = explode(':', $pickerValue);
$hour = $parts[0] ?? '09';
$minute = $parts[1] ?? '00';
// Convert to 12h format for display if needed
$displayHour = (int)$hour;
$ampm = $displayHour >= 12 ? 'PM' : 'AM';
if ($displayHour > 12) $displayHour -= 12;
if ($displayHour == 0) $displayHour = 12;
$displayHour = str_pad($displayHour, 2, '0', STR_PAD_LEFT);
$displayTime = "$displayHour:$minute $ampm";
?>
<style>
    .custom-time-picker .custom-scrollbar::-webkit-scrollbar {
        display: none;
    }
    .custom-time-picker .custom-scrollbar {
        -ms-overflow-style: none;
        scrollbar-width: none;
    }
</style>

<div class="relative custom-time-picker" id="wrapper_<?php echo $pickerInstanceId; ?>" data-next-picker="<?php echo $nextInstanceId; ?>">
    <button type="button" class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group" onclick="toggleTimeDropdown('<?php echo $pickerInstanceId; ?>')">
        <span class="time-label"><?php echo $displayTime; ?></span>
        <ion-icon name="time-outline" class="text-gray-400 group-focus:text-primary transition-colors"></ion-icon>
    </button>

    <div id="dropdown_<?php echo $pickerInstanceId; ?>" class="absolute top-full left-0 mt-2 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-xl border border-gray-100 dark:border-gray-700 z-50 overflow-hidden opacity-0 invisible transform -translate-y-2 transition-all duration-200">
        <div class="flex h-[240px]">
            <!-- Hours -->
            <div class="flex-1 overflow-y-auto custom-scrollbar py-2 border-r border-gray-50 dark:border-gray-700/50">
                <div class="text-[10px] font-bold text-gray-400 dark:text-gray-500 px-4 mb-1 uppercase tracking-wider">Hour</div>
                <?php for($h=1; $h<=12; $h++): 
                    $hStr = str_pad($h, 2, '0', STR_PAD_LEFT);
                    $isActive = ($hStr == $displayHour);
                ?>
                <button type="button" class="w-full px-4 py-2 text-sm text-left transition-colors <?php echo $isActive ? 'bg-orange-50 dark:bg-orange-500/10 text-primary font-bold' : 'text-gray-600 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-slate-700/50'; ?>" data-type="hour" data-value="<?php echo $hStr; ?>" onclick="selectTimePart('<?php echo $pickerInstanceId; ?>', 'hour', '<?php echo $hStr; ?>', this)">
                    <?php echo $hStr; ?>
                </button>
                <?php endfor; ?>
            </div>
            <!-- Minutes -->
            <div class="flex-1 overflow-y-auto custom-scrollbar py-2 border-r border-gray-50 dark:border-gray-700/50">
                <div class="text-[10px] font-bold text-gray-400 dark:text-gray-500 px-4 mb-1 uppercase tracking-wider">Min</div>
                <?php for($m=0; $m<60; $m+=5): 
                    $mStr = str_pad($m, 2, '0', STR_PAD_LEFT);
                    $isActive = ($mStr == $minute);
                ?>
                <button type="button" class="w-full px-4 py-2 text-sm text-left transition-colors <?php echo $isActive ? 'bg-orange-50 dark:bg-orange-500/10 text-primary font-bold' : 'text-gray-600 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-slate-700/50'; ?>" data-type="minute" data-value="<?php echo $mStr; ?>" onclick="selectTimePart('<?php echo $pickerInstanceId; ?>', 'minute', '<?php echo $mStr; ?>', this)">
                    <?php echo $mStr; ?>
                </button>
                <?php endfor; ?>
            </div>
            <!-- AM/PM -->
            <div class="w-20 py-2">
                <div class="text-[10px] font-bold text-gray-400 dark:text-gray-500 px-4 mb-1 uppercase tracking-wider">Period</div>
                <?php foreach(['AM','PM'] as $p): 
                    $isActive = ($p == $ampm);
                ?>
                <button type="button" class="w-full px-4 py-2 text-sm text-left transition-colors <?php echo $isActive ? 'bg-orange-50 dark:bg-orange-500/10 text-primary font-bold' : 'text-gray-600 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-slate-700/50'; ?>" data-type="ampm" data-value="<?php echo $p; ?>" onclick="selectTimePart('<?php echo $pickerInstanceId; ?>', 'ampm', '<?php echo $p; ?>', this)">
                    <?php echo $p; ?>
                </button>
                <?php endforeach; ?>
            </div>
        </div>
        <!-- Hidden Inputs for actual form submission -->
        <input type="hidden" name="<?php echo $pickerInstanceId; ?>" id="input_<?php echo $pickerInstanceId; ?>" value="<?php echo $pickerValue; ?>">
    </div>
</div>

<script>
if (typeof toggleTimeDropdown === 'undefined') {
    window.toggleTimeDropdown = function(id) {
        const dropdown = document.getElementById('dropdown_' + id);
        const allDropdowns = document.querySelectorAll('[id^="dropdown_"]');
        
        // Close others
        allDropdowns.forEach(d => {
            if (d.id !== 'dropdown_' + id) {
                d.classList.add('opacity-0', 'invisible', '-translate-y-2');
            }
        });

        if (!dropdown) return;

        const isHidden = dropdown.classList.contains('invisible');
        if (isHidden) {
            dropdown.classList.remove('invisible', 'opacity-0', '-translate-y-2');
            // Scroll active items into view
            setTimeout(() => {
                dropdown.querySelectorAll('.bg-orange-50').forEach(el => {
                    el.scrollIntoView({ block: 'center', behavior: 'smooth' });
                });
            }, 50);
        } else {
            dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
        }
    };

    window.selectTimePart = function(id, type, value, btn) {
        const wrapper = document.getElementById('wrapper_' + id);
        const dropdown = document.getElementById('dropdown_' + id);
        const label = wrapper.querySelector('.time-label');
        const hiddenInput = document.getElementById('input_' + id);
        
        // Update highlight
        dropdown.querySelectorAll(`button[data-type="${type}"]`).forEach(b => {
            b.classList.remove('bg-orange-50', 'dark:bg-orange-500/10', 'text-primary', 'font-bold');
            b.classList.add('text-gray-600', 'dark:text-gray-400');
        });
        btn.classList.add('bg-orange-50', 'dark:bg-orange-500/10', 'text-primary', 'font-bold');
        btn.classList.remove('text-gray-600', 'dark:text-gray-400');

        // Get current values
        let currentLabel = label.textContent; 
        let parts = currentLabel.split(/[: ]/); 
        
        if (type === 'hour') parts[0] = value;
        if (type === 'minute') parts[1] = value;
        if (type === 'ampm') parts[2] = value;

        const newDisplay = `${parts[0]}:${parts[1]} ${parts[2]}`;
        label.textContent = newDisplay;

        // Update hidden 24h input
        let h = parseInt(parts[0]);
        if (parts[2] === 'PM' && h < 12) h += 12;
        if (parts[2] === 'AM' && h === 12) h = 0;
        const h24 = h.toString().padStart(2, '0');
        hiddenInput.value = `${h24}:${parts[1]}`;
    };

    // Global Click Listener for Outside Click & Chaining
    document.addEventListener('click', (e) => {
        // Special Case: Don't close if clicking inside a time picker or on its trigger
        if (e.target.closest('.custom-time-picker')) return;

        // Find all open dropdowns
        const openPickers = document.querySelectorAll('[id^="dropdown_"]:not(.invisible)');
        
        openPickers.forEach(dropdown => {
            const pickerId = dropdown.id.replace('dropdown_', '');
            const wrapper = document.getElementById('wrapper_' + pickerId);
            const nextId = wrapper?.dataset.nextPicker;

            // Close current
            dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');

            // If it has a next picker AND it's not itself, open it!
            if (nextId && nextId !== pickerId) {
                setTimeout(() => toggleTimeDropdown(nextId), 100);
            }
        });
    });
}
</script>
