<?php
// Multi-Select Store Filter Component
// Usage: include 'includes/components/store_filter_multi.php';

$filterId = $filterId ?? 'store_filter';
$paramName = $paramName ?? 'stores';

// Mock Data (Replace with DB fetch in production)
$stores = [
    ['id' => '1001', 'name' => 'FNF Cardiff', 'code' => 'CDF', 'color' => 'bg-blue-100 text-blue-600'],
    ['id' => '1002', 'name' => 'FNF Swansea', 'code' => 'SWA', 'color' => 'bg-emerald-100 text-emerald-600'],
    ['id' => '1003', 'name' => '3S Penarth', 'code' => 'PEN', 'color' => 'bg-orange-100 text-orange-600'],
    ['id' => '1004', 'name' => 'Newport Express', 'code' => 'NWP', 'color' => 'bg-purple-100 text-purple-600'],
];

// Get selection from URL
$selected = $_GET[$paramName] ?? 'all';
$selectedIds = ($selected === 'all') ? [] : explode(',', $selected);
$isAll = ($selected === 'all');

// Display Label
$displayLabel = 'All Stores';
if (!$isAll) {
    $count = count($selectedIds);
    if ($count === 1) {
        foreach ($stores as $s) {
            if ($s['id'] == $selectedIds[0]) { $displayLabel = $s['name']; break; }
        }
    } else {
        $displayLabel = "$count Stores";
    }
}
?>

<div class="relative z-50">
    <!-- Trigger Button -->
    <button id="btn_<?php echo $filterId; ?>" type="button" class="flex items-center gap-2 px-3 py-2 text-sm font-medium text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-white dark:hover:bg-slate-700 rounded-lg transition-colors whitespace-nowrap cursor-pointer">
        <ion-icon name="storefront-outline" class="text-gray-400"></ion-icon>
        <span id="label_<?php echo $filterId; ?>"><?php echo $displayLabel; ?></span>
        <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 ml-1 transition-transform duration-300"></ion-icon>
    </button>

    <!-- Dropdown -->
    <div id="dropdown_<?php echo $filterId; ?>" class="absolute top-full left-0 mt-2 w-72 bg-white dark:bg-slate-800 rounded-2xl shadow-xl border border-gray-100 dark:border-gray-700 p-3 opacity-0 invisible transform -translate-y-2 transition-all duration-200 flex flex-col gap-2">
        
        <!-- Search -->
        <div class="relative mb-1">
            <ion-icon name="search-outline" class="absolute left-3 top-2.5 text-gray-400 text-sm"></ion-icon>
            <input type="text" id="search_<?php echo $filterId; ?>" placeholder="Search stores..." 
                class="w-full pl-9 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:bg-white dark:focus:bg-slate-700 focus:border-primary/30 focus:ring-2 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all">
        </div>

        <!-- Scrollable List -->
        <div class="max-h-[250px] overflow-y-auto pr-1 space-y-1 custom-scrollbar">
            
            <!-- "All Stores" Option -->
            <div onclick="window.storeFilter.toggle('all')" class="group flex items-center justify-between p-2 rounded-xl cursor-pointer hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors <?php echo $isAll ? 'bg-orange-50 dark:bg-orange-900/10' : ''; ?>" data-id="all">
                <div class="flex items-center gap-3">
                    <div class="w-8 h-8 rounded-lg bg-orange-100 dark:bg-orange-900/30 text-[#E65100] dark:text-orange-400 flex items-center justify-center">
                        <ion-icon name="storefront" class="text-lg"></ion-icon>
                    </div>
                    <span class="text-sm font-semibold text-gray-700 dark:text-gray-200">All Stores</span>
                </div>
                <ion-icon name="checkmark-circle" class="text-xl text-[#E65100] transition-opacity <?php echo $isAll ? 'opacity-100' : 'opacity-0'; ?>"></ion-icon>
            </div>

            <!-- Individual Stores -->
            <?php foreach ($stores as $store): 
                $isSelected = in_array($store['id'], $selectedIds);
            ?>
            <div onclick="window.storeFilter.toggle('<?php echo $store['id']; ?>')" class="store-item group flex items-center justify-between p-2 rounded-xl cursor-pointer hover:bg-gray-50 dark:hover:bg-slate-700/50 transition-colors <?php echo $isSelected ? 'bg-gray-50 dark:bg-slate-700' : ''; ?>" data-id="<?php echo $store['id']; ?>" data-name="<?php echo strtolower($store['name']); ?>">
                <div class="flex items-center gap-3">
                    <div class="w-8 h-8 rounded-lg <?php echo $store['color']; ?> flex items-center justify-center text-xs font-bold">
                        <?php echo $store['code']; ?>
                    </div>
                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300"><?php echo $store['name']; ?></span>
                </div>
                <ion-icon name="checkmark-circle" class="text-xl text-[#E65100] transition-opacity <?php echo $isSelected ? 'opacity-100' : 'opacity-0'; ?>"></ion-icon>
            </div>
            <?php endforeach; ?>

        </div>
        
        <!-- (No Footer Actions) -->
        <div class="h-2"></div>

    </div>
</div>

<script>
if (typeof StoreMultiFilter === 'undefined') {
    window.StoreMultiFilter = class StoreMultiFilter {
        constructor(filterId, paramName) {
            this.filterId = filterId;
            this.paramName = paramName;
            this.selected = new Set(<?php echo json_encode($isAll ? [] : $selectedIds); ?>);
            this.isAll = <?php echo $isAll ? 'true' : 'false'; ?>;
            
            this.init();
        }

        init() {
            const btn = document.getElementById(`btn_${this.filterId}`);
            const input = document.getElementById(`search_${this.filterId}`);
            
            if(btn) {
                btn.onclick = (e) => { e.stopPropagation(); this.toggleDropdown(); };
            }
            if(input) {
                input.oninput = (e) => this.filterList(e.target.value);
                input.onclick = (e) => e.stopPropagation(); // Prevent close
            }

            document.addEventListener('click', (e) => {
                const dropdown = document.getElementById(`dropdown_${this.filterId}`);
                if (btn && dropdown && !btn.contains(e.target) && !dropdown.contains(e.target)) {
                    this.closeDropdown();
                }
            });
        }

        toggleDropdown() {
             const dropdown = document.getElementById(`dropdown_${this.filterId}`);
             if(!dropdown) return;
             if (dropdown.classList.contains('invisible')) {
                 dropdown.classList.remove('invisible', 'opacity-0', '-translate-y-2');
                 document.getElementById(`search_${this.filterId}`).focus();
             } else {
                 this.closeDropdown();
             }
        }

        closeDropdown() {
            const dropdown = document.getElementById(`dropdown_${this.filterId}`);
            if(dropdown) dropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
        }

        toggle(id) {
            const els = document.querySelectorAll(`#dropdown_${this.filterId} [data-id]`);
            
            if (id === 'all') {
                this.isAll = true;
                this.selected.clear();
            } else {
                this.isAll = false;
                if (this.selected.has(id)) {
                    this.selected.delete(id);
                    if (this.selected.size === 0) this.isAll = true;
                } else {
                    this.selected.add(id);
                }
            }
            this.updateUI();
            this.apply(false); // Update URL immediately, don't close
        }

        updateUI() {
            const container = document.getElementById(`dropdown_${this.filterId}`);
            
            // All Option
            const allEl = container.querySelector('[data-id="all"]');
            const allIcon = allEl.querySelector('ion-icon[name="checkmark-circle"]');
            
            if (this.isAll) {
                allEl.classList.add('bg-orange-50', 'dark:bg-orange-900/10');
                allIcon.classList.remove('opacity-0');
            } else {
                allEl.classList.remove('bg-orange-50', 'dark:bg-orange-900/10');
                allIcon.classList.add('opacity-0');
            }

            // Items
            container.querySelectorAll('.store-item').forEach(el => {
                const id = el.getAttribute('data-id');
                const icon = el.querySelector('ion-icon[name="checkmark-circle"]');
                
                if (this.selected.has(id) && !this.isAll) {
                    el.classList.add('bg-gray-50', 'dark:bg-slate-700');
                    icon.classList.remove('opacity-0');
                } else {
                    el.classList.remove('bg-gray-50', 'dark:bg-slate-700');
                    icon.classList.add('opacity-0');
                }
            });
        }

        filterList(term) {
            const t = term.toLowerCase();
            document.querySelectorAll(`#dropdown_${this.filterId} .store-item`).forEach(el => {
                const name = el.getAttribute('data-name');
                el.style.display = name.includes(t) ? 'flex' : 'none';
            });
        }

        async apply(close = true) {
            if (close) this.closeDropdown();
            
            let val = 'all';
            if (!this.isAll && this.selected.size > 0) {
                val = Array.from(this.selected).join(',');
            }

            const url = new URL(window.location.href);
            url.searchParams.set(this.paramName, val);
            
            // Nice Label Update
            let label = 'All Stores';
            if (!this.isAll) {
                const count = this.selected.size;
                label = count === 1 ? '1 Store' : `${count} Stores`; 
                // Could lookup name if single, but generic is fine for now
            }
            document.getElementById(`label_${this.filterId}`).textContent = label;
            
            window.history.pushState({}, '', url);

            // Reload or Callback
            if (typeof window.handleDateChange === 'function') {
                // Reuse the existing reload handler for now
                window.handleDateChange(url.toString(), this.filterId, val); 
            }
        }
    };
}
window.storeFilter = new StoreMultiFilter('<?php echo $filterId; ?>', '<?php echo $paramName; ?>');
</script>
