<?php
/**
 * Renders a premium custom select dropdown component.
 * 
 * @param string $label The placeholder label when no value is selected.
 * @param string $name The name attribute for the hidden input field.
 * @param array $options Associative array of value => label options.
 * @param string $selectedVal The initially selected value.
 * @param string $wrapperClass Additional classes for the container.
 * @param string $btnClass Additional classes for the trigger button.
 * @return string The HTML for the custom select component.
 */
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) { $selectedLabel = $text; break; }
    }
    if ($selectedVal === '' && !empty($options)) { 
        $selectedVal = array_key_first($options); 
        $selectedLabel = $options[$selectedVal]; 
    }
    
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $isActive = ((string)$val === (string)$selectedVal);
        $activeClass = $isActive ? 'active shadow-sm bg-orange-50 dark:bg-primary/10' : '';
        $checkOpacity = $isActive ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2.5 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-xl cursor-pointer transition-all ' . $activeClass . '" 
             data-value="' . htmlspecialchars($val) . '" 
             data-label="' . htmlspecialchars($text) . '">
            <span class="truncate font-medium">' . htmlspecialchars($text) . '</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 ' . $checkOpacity . ' transition-opacity duration-200 check-icon"></ion-icon>
        </div>';
    }
    
    return '
    <div class="relative custom-select-container ' . $wrapperClass . '">
        <input type="hidden" name="' . htmlspecialchars($name) . '" value="' . htmlspecialchars($selectedVal) . '">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-4 focus:ring-orange-500/10 focus:border-primary transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group ' . $btnClass . '">
            <span class="truncate select-label">' . htmlspecialchars($selectedLabel) . '</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-300 group-focus:text-primary"></ion-icon>
        </button>
        <div class="custom-select-dropdown absolute top-full left-0 mt-2 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-[1.25rem] shadow-2xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-300 overflow-hidden z-[100] max-h-64 overflow-y-auto custom-scrollbar">
            <div class="p-1.5 space-y-1">
                ' . $optionsHtml . '
            </div>
        </div>
    </div>';
}
?>
