<?php
include 'includes/session.php';
$pageTitle = "Create GRN";
$currentPage = "grn";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

// Custom Select Helper
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    // Identify selected label
    $selectedLabel = $label; // Default fallback
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    if ($selectedVal === '' && !empty($options)) {
        $selectedVal = array_key_first($options);
        $selectedLabel = $options[$selectedVal];
    }

    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'">
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }

    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            <div class="p-1 space-y-0.5">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}

require_once 'includes/header.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col sm:flex-row sm:items-center justify-between gap-6 relative z-20">
                <div class="flex items-center gap-4">
                    <!-- Back Button Removed -->
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Create GRN</h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm font-medium">Record incoming stock from suppliers.</p>
                    </div>
                </div>
                
                <div class="flex gap-3">
                     <button type="button" class="px-5 py-2.5 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-primary hover:border-primary/30 hover:bg-orange-50 dark:hover:bg-slate-700 rounded-xl text-sm font-semibold transition-all shadow-sm flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-lg"></ion-icon>
                        <span>Save Draft</span>
                    </button>
                    <button type="submit" form="grnForm" class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="checkmark-done-circle-outline" class="text-xl"></ion-icon> 
                        <span>Post GRN</span>
                    </button>
                </div>
            </div>

            <form id="grnForm" method="POST" class="space-y-6">
                <!-- General Info Card -->
                <div class="glass-panel rounded-2xl p-6 relative z-30">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white mb-6 flex items-center gap-2">
                        <ion-icon name="information-circle-outline" class="text-primary text-xl"></ion-icon>
                        General Information
                    </h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                        <div class="space-y-2">
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider px-1">Structure / Store <span class="text-red-500">*</span></label>
                            <?php 
                                echo renderCustomSelect('Select Store', 'store_id', [
                                    'cdf' => 'FNF Cardiff',
                                    'swa' => 'FNF Swansea',
                                    'npt' => 'FNF Newport'
                                ]); 
                            ?>
                        </div>
                        <div class="space-y-2">
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider px-1">Supplier <span class="text-red-500">*</span></label>
                            <?php 
                                echo renderCustomSelect('Select Supplier', 'supplier_id', [
                                    '101' => 'Local Farm Veg',
                                    '102' => 'Booker Wholesale',
                                    '103' => 'Bestway',
                                    '104' => 'Coca Cola'
                                ]); 
                            ?>
                        </div>
                         <div class="space-y-2">
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider px-1">Supplier Invoice # <span class="text-red-500">*</span></label>
                            <div class="relative">
                                <span class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-gray-400">
                                    <ion-icon name="receipt-outline"></ion-icon>
                                </span>
                                <input type="text" name="invoice_number" class="<?php echo $inputClass; ?> pl-10" placeholder="e.g. INV-2024-001" required>
                            </div>
                        </div>
                        <div class="space-y-2">
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider px-1">Purchase Order (Optional)</label>
                            <div class="relative">
                                <span class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-gray-400">
                                    <ion-icon name="document-text-outline"></ion-icon>
                                </span>
                                <input type="text" name="po_reference" class="<?php echo $inputClass; ?> pl-10" placeholder="Look up PO...">
                            </div>
                        </div>
                        <div class="space-y-2">
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider px-1">Received Date</label>
                            <?php 
                                $pickerId = 'received_at'; 
                                $urlParam = 'received_at';
                                $btnClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between cursor-pointer";
                                include 'includes/components/date_picker.php'; 
                            ?>
                            <input type="hidden" name="received_at" id="hidden_received_at" value="<?php echo $_GET['received_at'] ?? date('Y-m-d'); ?>">
                        </div>
                    </div>
                </div>

                <!-- Items Section -->
                <div class="glass-panel rounded-2xl overflow-hidden relative z-20">
                    <div class="p-4 border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50 flex flex-col sm:flex-row sm:items-center justify-between gap-4">
                        <h3 class="text-lg font-bold text-gray-800 dark:text-white flex items-center gap-2">
                            <ion-icon name="list-outline" class="text-primary text-xl"></ion-icon>
                            Items Received
                        </h3>
                         <div class="relative group w-full sm:w-80">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <ion-icon name="search-outline" class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                            </div>
                            <input type="text" id="productSearch" class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 pl-10 py-2 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400" placeholder="Search to add product (e.g. 'Cola')...">
                            
                            <!-- Search Results Dropdown (Hidden by default) -->
                            <div id="searchResults" class="absolute top-full left-0 mt-2 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl z-50 hidden max-h-60 overflow-y-auto custom-scrollbar">
                                <div class="p-2 space-y-1">
                                    <!-- Mock Results -->
                                    <div class="p-2 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer flex justify-between items-center group" onclick="addItem('Coca Cola 330ml', '1.20', '20')">
                                        <div>
                                            <div class="font-bold text-gray-700 dark:text-gray-200">Coca Cola 330ml</div>
                                            <div class="text-xs text-gray-500">SKU: COKE330</div>
                                        </div>
                                        <div class="text-sm font-bold text-gray-600 dark:text-gray-300">£1.20</div>
                                    </div>
                                    <div class="p-2 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer flex justify-between items-center group" onclick="addItem('Fries Large', '0.80', '0')">
                                        <div>
                                            <div class="font-bold text-gray-700 dark:text-gray-200">Fries Large</div>
                                            <div class="text-xs text-gray-500">SKU: FRIESL</div>
                                        </div>
                                        <div class="text-sm font-bold text-gray-600 dark:text-gray-300">£0.80</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="overflow-x-auto">
                        <table class="w-full text-left" id="grnTable">
                            <thead>
                                <tr class="bg-gray-50 dark:bg-slate-800/80 text-gray-500 dark:text-gray-400 text-xs uppercase tracking-wider font-bold">
                                    <th class="py-4 px-6 min-w-[200px]">Product</th>
                                    <th class="py-4 px-6 w-32 text-center">Batch / Expiry</th>
                                    <th class="py-4 px-6 w-24 text-center">Qty</th>
                                    <th class="py-4 px-6 w-32 text-right">Unit Cost</th>
                                    <th class="py-4 px-6 w-24 text-center">Tax %</th>
                                    <th class="py-4 px-6 w-32 text-right">Total (Ex)</th>
                                    <th class="py-4 px-6 w-16"></th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100 dark:divide-gray-700" id="grnTableBody">
                                <!-- Empty State -->
                                <tr id="emptyRow">
                                    <td colspan="7" class="py-12 text-center text-gray-400 italic">
                                        Use the search bar above to add products.
                                    </td>
                                </tr>
                            </tbody>
                            <tfoot class="bg-gray-50/50 dark:bg-slate-800/50 border-t border-gray-100 dark:border-gray-700">
                                <tr>
                                    <td colspan="4"></td>
                                    <td class="py-4 px-6 text-right font-bold text-gray-500 text-sm">Subtotal:</td>
                                    <td class="py-4 px-6 text-right font-bold text-gray-800 dark:text-white text-base">£<span id="subtotalDisplay">0.00</span></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td colspan="4"></td>
                                    <td class="py-4 px-6 text-right font-bold text-gray-500 text-sm">Tax:</td>
                                    <td class="py-4 px-6 text-right font-bold text-gray-800 dark:text-white text-base">£<span id="taxTotalDisplay">0.00</span></td>
                                    <td></td>
                                </tr>
                                 <tr class="bg-primary/5 dark:bg-primary/10">
                                    <td colspan="4"></td>
                                    <td class="py-4 px-6 text-right font-bold text-primary text-sm">Grand Total:</td>
                                    <td class="py-4 px-6 text-right font-bold text-primary text-xl">£<span id="grandTotalDisplay">0.00</span></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>

    // --- Date Picker Handler ---
    window.handleDateChange = async function(url, pickerId, formattedDate) {
        if(pickerId === 'received_at') {
            const hiddenInput = document.getElementById('hidden_received_at');
            if(hiddenInput) hiddenInput.value = formattedDate;
        }
    };

    // --- Consolidated Custom Select Logic (Delegated) ---
    function closeAllSelects() {
        document.querySelectorAll('.custom-select-container').forEach(container => {
            const dropdown = container.querySelector('.custom-select-dropdown');
            const trigger = container.querySelector('.custom-select-trigger');
            if (dropdown && !dropdown.classList.contains('invisible')) {
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                if (chevron) chevron.classList.remove('rotate-180', 'text-primary');
            }
        });
    }

    document.addEventListener('click', (e) => {
        // Toggle Trigger
        const trigger = e.target.closest('.custom-select-trigger');
        if (trigger) {
            e.stopPropagation();
            const container = trigger.closest('.custom-select-container');
            const dropdown = container.querySelector('.custom-select-dropdown');
            
            if (dropdown) {
                const wasOpen = !dropdown.classList.contains('invisible');
                closeAllSelects();
                
                if (!wasOpen) {
                    dropdown.classList.remove('opacity-0', 'invisible', '-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron) chevron.classList.add('rotate-180', 'text-primary');
                }
            }
            return;
        }

        // Option Click
        const option = e.target.closest('.custom-select-option');
        if (option) {
            e.stopPropagation();
            const container = option.closest('.custom-select-container');
            const hiddenInput = container.querySelector('input[type="hidden"]');
            const triggerLabel = container.querySelector('.select-label');
            const dropdown = container.querySelector('.custom-select-dropdown');
            const trigger = container.querySelector('.custom-select-trigger');

            hiddenInput.value = option.dataset.value;
            triggerLabel.textContent = option.dataset.label;

            container.querySelectorAll('.custom-select-option').forEach(opt => {
                opt.classList.remove('active');
                const check = opt.querySelector('.check-icon');
                if (check) check.classList.replace('opacity-100', 'opacity-0');
            });
            option.classList.add('active');
            const check = option.querySelector('.check-icon');
            if (check) check.classList.replace('opacity-0', 'opacity-100');

            closeAllSelects();
            return;
        }
        
        closeAllSelects();
    });

    // --- GRN Item Logic ---
    const searchInput = document.getElementById('productSearch');
    const searchResults = document.getElementById('searchResults');
    
    if (searchInput) {
        searchInput.addEventListener('focus', () => searchResults.classList.remove('hidden'));
        
        document.addEventListener('click', (e) => {
            if (!searchInput.contains(e.target) && !searchResults.contains(e.target)) {
                searchResults.classList.add('hidden');
            }
        });
    }

    function addItem(name, cost, taxRate) {
        const tbody = document.getElementById('grnTableBody');
        const emptyRow = document.getElementById('emptyRow');
        if (emptyRow) emptyRow.remove();

        const row = document.createElement('tr');
        row.className = "group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors border-b border-gray-50 dark:border-gray-700/50";
        row.innerHTML = `
            <td class="py-3 px-6">
                <div class="font-bold text-gray-700 dark:text-gray-200 text-sm">${name}</div>
                <input type="hidden" name="items[product_id][]" value="MOCK_ID">
                <input type="hidden" name="items[name][]" value="${name}">
            </td>
            <td class="py-3 px-6 text-center">
                 <input type="text" class="w-full bg-white dark:bg-slate-800 border-none outline-none focus:ring-1 focus:ring-primary rounded-lg text-xs text-center p-1" placeholder="Batch / Date">
            </td>
            <td class="py-3 px-6">
                <input type="number" name="items[qty][]" class="w-full bg-transparent border border-gray-200 dark:border-gray-600 rounded-lg px-2 py-1.5 text-center text-sm font-bold focus:border-primary focus:ring-0 outline-none qty-input" value="1" min="1" oninput="calculateTotals()">
            </td>
            <td class="py-3 px-6">
                 <div class="relative">
                     <span class="absolute left-2 top-1/2 -translate-y-1/2 text-gray-400 text-xs">£</span>
                     <input type="number" name="items[cost][]" class="w-full bg-transparent border border-gray-200 dark:border-gray-600 rounded-lg pl-5 pr-2 py-1.5 text-right text-sm font-medium focus:border-primary focus:ring-0 outline-none cost-input" value="${cost}" step="0.01" oninput="calculateTotals()">
                 </div>
            </td>
            <td class="py-3 px-6 text-center text-sm text-gray-600">
                <input type="hidden" name="items[tax_rate][]" class="tax-rate-input" value="${taxRate}">
                ${taxRate}%
            </td>
            <td class="py-3 px-6 text-right font-bold text-gray-700 dark:text-white text-sm row-total">
                £${parseFloat(cost).toFixed(2)}
            </td>
            <td class="py-3 px-6 text-center">
                <button type="button" class="text-gray-400 hover:text-red-500 transition-colors p-1" onclick="this.closest('tr').remove(); calculateTotals();">
                    <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                </button>
            </td>
        `;
        tbody.appendChild(row);
        calculateTotals();
        if (searchResults) searchResults.classList.add('hidden');
        if (searchInput) searchInput.value = '';
    }

    function calculateTotals() {
        let subtotal = 0;
        let taxTotal = 0;

        document.querySelectorAll('#grnTableBody tr').forEach(row => {
            if (row.id === 'emptyRow') return;

            const qty = parseFloat(row.querySelector('.qty-input').value) || 0;
            const cost = parseFloat(row.querySelector('.cost-input').value) || 0;
            const taxRate = parseFloat(row.querySelector('.tax-rate-input').value) || 0;

            const lineTotal = qty * cost;
            const lineTax = lineTotal * (taxRate / 100);

            subtotal += lineTotal;
            taxTotal += lineTax;

            const rowTotalDisplay = row.querySelector('.row-total');
            if (rowTotalDisplay) rowTotalDisplay.textContent = '£' + lineTotal.toFixed(2);
        });

        const grandTotal = subtotal + taxTotal;

        if (document.getElementById('subtotalDisplay')) document.getElementById('subtotalDisplay').textContent = subtotal.toFixed(2);
        if (document.getElementById('taxTotalDisplay')) document.getElementById('taxTotalDisplay').textContent = taxTotal.toFixed(2);
        if (document.getElementById('grandTotalDisplay')) document.getElementById('grandTotalDisplay').textContent = grandTotal.toFixed(2);
    }
</script>
