<?php
include 'includes/session.php';
$pageTitle = "Goods Received Notes";
$currentPage = "grn";
require_once 'includes/header.php';

// Mock Data
$grns = [
    [
        'id' => 'GRN-1005',
        'po' => 'PO-2023-899',
        'supplier' => 'Local Farm Veg',
        'store' => 'FNF Cardiff',
        'invoice' => 'INV-9921',
        'date' => '2026-01-16 09:30',
        'status' => 'Posted'
    ],
    [
        'id' => 'GRN-1006',
        'po' => 'PO-2024-001',
        'supplier' => 'Booker Wholesale',
        'store' => 'FNF Cardiff',
        'invoice' => '-',
        'date' => '2026-01-16 14:15',
        'status' => 'Draft'
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header (Glass Panel) -->
            <div class="glass-panel p-6 rounded-2xl flex flex-col xl:flex-row justify-between items-center gap-6 relative z-50 overflow-visible bg-white dark:bg-slate-800 shadow-sm border border-gray-100 dark:border-gray-700">
                <div class="flex items-center gap-4">
                    <div class="h-12 w-12 rounded-xl bg-gradient-to-br from-orange-500 to-orange-600 flex items-center justify-center shadow-lg shadow-orange-500/30 text-white">
                        <ion-icon name="documents-outline" class="text-2xl"></ion-icon>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Purchase Invoices / GRN</h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm font-medium">Receive stock against purchase orders.</p>
                    </div>
                </div>
                
                <!-- Controls Bar -->
                <div class="flex flex-col sm:flex-row items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-1.5 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">
                    
                     <!-- Store Filter -->
                    <div class="relative z-50">
                        <button id="grnStoreFilterBtn" onclick="toggleGrnStoreDropdown()" class="flex items-center gap-2 px-3 py-2 text-sm font-medium text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-white dark:hover:bg-slate-700 rounded-lg transition-colors whitespace-nowrap cursor-pointer">
                            <ion-icon name="storefront-outline" class="text-gray-400"></ion-icon>
                            <span id="grnStoreFilterText">All Stores</span>
                            <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 ml-1 transition-transform duration-300"></ion-icon>
                        </button>
                        
                        <!-- Dropdown Menu -->
                        <div id="grnStoreFilterDropdown" class="absolute top-full right-0 sm:left-auto sm:right-0 mt-2 w-64 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 z-50 p-2 space-y-1 opacity-0 invisible transform -translate-y-2 transition-all duration-200">
                            <!-- All Stores -->
                            <button class="grn-store-option w-full flex items-center justify-between p-2 rounded-lg bg-gray-50 dark:bg-slate-700/50 text-gray-800 dark:text-gray-200 transition-colors active" onclick="selectGrnStore('all', 'All Stores', this)">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-orange-100 dark:bg-orange-500/20 flex items-center justify-center text-orange-600 dark:text-orange-400">
                                        <ion-icon name="storefront" class="text-lg"></ion-icon>
                                    </div>
                                    <span class="font-medium text-sm">All Stores</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-100"></ion-icon>
                            </button>
                             <!-- FNF Cardiff -->
                            <button class="grn-store-option w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group" onclick="selectGrnStore('cdf', 'FNF Cardiff', this)">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-blue-50 dark:bg-blue-900/20 flex items-center justify-center text-blue-600 dark:text-blue-400 text-xs font-bold">
                                        CDF
                                    </div>
                                    <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">FNF Cardiff</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                            </button>
                            <!-- FNF Swansea -->
                            <button class="grn-store-option w-full flex items-center justify-between p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 text-gray-600 dark:text-gray-300 transition-colors group" onclick="selectGrnStore('swa', 'FNF Swansea', this)">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-emerald-50 dark:bg-emerald-900/20 flex items-center justify-center text-emerald-600 dark:text-emerald-400 text-xs font-bold">
                                        SWA
                                    </div>
                                    <span class="font-medium text-sm group-hover:text-gray-900 dark:group-hover:text-white">FNF Swansea</span>
                                </div>
                                <ion-icon name="checkmark-circle" class="text-orange-500 text-lg check-icon opacity-0"></ion-icon>
                            </button>
                        </div>
                    </div>

                    <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                    <!-- Date Filter (Reusable Component) -->
                    <?php 
                    $pickerId = 'grn';
                    $showApplyButton = false;
                    include 'includes/components/date_picker.php'; 
                    ?>

                    <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>
                    
                    <!-- Create Button (Secondary Style) -->
                    <!-- Create Button (Secondary Style) -->
                    <a href="grn_form.php" class="flex items-center gap-2 px-3 py-2 text-primary font-bold text-sm hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors shrink-0 whitespace-nowrap">
                        <ion-icon name="add-circle-outline" class="text-lg"></ion-icon>
                        <span>Create</span>
                    </a>
                    
                    <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                    <!-- Export Button (Primary Style) -->
                    <button class="px-4 py-2 text-sm font-bold rounded-lg bg-primary hover:bg-orange-600 text-white shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all flex items-center gap-2">
                        <ion-icon name="download-outline" class="text-lg"></ion-icon>
                        <span>Export</span>
                    </button>
                </div>
            </div>

            <!-- GRN Table -->
            <div class="glass-panel rounded-2xl overflow-visible shadow-sm min-h-[500px]">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                            <!-- GRN # Filter -->
                            <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider relative group w-[180px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-grn" class="transition-colors duration-200">GRN #</span>
                                    <button onclick="toggleSearchPopup('searchPopup-grn')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-grn" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search GRN</span>
                                        <ion-icon name="barcode-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-grn" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="GRN ID...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('grn')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('grn')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>

                             <!-- Store Filter (New) -->
                             <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center w-[120px]">
                                Store
                            </th>

                            <!-- Supplier & PO Filter -->
                            <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider relative group w-[250px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-supplier" class="transition-colors duration-200">Supplier & PO</span>
                                    <button onclick="toggleSearchPopup('searchPopup-supplier')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-supplier" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Supplier</span>
                                        <ion-icon name="people-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-supplier" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Supplier or PO...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('supplier')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('supplier')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>

                             <!-- Invoice Ref Filter -->
                             <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider relative group w-[180px]">
                                <div class="flex items-center justify-between">
                                    <span id="header-invoice" class="transition-colors duration-200">Invoice Ref</span>
                                    <button onclick="toggleSearchPopup('searchPopup-invoice')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="search-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-invoice" class="absolute top-full left-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-left backdrop-blur-xl">
                                    <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Search Invoice</span>
                                        <ion-icon name="receipt-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="relative mb-3 group/input">
                                        <ion-icon name="search" class="absolute left-3 top-2.5 text-gray-400 group-focus-within/input:text-primary transition-colors text-sm"></ion-icon>
                                        <input type="text" id="input-invoice" class="w-full pl-8 pr-3 py-2 bg-gray-50 dark:bg-slate-700/50 border border-transparent focus:border-primary/30 focus:bg-white dark:focus:bg-slate-700 focus:ring-4 focus:ring-primary/10 rounded-xl text-xs font-medium text-gray-800 dark:text-white placeholder-gray-400 outline-none transition-all" placeholder="Invoice #...">
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('invoice')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('invoice')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>
                            
                            <!-- Date -->
                            <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">
                                Date
                            </th>

                             <!-- Updated By (New) -->
                             <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center w-[150px]">
                                Updated By
                            </th>
                            
                             <!-- Status Filter -->
                             <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider relative group text-center w-[150px]">
                                <div class="flex items-center justify-center gap-2">
                                    <span id="header-status" class="transition-colors duration-200">Status</span>
                                    <button onclick="toggleSearchPopup('searchPopup-status')" class="w-7 h-7 rounded-lg flex items-center justify-center text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 transition-all hover:scale-105">
                                        <ion-icon name="filter-outline" class="text-sm"></ion-icon>
                                    </button>
                                </div>
                                <div id="searchPopup-status" class="absolute top-full right-0 mt-3 w-[220px] bg-white dark:bg-slate-800 rounded-2xl shadow-2xl shadow-gray-200/50 dark:shadow-black/50 border border-gray-100 dark:border-gray-700/80 p-3 z-50 invisible opacity-0 transform translate-y-4 transition-all duration-300 ease-out origin-top-right backdrop-blur-xl text-left">
                                     <div class="flex items-center justify-between mb-3 px-1">
                                        <span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Filter Status</span>
                                        <ion-icon name="options-outline" class="text-primary text-base"></ion-icon>
                                    </div>
                                    <div class="space-y-2 mb-3">
                                        <label class="flex items-center gap-2 p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 cursor-pointer">
                                            <input type="radio" name="statusFilter" class="text-primary focus:ring-primary border-gray-300 dark:border-gray-600 bg-gray-100 dark:bg-slate-700" value="all" checked>
                                            <span class="text-sm text-gray-600 dark:text-gray-300">All Statuses</span>
                                        </label>
                                        <label class="flex items-center gap-2 p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 cursor-pointer">
                                            <input type="radio" name="statusFilter" class="text-primary focus:ring-primary border-gray-300 dark:border-gray-600 bg-gray-100 dark:bg-slate-700" value="posted">
                                            <span class="text-sm text-gray-600 dark:text-gray-300">Posted</span>
                                        </label>
                                        <label class="flex items-center gap-2 p-2 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700/50 cursor-pointer">
                                            <input type="radio" name="statusFilter" class="text-primary focus:ring-primary border-gray-300 dark:border-gray-600 bg-gray-100 dark:bg-slate-700" value="draft">
                                            <span class="text-sm text-gray-600 dark:text-gray-300">Draft</span>
                                        </label>
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <button onclick="clearTextFilter('status')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-gray-500 hover:text-gray-700 hover:bg-gray-100 dark:text-gray-400 dark:hover:bg-slate-700 transition-colors">Clear</button>
                                        <button onclick="applyTextFilter('status')" class="py-1.5 px-3 rounded-xl text-xs font-bold text-white bg-gradient-to-r from-orange-500 to-orange-600 hover:from-orange-600 hover:to-orange-700 shadow-lg shadow-orange-500/20 active:scale-95 transition-all">Apply</button>
                                    </div>
                                </div>
                            </th>
                            
                            <th class="py-4 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                        <?php foreach ($grns as $grn): ?>
                        <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                            <td class="py-4 px-6">
                                <div class="text-sm font-bold text-gray-800 dark:text-white"><?php echo $grn['id']; ?></div>
                            </td>
                            <!-- Store (Dummy) -->
                            <td class="py-4 px-6 text-center">
                                <span class="inline-flex items-center px-2 py-1 rounded-md bg-white dark:bg-slate-700 border border-gray-200 dark:border-gray-600 text-xs font-bold text-gray-600 dark:text-gray-300 shadow-sm">
                                    CDF
                                </span>
                            </td>
                            <td class="py-4 px-6">
                                <div class="text-sm font-bold text-gray-700 dark:text-gray-200"><?php echo $grn['supplier']; ?></div>
                                <div class="text-xs text-blue-500 font-medium"><?php echo $grn['po']; ?></div>
                            </td>
                             <td class="py-4 px-6">
                                <div class="text-sm font-mono text-gray-600 dark:text-gray-400"><?php echo $grn['invoice']; ?></div>
                            </td>
                            <td class="py-4 px-6 text-center">
                                <div class="text-sm text-gray-500"><?php echo date('H:i d/m', strtotime($grn['date'])); ?></div>
                            </td>
                             <!-- Updated By (Dummy) -->
                             <td class="py-4 px-6 text-center">
                                <div class="text-xs font-medium text-gray-900 dark:text-white">Admin</div>
                                <div class="text-[10px] text-gray-400"><?php echo date('d M H:i'); ?></div>
                            </td>
                            <td class="py-4 px-6 text-center">
                                <?php if ($grn['status'] == 'Draft'): ?>
                                    <span class="inline-flex items-center px-2 py-1 rounded bg-gray-100 dark:bg-slate-700 text-xs font-medium text-gray-600 dark:text-gray-300">Draft</span>
                                <?php else: ?>
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-full bg-green-100 text-green-700 dark:bg-green-900/30 dark:text-green-400 text-xs font-bold border border-green-200 dark:border-green-800">Posted</span>
                                <?php endif; ?>
                            </td>
                            <td class="py-4 px-6 text-right">
                                <div class="flex items-center justify-end gap-2">
                                     <button class="w-8 h-8 flex items-center justify-center bg-gray-50 dark:bg-slate-700/50 text-blue-500 rounded-lg hover:bg-blue-50 hover:text-blue-600 dark:hover:bg-blue-900/20 dark:hover:text-blue-400 transition-colors" title="Edit">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <button class="w-8 h-8 flex items-center justify-center bg-gray-50 dark:bg-slate-700/50 text-red-500 rounded-lg hover:bg-red-50 hover:text-red-600 dark:hover:bg-red-900/20 dark:hover:text-red-400 transition-colors" title="Delete">
                                        <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>

    <script>
    // --- Store Dropdown Logic ---
    function toggleGrnStoreDropdown() {
        const dropdown = document.getElementById('grnStoreFilterDropdown');
        const btn = document.getElementById('grnStoreFilterBtn');
        const icon = btn.querySelector('ion-icon[name="chevron-down-outline"]');
        if (dropdown && dropdown.classList.contains('invisible')) {
            dropdown.classList.remove('invisible', 'opacity-0', '-translate-y-2');
            if(icon) icon.classList.add('rotate-180');
        } else if (dropdown) {
            dropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
            if(icon) icon.classList.remove('rotate-180');
        }
    }

    function selectGrnStore(value, label, optionBtn) {
        document.getElementById('grnStoreFilterText').textContent = label;
        // Reset active state
        document.querySelectorAll('.grn-store-option').forEach(btn => {
            const check = btn.querySelector('.check-icon');
            btn.classList.remove('bg-gray-50', 'dark:bg-slate-700/50', 'active');
            if(check) check.classList.add('opacity-0');
        });
        // Set new active state
        optionBtn.classList.add('bg-gray-50', 'dark:bg-slate-700/50', 'active');
        const check = optionBtn.querySelector('.check-icon');
        if(check) check.classList.remove('opacity-0');
        // Close dropdown
        toggleGrnStoreDropdown();
    }
    
    // Close dropdown on click outside
    document.addEventListener('click', (e) => {
        const storeBtn = document.getElementById('grnStoreFilterBtn');
        const storeDropdown = document.getElementById('grnStoreFilterDropdown');
        if (storeBtn && storeDropdown && !storeBtn.contains(e.target) && !storeDropdown.contains(e.target)) {
            storeDropdown.classList.add('invisible', 'opacity-0', '-translate-y-2');
            const icon = storeBtn.querySelector('ion-icon[name="chevron-down-outline"]');
            if(icon) icon.classList.remove('rotate-180');
        }
    });

    // --- Apply Function (Simulated) ---
    function applyFilters() {
        const store = document.getElementById('grnStoreFilterText').textContent;
        // Removed alert as per user request
        console.log(`Applying filters: Store = ${store}`);
        
        // Visual feedback
        const btn = document.querySelector('button[onclick="applyFilters()"]');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<ion-icon name="checkmark-outline" class="text-lg"></ion-icon> Applied';
        btn.classList.add('bg-green-600', 'hover:bg-green-700');
        btn.classList.remove('bg-primary', 'hover:bg-orange-600');
        
        setTimeout(() => {
            btn.innerHTML = originalText;
            btn.classList.remove('bg-green-600', 'hover:bg-green-700');
            btn.classList.add('bg-primary', 'hover:bg-orange-600');
        }, 1500);
    }
    
    // --- Table Search Logic ---
    function toggleSearchPopup(popupId) {
        // Close all others first
        document.querySelectorAll('[id^="searchPopup-"]').forEach(el => {
            if(el.id !== popupId) {
                el.classList.add('invisible', 'opacity-0', 'translate-y-4');
            }
        });

        const popup = document.getElementById(popupId);
        if(popup) {
            if(popup.classList.contains('invisible')) {
                popup.classList.remove('invisible', 'opacity-0', 'translate-y-4');
            } else {
                popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
            }
        }
    }

    // Close on click outside (Table Popups)
    document.addEventListener('click', (e) => {
        if (!e.target.closest('th')) {
            document.querySelectorAll('[id^="searchPopup-"]').forEach(el => {
                 el.classList.add('invisible', 'opacity-0', 'translate-y-4');
            });
        }
    });

    // Prevent closing when clicking inside the popup
    document.querySelectorAll('[id^="searchPopup-"]').forEach(popup => {
        popup.addEventListener('click', (e) => {
            e.stopPropagation();
        });
    });

    function applyTextFilter(type) {
        // Just mock visual update
        const header = document.getElementById('header-' + type);
        const popupId = 'searchPopup-' + type;
        const input = document.getElementById('input-' + type);
        // For radio buttons (status)
        let hasValue = false;
        
        if(input) {
            hasValue = input.value.trim() !== "";
        } else {
            // Check radio
            const radios = document.getElementsByName(type + 'Filter');
            for(let r of radios) {
                if(r.checked && r.value !== 'all') hasValue = true;
            }
        }

        if (hasValue) {
            header.classList.add('text-primary');
        } else {
            header.classList.remove('text-primary');
        }
        
        const popup = document.getElementById(popupId);
        popup.classList.add('invisible', 'opacity-0', 'translate-y-4');
    }

    function clearTextFilter(type) {
        const header = document.getElementById('header-' + type);
        const input = document.getElementById('input-' + type);
        if(input) input.value = "";
        
        // Reset radio if exists
        const radios = document.getElementsByName(type + 'Filter');
        if(radios.length > 0) {
            for(let r of radios) if(r.value === 'all') r.checked = true;
        }

        header.classList.remove('text-primary');
    }
    </script>
</main>
