<?php
include 'includes/session.php';
// finance_debtors.php - Customers of our Customers (Store Debtors)
$pageTitle = "Finance: Store Debtors";
$currentPage = "finance_debtors";
require_once 'includes/header.php';

// Mock Data for Store Debtors (End Customers owing money to stores)
$debtors = [
    [
        'id' => 'CUST-001',
        'name' => 'John Smith',
        'store' => 'FNF Cardiff',
        'balance' => '45.50',
        'last_payment' => '2026-01-10',
        'status' => 'Active',
        'contact' => '07700 900123'
    ],
    [
        'id' => 'CUST-089',
        'name' => 'Sarah Jones',
        'store' => 'Newport Express',
        'balance' => '120.00',
        'last_payment' => '2025-12-15',
        'status' => 'Blocked',
        'contact' => '07700 900456'
    ],
    [
        'id' => 'CUST-112',
        'name' => 'Mike Williams',
        'store' => 'FNF Cardiff',
        'balance' => '12.99',
        'last_payment' => '2026-01-20',
        'status' => 'Active',
        'contact' => '07700 900789'
    ],
    [
        'id' => 'CUST-203',
        'name' => 'Emma Brown',
        'store' => 'London Main',
        'balance' => '250.00',
        'last_payment' => '2025-11-20',
        'status' => 'Blocked',
        'contact' => '07700 900987'
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div
                class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-10">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Store Debtors</h1>
                    <p class="text-gray-500 dark:text-gray-400 mt-1">Manage end-customers who owe money to store
                        partners.</p>
                </div>

                <div
                    class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto">
                    <div class="relative group w-full sm:w-64 shrink-0">
                        <div class="absolute inset-y-0 left-0 pl-3.5 flex items-center pointer-events-none">
                            <ion-icon name="search-outline"
                                class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                        </div>
                        <input type="text"
                            class="w-full bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-lg pl-10 pr-4 py-2 text-sm focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all outline-none"
                            placeholder="Search Customer...">
                    </div>

                    <div class="h-8 w-px bg-gray-200 dark:bg-gray-700 mx-1 hidden sm:block"></div>

                    <button
                        class="p-2 text-gray-500 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/20 rounded-lg transition-all"
                        title="Filter List">
                        <ion-icon name="filter-outline" class="text-xl"></ion-icon>
                    </button>

                    <button
                        class="p-2 text-gray-500 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/20 rounded-lg transition-all"
                        title="Export List">
                        <ion-icon name="download-outline" class="text-xl"></ion-icon>
                    </button>
                </div>
            </div>

            <!-- Debtors Table -->
            <div
                class="glass-panel rounded-2xl overflow-hidden shadow-sm border border-gray-100 dark:border-gray-700/50">
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr
                                class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Customer Details</th>
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Store</th>
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">
                                    Balance Due</th>
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">
                                    Status</th>
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Last Payment</th>
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">
                                    Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700/50">
                            <?php foreach ($debtors as $cust): ?>
                                <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/30 transition-all">
                                    <td class="py-5 px-6">
                                        <div class="flex items-center gap-4">
                                            <div
                                                class="w-10 h-10 rounded-xl bg-gray-100 dark:bg-slate-700 flex items-center justify-center text-gray-500 dark:text-gray-400 shadow-sm border border-gray-200/50 dark:border-gray-600/30">
                                                <ion-icon name="person-outline" class="text-xl"></ion-icon>
                                            </div>
                                            <div>
                                                <div
                                                    class="text-sm font-bold text-gray-800 dark:text-white group-hover:text-primary transition-colors">
                                                    <?php echo $cust['name']; ?>
                                                </div>
                                                <div
                                                    class="text-[11px] font-medium text-gray-400 uppercase tracking-wider mt-0.5">
                                                    <?php echo $cust['contact']; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="py-5 px-6">
                                        <div
                                            class="flex items-center gap-1.5 text-sm text-gray-700 dark:text-gray-200 font-medium">
                                            <ion-icon name="storefront-outline" class="text-gray-400"></ion-icon>
                                            <?php echo $cust['store']; ?>
                                        </div>
                                    </td>
                                    <td class="py-5 px-6 text-center">
                                        <div class="text-sm font-bold text-gray-700 dark:text-gray-200">£
                                            <?php echo $cust['balance']; ?>
                                        </div>
                                    </td>
                                    <td class="py-5 px-6 text-center">
                                        <?php
                                        $statusClass = '';
                                        $dotClass = '';
                                        if ($cust['status'] == 'Active') {
                                            $statusClass = 'bg-emerald-50 dark:bg-emerald-900/20 text-emerald-600 dark:text-emerald-400 border-emerald-100 dark:border-emerald-800/50';
                                            $dotClass = 'bg-emerald-500';
                                        } elseif ($cust['status'] == 'Blocked') {
                                            $statusClass = 'bg-red-50 dark:bg-red-900/20 text-red-600 dark:text-red-400 border-red-100 dark:border-red-800/50';
                                            $dotClass = 'bg-red-500';
                                        }
                                        ?>
                                        <span
                                            class="inline-flex items-center px-2.5 py-1 rounded-lg text-[11px] font-bold border <?php echo $statusClass; ?>">
                                            <span class="w-1.5 h-1.5 rounded-full <?php echo $dotClass; ?> mr-2"></span>
                                            <?php echo strtoupper($cust['status']); ?>
                                        </span>
                                    </td>
                                    <td class="py-5 px-6">
                                        <div
                                            class="flex items-center gap-2 text-sm text-gray-600 dark:text-gray-400 font-medium">
                                            <ion-icon name="calendar-outline" class="text-gray-400"></ion-icon>
                                            <?php echo date('M d, Y', strtotime($cust['last_payment'])); ?>
                                        </div>
                                    </td>
                                    <td class="py-5 px-6 text-right">
                                        <div
                                            class="flex items-center justify-end gap-2 opacity-0 group-hover:opacity-100 transition-all transform translate-x-2 group-hover:translate-x-0">
                                            <button
                                                class="p-2 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-500 hover:text-primary hover:border-primary/30 rounded-xl shadow-sm transition-all"
                                                title="View Statement">
                                                <ion-icon name="document-text-outline" class="text-lg"></ion-icon>
                                            </button>
                                            <button
                                                class="p-2 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-500 hover:text-red-600 hover:border-red-500/30 rounded-xl shadow-sm transition-all"
                                                title="Block Customer">
                                                <ion-icon name="ban-outline" class="text-lg"></ion-icon>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Simple Pagination -->
                <div
                    class="p-6 bg-gray-50/50 dark:bg-slate-800/50 border-t border-gray-100 dark:border-gray-700/50 flex flex-col sm:flex-row items-center justify-between gap-4">
                    <p class="text-xs font-bold text-gray-500 uppercase tracking-widest">Showing 4 Debtors</p>
                    <div class="flex gap-2">
                        <button
                            class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl text-xs font-bold text-gray-600 dark:text-gray-400 hover:border-primary hover:text-primary transition-all disabled:opacity-50"
                            disabled>Previous</button>
                        <div class="flex gap-1">
                            <button
                                class="w-9 h-9 flex items-center justify-center rounded-xl bg-primary text-white text-xs font-bold shadow-lg shadow-orange-500/30">1</button>
                        </div>
                        <button
                            class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl text-xs font-bold text-gray-600 dark:text-gray-400 hover:border-primary hover:text-primary transition-all disabled:opacity-50"
                            disabled>Next</button>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>