<?php
include 'includes/session.php';
// employees.php - Employee (Till Staff) Management
$pageTitle = "Employees (Till Staff)";
$currentPage = "employees";
require_once 'includes/header.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        
        <!-- Header -->
        <div class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 animate-fade-in-down relative z-50 overflow-visible">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Employees</h1>
                <p class="text-gray-500 dark:text-gray-400 mt-1">Manage till staff, PINs, and wage rates.</p>
            </div>
            
            <!-- Controls Bar -->
            <div class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">
                
                <!-- Search -->
                <div class="relative group w-full sm:w-48 shrink-0">
                    <ion-icon name="search-outline" class="absolute left-2 top-2.5 text-gray-400 group-focus-within:text-primary transition-colors text-lg"></ion-icon>
                    <input type="text" id="employeeSearch" class="pl-8 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none w-full text-sm text-gray-600 dark:text-gray-200 placeholder-gray-400 font-medium bg-transparent" placeholder="Search staff...">
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>
                
                <!-- Filter: Store -->
                <div class="relative z-30" id="storeFilter">
                    <button id="storeFilterBtn" class="flex items-center gap-2 px-3 py-2 bg-transparent hover:bg-white dark:hover:bg-slate-700 rounded-lg text-sm text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white transition-all border border-transparent hover:border-gray-200 dark:hover:border-gray-600 min-w-[140px] justify-between">
                        <div class="flex items-center gap-2">
                             <ion-icon name="storefront-outline" class="text-gray-400 text-lg"></ion-icon>
                            <span id="currentStoreFilter" class="font-medium">All Stores</span>
                        </div>
                        <ion-icon name="chevron-down-outline" class="text-xs text-gray-400 h-3 w-3 transition-transform duration-300"></ion-icon>
                    </button>
                    <!-- Dropdown -->
                    <div id="storeFilterDropdown" class="absolute top-full left-0 mt-2 w-56 bg-white dark:bg-slate-800 rounded-xl shadow-xl border border-gray-100 dark:border-gray-700 invisible opacity-0 -translate-y-2 transition-all duration-200 z-50">
                        <div class="p-1">
                             <div class="store-filter-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors active" data-value="all" data-label="All Stores">
                                <span class="truncate">All Stores</span>
                                <ion-icon name="checkmark-outline" class="text-primary check-icon opacity-100"></ion-icon>
                            </div>
                            <div class="store-filter-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors" data-value="1001" data-label="FNF Cardiff">
                                <span class="truncate">FNF Cardiff</span>
                                <ion-icon name="checkmark-outline" class="text-primary check-icon opacity-0"></ion-icon>
                            </div>
                             <div class="store-filter-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors" data-value="1002" data-label="FNF Swansea">
                                <span class="truncate">FNF Swansea</span>
                                <ion-icon name="checkmark-outline" class="text-primary check-icon opacity-0"></ion-icon>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Bulk Import -->
                 <button class="flex items-center gap-2 px-3 py-2 text-gray-600 dark:text-gray-400 font-bold text-sm hover:bg-gray-100 dark:hover:bg-slate-700 rounded-lg transition-colors shrink-0 whitespace-nowrap" onclick="showToast('Bulk Import coming soon!', 'info')">
                    <ion-icon name="cloud-upload-outline" class="text-lg"></ion-icon>
                    <span class="hidden sm:inline">Import</span>
                </button>

                <!-- Create Employee -->
                <a href="employee_form.php" class="flex items-center gap-2 px-3 py-2 text-primary font-bold text-sm hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors shrink-0 whitespace-nowrap">
                    <ion-icon name="person-add-outline" class="text-lg"></ion-icon>
                    <span>Add Employee</span>
                </a>

            </div>
        </div>

        <!-- Data Table -->
        <div class="glass-panel rounded-2xl overflow-hidden animate-fade-in-up delay-100 relative z-0">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                            <th class="p-4 pl-6 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Employee</th>
                            <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Store</th>
                            <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Role</th>
                            <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">Wage Rate</th>
                            <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">PIN Status</th>
                            <th class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider text-center">Status</th>
                            <th class="p-4 pr-6 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody id="employeesTableBody" class="divide-y divide-gray-100 dark:divide-gray-700">
                        <!-- Mock Row 1 -->
                        <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                            <td class="p-4 pl-6">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-full bg-orange-100 dark:bg-orange-900/30 text-orange-600 dark:text-orange-400 flex items-center justify-center font-bold text-sm">
                                        JD
                                    </div>
                                    <div>
                                        <div class="font-semibold text-gray-800 dark:text-white">John Doe</div>
                                        <div class="text-xs text-gray-400">Senior Cashier</div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-4">
                                <span class="inline-flex items-center gap-1 text-xs font-medium text-gray-600 dark:text-gray-400">
                                    <ion-icon name="storefront-outline"></ion-icon> FNF Cardiff
                                </span>
                            </td>
                            <td class="p-4">
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-700 dark:text-gray-300">
                                    Cashier
                                </span>
                            </td>
                            <td class="p-4">
                                <div class="text-sm font-medium text-gray-700 dark:text-gray-300">£11.50 / hr</div>
                            </td>
                            <td class="p-4">
                                <span class="inline-flex items-center gap-1 text-xs text-green-600 dark:text-green-400 font-medium">
                                    <ion-icon name="checkmark-circle"></ion-icon> Set
                                    <span class="text-gray-400 dark:text-gray-500 font-normal ml-1">(2 days ago)</span>
                                </span>
                            </td>
                            <td class="p-4 text-center">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400 border border-green-200 dark:border-green-800">
                                    Active
                                </span>
                            </td>
                            <td class="p-4 pr-6 text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <button onclick="openPrintModal('John Doe', '1234')" class="p-1.5 rounded-lg transition-colors text-blue-600 bg-blue-50 hover:bg-blue-100 dark:text-blue-400 dark:bg-blue-900/20 border border-blue-100 dark:border-blue-800/30" title="Print PIN Card">
                                        <ion-icon name="print-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <button onclick="openResetPinModal('John Doe')" class="p-1.5 rounded-lg transition-colors text-purple-600 bg-purple-50 hover:bg-purple-100 dark:text-purple-400 dark:bg-purple-900/20 border border-purple-100 dark:border-purple-800/30" title="Reset PIN">
                                        <ion-icon name="key-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <a href="employee_form.php?id=1" class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </a>
                                </div>
                            </td>
                        </tr>

                         <!-- Mock Row 2 -->
                        <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                            <td class="p-4 pl-6">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-full bg-purple-100 dark:bg-purple-900/30 text-purple-600 dark:text-purple-400 flex items-center justify-center font-bold text-sm">
                                        AM
                                    </div>
                                    <div>
                                        <div class="font-semibold text-gray-800 dark:text-white">Anna Miller</div>
                                        <div class="text-xs text-gray-400">Trainee</div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-4">
                                <span class="inline-flex items-center gap-1 text-xs font-medium text-gray-600 dark:text-gray-400">
                                    <ion-icon name="storefront-outline"></ion-icon> FNF Swansea
                                </span>
                            </td>
                            <td class="p-4">
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-700 dark:text-gray-300">
                                    Cashier
                                </span>
                            </td>
                            <td class="p-4">
                                <div class="text-sm font-medium text-gray-700 dark:text-gray-300">£10.50 / hr</div>
                            </td>
                            <td class="p-4">
                                <span class="inline-flex items-center gap-1 text-xs text-red-500 font-medium">
                                    <ion-icon name="alert-circle-outline"></ion-icon> Not Set
                                </span>
                            </td>
                             <td class="p-4 text-center">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-300 border border-gray-200 dark:border-gray-600">
                                    On Leave
                                </span>
                            </td>
                            <td class="p-4 pr-6 text-right">
                                <div class="flex items-center justify-end gap-2">
                                     <button onclick="openResetPinModal('Anna Miller')" class="p-1.5 rounded-lg transition-colors text-purple-600 bg-purple-50 hover:bg-purple-100 dark:text-purple-400 dark:bg-purple-900/20 border border-purple-100 dark:border-purple-800/30" title="Reset PIN">
                                        <ion-icon name="key-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <a href="employee_form.php?id=2" class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors" title="Edit">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

             <!-- Pagination Footer -->
            <div class="px-6 py-4 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between bg-white dark:bg-slate-800">
                <span class="pagination-text text-xs text-gray-500 dark:text-gray-400 font-medium" id="paginationInfo">
                    Showing 2 of 2 employees
                </span>
                <div class="flex items-center gap-2">
                    <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center disabled:opacity-50 disabled:hover:bg-gray-50 disabled:hover:text-gray-500 cursor-pointer disabled:cursor-not-allowed group" disabled>
                        <ion-icon name="chevron-back-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                    <button class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center cursor-pointer group" disabled>
                        <ion-icon name="chevron-forward-outline" class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Reset PIN Modal -->
    <div id="resetPinModal" class="fixed inset-0 z-[100] hidden">
        <div class="absolute inset-0 bg-black/50 backdrop-blur-sm transition-opacity opacity-0" id="resetPinOverlay"></div>
        <div class="absolute inset-0 flex items-center justify-center p-4">
            <div class="bg-white dark:bg-slate-800 rounded-2xl shadow-xl w-full max-w-sm transform scale-95 opacity-0 transition-all" id="resetPinContent">
                <div class="p-6 border-b border-gray-100 dark:border-gray-700 flex justify-between items-center">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white">Reset PIN</h3>
                    <button onclick="closeResetPinModal()" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-200">
                        <ion-icon name="close-outline" class="text-2xl"></ion-icon>
                    </button>
                </div>
                <div class="p-6 space-y-4">
                    <div class="space-y-2">
                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Employee</label>
                        <input type="text" id="resetPinName" class="w-full bg-gray-50 dark:bg-slate-700 border border-gray-200 dark:border-gray-600 rounded-lg px-3 py-2 text-sm text-gray-500" disabled>
                    </div>
                     <div class="space-y-2">
                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Reason</label>
                        <textarea class="w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-lg px-3 py-2 text-sm outline-none focus:border-primary" rows="2" placeholder="e.g. Forgot PIN"></textarea>
                    </div>
                    <label class="flex items-center gap-2 cursor-pointer">
                        <input type="checkbox" class="rounded border-gray-300 text-primary focus:ring-primary" checked>
                        <span class="text-sm text-gray-700 dark:text-gray-300">Generate new random PIN</span>
                    </label>
                </div>
                <div class="p-6 pt-0 flex justify-end gap-3">
                    <button onclick="closeResetPinModal()" class="px-4 py-2 text-sm font-medium text-gray-600 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-slate-700 rounded-lg transition-colors">Cancel</button>
                    <button onclick="confirmResetPin()" class="px-4 py-2 text-sm font-bold text-white bg-primary hover:bg-orange-600 rounded-lg shadow-sm transition-colors">Reset PIN</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Print Card Modal -->
    <div id="printModal" class="fixed inset-0 z-[100] hidden">
        <div class="absolute inset-0 bg-black/50 backdrop-blur-sm transition-opacity opacity-0" id="printOverlay"></div>
        <div class="absolute inset-0 flex items-center justify-center p-4">
            <div class="bg-white dark:bg-slate-800 rounded-2xl shadow-xl w-full max-w-md transform scale-95 opacity-0 transition-all" id="printContent">
                <div class="p-6 border-b border-gray-100 dark:border-gray-700 flex justify-between items-center">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white">Print Login Card</h3>
                    <button onclick="closePrintModal()" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-200">
                        <ion-icon name="close-outline" class="text-2xl"></ion-icon>
                    </button>
                </div>
                <div class="p-8 flex flex-col items-center gap-6">
                    <!-- ID Card Preview -->
                    <div class="w-64 h-40 bg-white border border-gray-200 rounded-lg shadow-sm relative overflow-hidden flex flex-col items-center justify-center text-center p-4 select-none">
                        <div class="absolute top-0 left-0 w-full h-2 bg-primary"></div>
                        <div class="font-bold text-lg text-gray-800 mb-1" id="printCardName">Name</div>
                        <div class="text-xs text-gray-500 mb-4">Cashbox Staff Access</div>
                        <!-- Mock Barcode -->
                         <div class="h-12 w-48 bg-gray-800 mb-1" style="mask-image: repeating-linear-gradient(90deg, black, black 2px, transparent 2px, transparent 4px);"></div>
                         <div class="text-[10px] font-mono tracking-widest text-gray-400" id="printCardId">0000</div>
                    </div>
                    <p class="text-sm text-gray-500 text-center">Ready to print. Please use a label printer or standard A4 printer.</p>
                </div>
                <div class="p-6 pt-0 flex justify-end gap-3">
                     <button onclick="closePrintModal()" class="px-4 py-2 text-sm font-medium text-gray-600 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-slate-700 rounded-lg transition-colors">Cancel</button>
                    <button onclick="window.print(); closePrintModal()" class="px-4 py-2 text-sm font-bold text-white bg-blue-600 hover:bg-blue-700 rounded-lg shadow-sm transition-colors flex items-center gap-2">
                         <ion-icon name="print"></ion-icon> Print
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script>
       document.addEventListener('DOMContentLoaded', () => {
           setupDropdown('storeFilterBtn', 'storeFilterDropdown', 'currentStoreFilter', '.store-filter-option');
       });

       // Reset PIN Modal
       function openResetPinModal(name) {
           const modal = document.getElementById('resetPinModal');
           const overlay = document.getElementById('resetPinOverlay');
           const content = document.getElementById('resetPinContent');
           document.getElementById('resetPinName').value = name;
           
           modal.classList.remove('hidden');
           requestAnimationFrame(() => {
                overlay.classList.remove('opacity-0');
                content.classList.remove('opacity-0', 'scale-95');
                content.classList.add('scale-100');
           });
       }

       function closeResetPinModal() {
           const modal = document.getElementById('resetPinModal');
           const overlay = document.getElementById('resetPinOverlay');
           const content = document.getElementById('resetPinContent');
           
           overlay.classList.add('opacity-0');
           content.classList.remove('scale-100');
           content.classList.add('opacity-0', 'scale-95');
           
           setTimeout(() => {
                modal.classList.add('hidden');
           }, 200);
       }
       
       function confirmResetPin() {
           showToast('PIN reset successfully. Temporary PIN sent.', 'success');
           closeResetPinModal();
       }

       // Print Modal
       function openPrintModal(name, id) {
           const modal = document.getElementById('printModal');
           const overlay = document.getElementById('printOverlay');
           const content = document.getElementById('printContent');
           
           document.getElementById('printCardName').textContent = name;
           document.getElementById('printCardId').textContent = id;
           
           modal.classList.remove('hidden');
           requestAnimationFrame(() => {
                overlay.classList.remove('opacity-0');
                content.classList.remove('opacity-0', 'scale-95');
                content.classList.add('scale-100');
           });
       }

       function closePrintModal() {
           const modal = document.getElementById('printModal');
           const overlay = document.getElementById('printOverlay');
           const content = document.getElementById('printContent');
           
           overlay.classList.add('opacity-0');
           content.classList.remove('scale-100');
           content.classList.add('opacity-0', 'scale-95');
           
           setTimeout(() => {
                modal.classList.add('hidden');
           }, 200);
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
