<?php
include 'includes/session.php';
// employee_form.php - Create/Edit Employee (Till Staff)
$empId = $_GET['id'] ?? null;
$mode = $empId ? 'edit' : 'create';
$pageTitle = $mode === 'edit' ? "Edit Employee" : "Add Employee";
$currentPage = "employees";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";
$checkboxWrapper = "flex items-center justify-between p-4 bg-white dark:bg-slate-800/50 border border-gray-100 dark:border-gray-700 rounded-xl h-fit cursor-pointer hover:border-primary/30 transition-colors";

require_once 'includes/header.php';

// Reuse helper from user_form.php (ideally this goes to a functions.php helper)
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    if ($selectedVal === '' && !empty($options)) {
        $selectedVal = array_key_first($options);
        $selectedLabel = $options[$selectedVal];
    }

    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'">
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }

    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            <div class="p-1 space-y-0.5">
                '.$optionsHtml.'
            </div>
        </div>
    </div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="employeeFormContent" class="flex-1 p-6 md:p-8 pb-20">
            <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header -->
            <div class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                <div class="flex items-center gap-4">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">
                            <?php echo $mode === 'edit' ? 'Edit Employee' : 'Add Employee'; ?>
                        </h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Manage staff details and system access.</p>
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <?php if($mode === 'edit'): ?>
                    <button type="button" class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-red-500 hover:border-red-200 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-xl text-sm font-semibold transition-all shadow-sm flex items-center gap-2" onclick="history.back()">
                        <span>Cancel</span>
                    </button>
                    <?php endif; ?>
                    <button type="submit" form="employeeForm" class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-lg"></ion-icon>
                        <span>Save Changes</span>
                    </button>
                </div>
            </div>

            <!-- Tabbed Form Container -->
            <div class="glass-panel rounded-2xl animate-fade-in-up delay-100">
                
                <!-- Tabs Header -->
                <div class="border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50 px-6 pt-4 rounded-t-2xl">
                    <div class="flex gap-6 overflow-x-auto custom-scrollbar">
                        <button class="tab-btn active pb-4 px-2 text-sm font-semibold border-b-2 border-primary text-primary transition-colors whitespace-nowrap" data-target="tab-profile">
                            Profile
                        </button>
                        <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-till-config">
                            Till Configuration
                        </button>
                        <button class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap" data-target="tab-pin">
                            PIN & Barcode
                        </button>
                    </div>
                </div>

                <form id="employeeForm" class="p-6 md:p-8" onsubmit="event.preventDefault(); saveEmployee();">
                    
                    <!-- TAB: Profile -->
                    <div id="tab-profile" class="tab-content space-y-8">
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Basic Info -->
                            <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Basic Information</h3>
                                
                                <div class="space-y-4">
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Home Store <span class="text-red-500">*</span></label>
                                        <?php 
                                            echo renderCustomSelect('Select Store', 'store_id', [
                                                '1001' => 'FNF Cardiff',
                                                '1002' => 'FNF Swansea'
                                            ], '1001'); 
                                        ?>
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Staff Name <span class="text-red-500">*</span></label>
                                        <input type="text" name="full_name" class="<?php echo $inputClass; ?>" placeholder="e.g. John Doe" required>
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Job Title (Display)</label>
                                        <input type="text" name="job_title" class="<?php echo $inputClass; ?>" placeholder="e.g. Team Leader">
                                    </div>
                                     <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                                        <div class="flex items-center gap-3 pt-2">
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="emp_status" value="active" class="sr-only peer" checked>
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-green-500"></div>
                                                <span class="ml-3 text-sm font-medium text-gray-600 dark:text-gray-300 status-label" id="statusLabel">Active</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Payroll / Admin -->
                            <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700">Payroll & Details</h3>
                                
                                <div class="space-y-4">
                                     <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Wage Rate (£ / hr)</label>
                                        <div class="relative">
                                            <span class="absolute left-4 top-3 text-gray-400">£</span>
                                            <input type="number" step="0.01" name="wage_rate" class="<?php echo $inputClass; ?> pl-8" placeholder="0.00">
                                        </div>
                                    </div>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Internal Notes</label>
                                        <textarea name="notes" rows="4" class="<?php echo $inputClass; ?>" placeholder="Performance notes, availability, etc."></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TAB: Till Configuration (Matches Image) -->
                    <div id="tab-till-config" class="tab-content hidden space-y-8 animate-fade-in-up">
                        <div class="flex items-center justify-between border-b border-gray-100 dark:border-gray-700 pb-2">
                            <h3 class="text-base font-semibold text-gray-800 dark:text-white flex items-center gap-2">
                                <ion-icon name="calculator-outline" class="text-primary"></ion-icon> Till App Configuration
                            </h3>
                        </div>

                        <!-- Role & Store -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Till Role <span class="text-red-500">*</span></label>
                                <?php 
                                    echo renderCustomSelect('Till Role', 'till_role', [
                                        'cashier' => 'Cashier',
                                        'supervisor' => 'Supervisor',
                                        'manager' => 'Store Manager'
                                    ], 'cashier'); 
                                ?>
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Assigned Store <span class="text-red-500">*</span></label>
                                <?php 
                                    echo renderCustomSelect('Assigned Store', 'till_store', [
                                        '1001' => 'FNF Cardiff',
                                        '1002' => 'FNF Swansea'
                                    ], '1001'); 
                                ?>
                            </div>
                        </div>

                        <!-- Authentication Methods -->
                        <div class="space-y-4">
                            <h4 class="text-sm font-bold text-gray-800 dark:text-gray-200 uppercase tracking-wider">Login Methods</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- PIN Code -->
                                <div class="p-4 bg-gray-50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700 space-y-3">
                                    <div class="flex items-center justify-between">
                                        <span class="font-medium text-gray-700 dark:text-gray-300">4-Digit PIN</span>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="till_auth_pin" class="sr-only peer" checked onchange="toggleInput('pinInput', this.checked)">
                                            <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all peer-checked:bg-green-500"></div>
                                        </label>
                                    </div>
                                    <input type="password" id="pinInput" name="till_pin" maxlength="4" class="<?php echo $inputClass; ?> tracking-widest text-center" placeholder="••••" required>
                                    <p class="text-xs text-gray-500">Used for quick terminal login.</p>
                                </div>

                                <!-- Swipe Card -->
                                <div class="p-4 bg-gray-50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700 space-y-3 opacity-50 pointer-events-none" title="Coming Soon">
                                    <div class="flex items-center justify-between">
                                        <span class="font-medium text-gray-700 dark:text-gray-300">Swipe Card / RFID</span>
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" name="till_auth_card" class="sr-only peer" disabled>
                                            <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all peer-checked:bg-green-500"></div>
                                        </label>
                                    </div>
                                    <input type="text" class="<?php echo $inputClass; ?>" placeholder="Card ID / Track Data" disabled>
                                    <p class="text-xs text-gray-500">Scan ID card to link (Hardware required).</p>
                                </div>
                            </div>
                        </div>

                        <!-- Permissions Preview -->
                        <div class="space-y-4">
                            <div class="flex items-center justify-between">
                                    <h4 class="text-sm font-bold text-gray-800 dark:text-gray-200 uppercase tracking-wider">Effective Permissions</h4>
                                    <button type="button" class="text-xs text-primary font-bold hover:underline" onclick="showOverrideModal()">Override Permissions</button>
                            </div>
                            
                            <div class="bg-gray-50 dark:bg-slate-800/80 rounded-xl border border-gray-200 dark:border-gray-700 p-4">
                                <div id="permissionsList" class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-3">
                                    <!-- Populated by JS -->
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TAB: PIN & Barcode (Restored) -->
                    <div id="tab-pin" class="tab-content hidden space-y-8 animate-fade-in-up">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            
                            <!-- PIN Management -->
                            <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700 flex items-center gap-2">
                                    <ion-icon name="keypad-outline" class="text-primary"></ion-icon> PIN Management
                                </h3>
                                
                                <div class="bg-gray-50 dark:bg-slate-800/80 rounded-2xl border border-gray-200 dark:border-gray-700 p-6 flex flex-col items-center justify-center text-center space-y-4">
                                    <div class="w-16 h-16 rounded-full bg-green-100 dark:bg-green-900/30 text-green-600 dark:text-green-400 flex items-center justify-center text-3xl">
                                        <ion-icon name="checkmark-circle"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800 dark:text-white text-lg">PIN is Active</div>
                                        <div class="text-sm text-gray-500">Last changed: 2 days ago</div>
                                    </div>
                                    <button type="button" class="w-full py-2.5 bg-white dark:bg-slate-700 border border-gray-200 dark:border-gray-600 rounded-xl text-sm font-bold text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-600 transition-colors shadow-sm flex items-center justify-center gap-2" onclick="showToast('New PIN generated and sent via SMS', 'success')">
                                        <ion-icon name="refresh-outline" class="text-lg"></ion-icon>
                                        Rotate PIN
                                    </button>
                                </div>
                            </div>

                            <!-- Barcode / Card -->
                            <div class="space-y-6">
                                <h3 class="text-base font-semibold text-gray-800 dark:text-white pb-2 border-b border-gray-100 dark:border-gray-700 flex items-center gap-2">
                                     <ion-icon name="card-outline" class="text-primary"></ion-icon> Login Card
                                </h3>

                                <div class="bg-white dark:bg-slate-800 rounded-2xl border border-gray-200 dark:border-gray-700 shadow-lg p-6 relative overflow-hidden">
                                     <div class="absolute top-0 left-0 w-full h-2 bg-primary"></div>
                                     <div class="flex items-center gap-4 mb-6">
                                         <div class="w-12 h-12 rounded-full bg-orange-100 dark:bg-orange-900/30 text-orange-600 dark:text-orange-400 flex items-center justify-center font-bold text-lg">
                                            JD
                                         </div>
                                         <div>
                                             <div class="font-bold text-gray-800 dark:text-white text-lg">John Doe</div>
                                             <div class="text-xs text-gray-500 uppercase tracking-widest">Cashbox Staff</div>
                                         </div>
                                     </div>
                                     <div class="bg-gray-100 dark:bg-black/20 rounded-lg p-4 flex flex-col items-center justify-center space-y-2">
                                         <!-- Fake Barcode -->
                                         <div class="h-12 w-full max-w-[200px] bg-gray-800 dark:bg-white" style="mask-image: repeating-linear-gradient(90deg, black, black 2px, transparent 2px, transparent 4px);"></div>
                                         <div class="font-mono text-xs text-gray-500 tracking-[0.2em]">1001-9821-44</div>
                                     </div>
                                     <div class="mt-6">
                                         <button type="button" class="w-full py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all flex items-center justify-center gap-2" onclick="window.print()">
                                            <ion-icon name="print-outline" class="text-lg"></ion-icon>
                                            Print Card
                                        </button>
                                     </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </form>
            </div>

        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initTabs();
             initCustomSelects(); 
             
             // Status Toggle Listener
             const statusCheck = document.querySelector('input[name="emp_status"]');
             if (statusCheck) {
                 statusCheck.addEventListener('change', (e) => {
                     const label = document.getElementById('statusLabel');
                     if (label) label.textContent = e.target.checked ? 'Active' : 'Inactive';
                 });
             }
             
             // Initial Permissions
             updatePermissionPreview('cashier');
        });

        // Toggle Input Helper
        function toggleInput(inputId, enable) {
           const input = document.getElementById(inputId);
           if(input) {
               input.disabled = !enable;
               if (!enable) {
                    input.classList.add('opacity-50', 'bg-gray-50');
                    input.classList.remove('bg-white', 'dark:bg-slate-800');
               } else {
                    input.classList.remove('opacity-50', 'bg-gray-50');
                    input.classList.add('bg-white', 'dark:bg-slate-800');
               }
           }
        }
        
        function showOverrideModal() {
           showToast('Permission overrides placeholder.', 'info');
        }

       // Mock Roles Data (Copied for consistency)
       const ROLE_PERMISSIONS = {
           'cashier': ['Sales', 'Returns (Low Value)', 'X Report'],
           'supervisor': ['Sales', 'Returns (All)', 'Voids', 'X Report', 'Z Report', 'Price Override'],
           'manager': ['ALL ACCESS']
       };

       function updatePermissionPreview(role) {
           const container = document.getElementById('permissionsList');
           if (!container) return; 
           container.innerHTML = '';
           
           const perms = ROLE_PERMISSIONS[role] || [];
           
           if(role === 'manager') {
                container.innerHTML = `<div class="col-span-full text-center py-2 text-sm font-bold text-green-600 dark:text-green-400">
                    <ion-icon name="shield-checkmark" class="text-lg align-middle mr-1"></ion-icon> Full System Access
                </div>`;
                return;
           }

           perms.forEach(perm => {
               const div = document.createElement('div');
               div.className = 'flex items-center gap-2 text-xs font-medium text-gray-600 dark:text-gray-300 bg-white dark:bg-slate-700 px-2 py-1.5 rounded-lg border border-gray-100 dark:border-gray-600';
               div.innerHTML = `<ion-icon name="checkmark-circle" class="text-green-500"></ion-icon> ${perm}`;
               container.appendChild(div);
           });
       }

        function initTabs() {
             const tabs = document.querySelectorAll('.tab-btn');
             const contents = document.querySelectorAll('.tab-content');
 
             tabs.forEach(tab => {
                 tab.addEventListener('click', () => {
                     // Remove active classes
                     tabs.forEach(t => {
                         t.classList.remove('active', 'border-primary', 'text-primary');
                         t.classList.add('border-transparent', 'text-gray-500', 'dark:text-gray-400');
                     });
 
                     // Add active classes
                     tab.classList.add('active', 'border-primary', 'text-primary');
                     tab.classList.remove('border-transparent', 'text-gray-500', 'dark:text-gray-400');
 
                     // Hide/Show content
                     contents.forEach(c => c.classList.add('hidden'));
                     const targetId = tab.dataset.target;
                     const target = document.getElementById(targetId);
                     if (target) {
                         target.classList.remove('hidden');
                         target.classList.add('animate-fade-in-up');
                     }
                 });
             });
         }

       // --- Custom Select Logic (Reuse) ---
       function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);
                    dropdown.classList.toggle('opacity-0');
                    dropdown.classList.toggle('invisible');
                    dropdown.classList.toggle('-translate-y-2');
                    const chevron = trigger.querySelector('ion-icon[name="chevron-down-outline"]');
                    if (chevron && !dropdown.classList.contains('invisible')) {
                        chevron.classList.add('rotate-180');
                        chevron.classList.add('text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');

                    // Trigger Permission Update if Role Changed
                    if(hiddenInput.name === 'till_role') {
                        updatePermissionPreview(hiddenInput.value);
                    }
                });
            });

            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }

       function saveEmployee() {
           showToast('Saving employee data...', 'info');
           setTimeout(() => {
               showToast('Employee saved successfully!', 'success');
               setTimeout(() => {
                   window.location.href = 'employees.php';
               }, 1000);
           }, 800);
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
