<?php
include 'includes/session.php';
// customers.php - Listing of all End-Customers
$pageTitle = "Customers";
$currentPage = "customers";
require_once 'includes/header.php';

// Mock Customers
$customers = [
    [
        'id' => 'CUS-10029',
        'name' => 'Sarah Jenkins',
        'email' => 'sarah.j@example.com',
        'phone' => '+44 7700 900123',
        'store' => 'FNF Cardiff',
        'total_spend' => '£1,240.50',
        'last_visit' => '2 days ago',
        'status' => 'Active',
        'tier' => 'Gold'
    ],
    [
        'id' => 'CUS-10030',
        'name' => 'Michael Ross',
        'email' => 'm.ross@example.com',
        'phone' => '+44 7700 900456',
        'store' => 'FNF Swansea',
        'total_spend' => '£45.20',
        'last_visit' => '2 weeks ago',
        'status' => 'Active',
        'tier' => 'Bronze'
    ],
    [
        'id' => 'CUS-10031',
        'name' => 'David Miller',
        'email' => 'dave.m@example.com',
        'phone' => '+44 7700 900789',
        'store' => '3S Penarth',
        'total_spend' => '£0.00',
        'last_visit' => 'Never',
        'status' => 'Banned',
        'tier' => 'None'
    ],
    [
        'id' => 'CUS-10032',
        'name' => 'Emma Watson',
        'email' => 'emma.w@example.com',
        'phone' => '+44 7700 900111',
        'store' => 'FNF Cardiff',
        'total_spend' => '£3,500.00',
        'last_visit' => 'Yesterday',
        'status' => 'Active',
        'tier' => 'Platinum'
    ],
    [
        'id' => 'CUS-10033',
        'name' => 'James Cook',
        'email' => 'j.cook@example.com',
        'phone' => '+44 7700 900222',
        'store' => 'FNF Swansea',
        'total_spend' => '£210.75',
        'last_visit' => '1 month ago',
        'status' => 'Active',
        'tier' => 'Silver'
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div
                class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-10">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Customer Database</h1>
                    <p class="text-gray-500 dark:text-gray-400 mt-1">Manage profiles, loyalty, and history for all
                        customers.</p>
                </div>

                <div
                    class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto">
                    <!-- Search -->
                    <div class="relative group w-full sm:w-64 shrink-0">
                        <div class="absolute inset-y-0 left-0 pl-3.5 flex items-center pointer-events-none">
                            <ion-icon name="search-outline"
                                class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                        </div>
                        <input type="text"
                            class="w-full bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-lg pl-10 pr-4 py-2 text-sm focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all outline-none"
                            placeholder="Search Customers...">
                    </div>

                    <!-- Store Filter -->
                    <div class="relative hidden md:block">
                        <select
                            class="bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-lg px-3 py-2 text-sm focus:outline-none focus:border-primary cursor-pointer hover:bg-gray-50 dark:hover:bg-slate-800 transition-colors">
                            <option>All Stores</option>
                            <option>FNF Cardiff</option>
                            <option>FNF Swansea</option>
                            <option>3S Penarth</option>
                        </select>
                    </div>

                    <a href="customer_form.php"
                        class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-lg text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center gap-2 whitespace-nowrap">
                        <ion-icon name="person-add-outline" class="text-xl"></ion-icon>
                        <span>New Customer</span>
                    </a>
                </div>
            </div>

            <!-- Customer Table -->
            <div class="glass-panel rounded-2xl overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr
                                class="border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50">
                                <th
                                    class="px-6 py-4 text-left text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Customer</th>
                                <th
                                    class="px-6 py-4 text-left text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Contact</th>
                                <th
                                    class="px-6 py-4 text-left text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Main Store</th>
                                <th
                                    class="px-6 py-4 text-left text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Total Spend</th>
                                <th
                                    class="px-6 py-4 text-center text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Status</th>
                                <th
                                    class="px-6 py-4 text-right text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                            <?php foreach ($customers as $cus): ?>
                                <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                                    <td class="px-6 py-4">
                                        <div class="flex items-center gap-3">
                                            <div
                                                class="w-10 h-10 rounded-full bg-gradient-to-br from-gray-100 to-gray-200 dark:from-slate-700 dark:to-slate-800 flex items-center justify-center text-gray-500 dark:text-gray-300 font-bold text-sm">
                                                <?php echo substr($cus['name'], 0, 1); ?>
                                            </div>
                                            <div>
                                                <div class="font-bold text-gray-800 dark:text-white text-sm">
                                                    <?php echo $cus['name']; ?>
                                                </div>
                                                <div class="flex items-center gap-1.5 mt-0.5">
                                                    <?php
                                                    $badgeColor = match ($cus['tier']) {
                                                        'Platinum' => 'bg-purple-100 text-purple-700 dark:bg-purple-900/30 dark:text-purple-300',
                                                        'Gold' => 'bg-yellow-100 text-yellow-700 dark:bg-yellow-900/30 dark:text-yellow-300',
                                                        'Silver' => 'bg-gray-100 text-gray-600 dark:bg-gray-700/50 dark:text-gray-300',
                                                        'Bronze' => 'bg-orange-50 text-orange-700 dark:bg-orange-900/20 dark:text-orange-300',
                                                        default => 'hidden'
                                                    };
                                                    ?>
                                                    <span
                                                        class="text-[10px] uppercase font-bold px-1.5 py-0.5 rounded <?php echo $badgeColor; ?>">
                                                        <?php echo $cus['tier']; ?>
                                                    </span>
                                                    <span class="text-[10px] text-gray-400">ID:
                                                        <?php echo $cus['id']; ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="text-sm text-gray-600 dark:text-gray-300">
                                            <?php echo $cus['email']; ?>
                                        </div>
                                        <div class="text-xs text-gray-400 mt-0.5">
                                            <?php echo $cus['phone']; ?>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="flex items-center gap-2">
                                            <ion-icon name="storefront-outline" class="text-gray-400"></ion-icon>
                                            <span class="text-sm font-medium text-gray-700 dark:text-gray-300">
                                                <?php echo $cus['store']; ?>
                                            </span>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="text-sm font-bold text-gray-800 dark:text-white">
                                            <?php echo $cus['total_spend']; ?>
                                        </div>
                                        <div class="text-xs text-gray-400 mt-0.5">Last:
                                            <?php echo $cus['last_visit']; ?>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 text-center">
                                        <?php if ($cus['status'] == 'Active'): ?>
                                            <span
                                                class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-emerald-50 text-emerald-700 dark:bg-emerald-900/20 dark:text-emerald-400 border border-emerald-100 dark:border-emerald-900/30">
                                                Active
                                            </span>
                                        <?php else: ?>
                                            <span
                                                class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-50 text-red-700 dark:bg-red-900/20 dark:text-red-400 border border-red-100 dark:border-red-900/30">
                                                Banned
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 text-right">
                                        <div
                                            class="flex items-center justify-end gap-2 opacity-0 group-hover:opacity-100 transition-opacity">
                                            <a href="customer_form.php?id=<?php echo $cus['id']; ?>"
                                                class="p-2 rounded-lg text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-slate-700 transition-all"
                                                title="View Profile">
                                                <ion-icon name="eye-outline" class="text-lg"></ion-icon>
                                            </a>
                                            <button
                                                class="p-2 rounded-lg text-gray-400 hover:text-blue-500 hover:bg-blue-50 dark:hover:bg-blue-900/20 transition-all"
                                                title="Message">
                                                <ion-icon name="chatbubble-outline" class="text-lg"></ion-icon>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="px-6 py-4 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between">
                    <span class="text-xs text-gray-500 dark:text-gray-400">Showing 1-5 of 1,250 Customers</span>
                    <div class="flex gap-2">
                        <button
                            class="px-3 py-1.5 rounded-lg border border-gray-200 dark:border-gray-700 text-gray-500 dark:text-gray-400 text-xs font-medium bg-white dark:bg-slate-800 hover:bg-gray-50 dark:hover:bg-slate-700 disabled:opacity-50">Previous</button>
                        <button
                            class="px-3 py-1.5 rounded-lg border border-gray-200 dark:border-gray-700 text-gray-500 dark:text-gray-400 text-xs font-medium bg-white dark:bg-slate-800 hover:bg-gray-50 dark:hover:bg-slate-700">Next</button>
                    </div>
                </div>

            </div>

        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>