<?php
include 'includes/session.php';
// customer_form.php - View/Edit Customer Profile
$customerId = $_GET['id'] ?? null;
$pageTitle = $customerId ? "Customer Profile" : "New Customer";
$currentPage = "customers";
require_once 'includes/header.php';

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

// Mock Data
$customer = [
    'name' => '',
    'email' => '',
    'phone' => '',
    'dob' => '',
    'gender' => '',
    'address_1' => '',
    'city' => '',
    'postcode' => '',
    'notes' => '',
    'status' => 'Active',
    'tier' => 'Bronze',
    'points' => 0,
    'wallet_balance' => '0.00',
    'total_orders' => 0,
    'total_spend' => '0.00',
    'avg_basket' => '0.00',
    'last_visit' => '-'
];

if ($customerId) {
    // Simulate Fetch
    $customer = [
        'name' => 'Sarah Jenkins',
        'email' => 'sarah.j@example.com',
        'phone' => '+44 7700 900123',
        'dob' => '1990-05-15',
        'gender' => 'Female',
        'address_1' => '42 High Street',
        'city' => 'Cardiff',
        'postcode' => 'CF10 1AB',
        'notes' => 'Prefer gluten-free options. Regular weekend visitor.',
        'status' => 'Active',
        'tier' => 'Gold',
        'points' => 450,
        'wallet_balance' => '15.50',
        'total_orders' => 42,
        'total_spend' => '1,240.50',
        'avg_basket' => '29.53',
        'last_visit' => '2026-01-20'
    ];
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header (Glass Panel) -->
            <div
                class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 relative z-30">
                <div class="flex items-center gap-4">
                    <div
                        class="w-16 h-16 rounded-full bg-gradient-to-br from-orange-400 to-pink-500 flex items-center justify-center text-white text-2xl font-bold shadow-lg shadow-orange-500/20">
                        <?php echo $customerId ? substr($customer['name'], 0, 1) : '?'; ?>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">
                            <?php echo $customerId ? $customer['name'] : 'New Customer'; ?>
                        </h1>
                        <div class="flex items-center gap-2 mt-1">
                            <?php if ($customerId): ?>
                                <span
                                    class="px-2 py-0.5 rounded text-[10px] font-bold uppercase bg-yellow-100 text-yellow-700 dark:bg-yellow-900/30 dark:text-yellow-300 border border-yellow-200 dark:border-yellow-800/50">
                                    <?php echo $customer['tier']; ?> Member
                                </span>
                                <span class="text-gray-400 text-sm">•</span>
                            <?php endif; ?>
                            <span class="text-gray-500 dark:text-gray-400 text-sm">Customer Profile</span>
                        </div>
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <button type="button" onclick="history.back()"
                        class="px-5 py-2.5 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 rounded-xl hover:text-gray-800 dark:hover:text-white transition-all font-bold text-sm shadow-sm">
                        Back to List
                    </button>
                    <div class="h-8 w-px bg-gray-300 dark:bg-gray-700 mx-1"></div>
                    <button type="button"
                        class="p-2.5 rounded-xl border border-gray-200 dark:border-gray-700 text-gray-400 hover:text-red-500 hover:border-red-200 hover:bg-red-50 dark:hover:bg-red-900/20 transition-all">
                        <ion-icon name="ban-outline" class="text-xl"></ion-icon>
                    </button>
                    <button type="button"
                        class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="save-outline" class="text-lg"></ion-icon>
                        <span>Save Changes</span>
                    </button>
                </div>
            </div>

            <!-- Main Layout Grid -->
            <div class="grid grid-cols-1 xl:grid-cols-3 gap-8">

                <!-- Left Column (Stats & Wallet) -->
                <div class="space-y-6">

                    <!-- Stats Card -->
                    <div class="glass-panel rounded-2xl p-6 relative overflow-hidden">
                        <div class="absolute top-0 right-0 p-4 opacity-10">
                            <ion-icon name="stats-chart" class="text-9xl"></ion-icon>
                        </div>
                        <h3 class="text-base font-bold text-gray-700 dark:text-gray-300 mb-6 relative z-10">Lifetime
                            Stats</h3>

                        <div class="grid grid-cols-2 gap-4 relative z-10">
                            <div
                                class="p-4 rounded-xl bg-orange-50 dark:bg-orange-900/10 border border-orange-100 dark:border-orange-900/30">
                                <span
                                    class="block text-xs font-bold text-orange-600 dark:text-orange-400 uppercase tracking-wide">Total
                                    Spend</span>
                                <span class="block text-2xl font-bold text-gray-800 dark:text-white mt-1">£
                                    <?php echo $customer['total_spend']; ?>
                                </span>
                            </div>
                            <div
                                class="p-4 rounded-xl bg-blue-50 dark:bg-blue-900/10 border border-blue-100 dark:border-blue-900/30">
                                <span
                                    class="block text-xs font-bold text-blue-600 dark:text-blue-400 uppercase tracking-wide">Total
                                    Orders</span>
                                <span class="block text-2xl font-bold text-gray-800 dark:text-white mt-1">
                                    <?php echo $customer['total_orders']; ?>
                                </span>
                            </div>
                            <div
                                class="p-4 rounded-xl bg-gray-50 dark:bg-gray-800 border border-gray-100 dark:border-gray-700">
                                <span class="block text-xs font-bold text-gray-500 uppercase tracking-wide">Avg
                                    Basket</span>
                                <span class="block text-xl font-bold text-gray-800 dark:text-white mt-1">£
                                    <?php echo $customer['avg_basket']; ?>
                                </span>
                            </div>
                            <div
                                class="p-4 rounded-xl bg-gray-50 dark:bg-gray-800 border border-gray-100 dark:border-gray-700">
                                <span class="block text-xs font-bold text-gray-500 uppercase tracking-wide">Last
                                    Visit</span>
                                <span class="block text-sm font-bold text-gray-800 dark:text-white mt-1">
                                    <?php echo $customer['last_visit']; ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Wallet Card -->
                    <div class="glass-panel rounded-2xl p-6">
                        <div class="flex items-center justify-between mb-6">
                            <h3 class="text-base font-bold text-gray-700 dark:text-gray-300">Wallet & Loyalty</h3>
                            <button class="text-xs font-bold text-primary hover:underline">View History</button>
                        </div>

                        <div class="space-y-4">
                            <!-- Loyalty Points -->
                            <div
                                class="flex items-center justify-between p-4 rounded-xl bg-gradient-to-r from-yellow-50 to-amber-50 dark:from-yellow-900/10 dark:to-amber-900/10 border border-yellow-100 dark:border-yellow-900/30">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-10 h-10 rounded-full bg-yellow-100 dark:bg-yellow-900/30 flex items-center justify-center text-yellow-600 dark:text-yellow-400">
                                        <ion-icon name="star" class="text-lg"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="text-sm font-bold text-gray-800 dark:text-white">Loyalty Points
                                        </div>
                                        <div class="text-xs text-yellow-600 dark:text-yellow-400">Gold Tier Multiplier
                                            (1.5x)</div>
                                    </div>
                                </div>
                                <div class="text-xl font-bold text-gray-800 dark:text-white">
                                    <?php echo $customer['points']; ?> pts
                                </div>
                            </div>

                            <!-- Store Credit -->
                            <div
                                class="flex items-center justify-between p-4 rounded-xl bg-gradient-to-r from-emerald-50 to-teal-50 dark:from-emerald-900/10 dark:to-teal-900/10 border border-emerald-100 dark:border-emerald-900/30">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-10 h-10 rounded-full bg-emerald-100 dark:bg-emerald-900/30 flex items-center justify-center text-emerald-600 dark:text-emerald-400">
                                        <ion-icon name="wallet" class="text-lg"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="text-sm font-bold text-gray-800 dark:text-white">Store Credit</div>
                                        <div class="text-xs text-emerald-600 dark:text-emerald-400">Available Balance
                                        </div>
                                    </div>
                                </div>
                                <div class="text-xl font-bold text-gray-800 dark:text-white">£
                                    <?php echo $customer['wallet_balance']; ?>
                                </div>
                            </div>

                            <div class="grid grid-cols-2 gap-3 pt-2">
                                <button
                                    class="py-2 rounded-lg border border-gray-200 dark:border-gray-700 text-sm font-bold text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-slate-700 transition-colors">Adjust
                                    Points</button>
                                <button
                                    class="py-2 rounded-lg border border-gray-200 dark:border-gray-700 text-sm font-bold text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-slate-700 transition-colors">Add
                                    Credit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column (Tabs & Form) -->
                <div class="xl:col-span-2 glass-panel rounded-2xl flex flex-col min-h-[600px]">
                    <!-- Tabs Header -->
                    <div
                        class="border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50 px-6 pt-4 rounded-t-2xl">
                        <div class="flex gap-6 overflow-x-auto custom-scrollbar">
                            <button
                                class="tab-btn active pb-4 px-2 text-sm font-bold border-b-2 border-primary text-primary transition-colors whitespace-nowrap"
                                onclick="switchTab('tab-general', this)">
                                Profile Details
                            </button>
                            <button
                                class="tab-btn pb-4 px-2 text-sm font-bold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap"
                                onclick="switchTab('tab-history', this)">
                                Order History
                            </button>
                            <button
                                class="tab-btn pb-4 px-2 text-sm font-bold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap"
                                onclick="switchTab('tab-notes', this)">
                                Notes & Logs
                            </button>
                        </div>
                    </div>

                    <div class="p-6 md:p-8 flex-1">
                        <!-- TAB: General Info -->
                        <div id="tab-general" class="tab-content space-y-6 animate-fade-in-up">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Full
                                        Name</label>
                                    <input type="text" value="<?php echo $customer['name']; ?>"
                                        class="<?php echo $inputClass; ?>" placeholder="e.g. John Doe">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Email
                                        Address</label>
                                    <input type="email" value="<?php echo $customer['email']; ?>"
                                        class="<?php echo $inputClass; ?>" placeholder="john@example.com">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Phone
                                        Number</label>
                                    <input type="tel" value="<?php echo $customer['phone']; ?>"
                                        class="<?php echo $inputClass; ?>" placeholder="+44 7000 000000">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Date of
                                        Birth</label>
                                    <input type="date" value="<?php echo $customer['dob']; ?>"
                                        class="<?php echo $inputClass; ?>">
                                </div>
                            </div>

                            <hr class="border-gray-100 dark:border-gray-700 my-4">

                            <h4 class="text-sm font-bold text-gray-800 dark:text-white uppercase tracking-wider mb-4">
                                Address</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="space-y-2 md:col-span-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Address Line
                                        1</label>
                                    <input type="text" value="<?php echo $customer['address_1']; ?>"
                                        class="<?php echo $inputClass; ?>" placeholder="123 Main St">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">City /
                                        Town</label>
                                    <input type="text" value="<?php echo $customer['city']; ?>"
                                        class="<?php echo $inputClass; ?>" placeholder="Cardiff">
                                </div>
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Postcode</label>
                                    <input type="text" value="<?php echo $customer['postcode']; ?>"
                                        class="<?php echo $inputClass; ?>" placeholder="CF10 1AB">
                                </div>
                            </div>
                        </div>

                        <!-- TAB: Order History -->
                        <div id="tab-history" class="tab-content hidden space-y-6 animate-fade-in-up">
                            <!-- Simple List (Mock) -->
                            <div class="space-y-3">
                                <div
                                    class="p-4 rounded-xl border border-gray-100 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors flex items-center justify-between cursor-pointer">
                                    <div class="flex items-center gap-4">
                                        <div
                                            class="w-10 h-10 rounded-lg bg-green-50 dark:bg-green-900/20 text-green-500 flex items-center justify-center text-lg">
                                            <ion-icon name="receipt"></ion-icon>
                                        </div>
                                        <div>
                                            <div class="font-bold text-gray-800 dark:text-white text-sm">Order #12093
                                            </div>
                                            <div class="text-xs text-gray-500 dark:text-gray-400">Jan 20, 2026 • 2:30 PM
                                                • FNF Cardiff</div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <div class="font-bold text-gray-800 dark:text-white">£45.20</div>
                                        <div class="text-xs font-bold text-green-500">Completed</div>
                                    </div>
                                </div>

                                <div
                                    class="p-4 rounded-xl border border-gray-100 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors flex items-center justify-between cursor-pointer">
                                    <div class="flex items-center gap-4">
                                        <div
                                            class="w-10 h-10 rounded-lg bg-green-50 dark:bg-green-900/20 text-green-500 flex items-center justify-center text-lg">
                                            <ion-icon name="receipt"></ion-icon>
                                        </div>
                                        <div>
                                            <div class="font-bold text-gray-800 dark:text-white text-sm">Order #11842
                                            </div>
                                            <div class="text-xs text-gray-500 dark:text-gray-400">Jan 12, 2026 • 11:15
                                                AM • FNF Cardiff</div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <div class="font-bold text-gray-800 dark:text-white">£22.50</div>
                                        <div class="text-xs font-bold text-green-500">Completed</div>
                                    </div>
                                </div>

                                <div
                                    class="p-4 rounded-xl border border-gray-100 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors flex items-center justify-between cursor-pointer opacity-70">
                                    <div class="flex items-center gap-4">
                                        <div
                                            class="w-10 h-10 rounded-lg bg-red-50 dark:bg-red-900/20 text-red-500 flex items-center justify-center text-lg">
                                            <ion-icon name="close-circle"></ion-icon>
                                        </div>
                                        <div>
                                            <div class="font-bold text-gray-800 dark:text-white text-sm">Order #11002
                                            </div>
                                            <div class="text-xs text-gray-500 dark:text-gray-400">Jan 05, 2026 • 09:45
                                                AM • FNF Cardiff</div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <div class="font-bold text-gray-800 dark:text-white">£12.00</div>
                                        <div class="text-xs font-bold text-red-500">Voided</div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- TAB: Notes -->
                        <div id="tab-notes" class="tab-content hidden space-y-6 animate-fade-in-up">
                            <div class="space-y-4">
                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Internal
                                    Notes</label>
                                <textarea class="<?php echo $inputClass; ?> h-32 resize-none"
                                    placeholder="Add important notes about this customer..."><?php echo $customer['notes']; ?></textarea>

                                <div class="flex justify-end">
                                    <button
                                        class="px-4 py-2 bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300 hover:text-gray-800 rounded-lg text-sm font-bold transition-all">Add
                                        Note</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    function switchTab(tabId, btn) {
        document.querySelectorAll('.tab-content').forEach(el => el.classList.add('hidden'));
        document.getElementById(tabId).classList.remove('hidden');
        document.querySelectorAll('.tab-btn').forEach(el => {
            el.classList.remove('active', 'border-primary', 'text-primary');
            el.classList.add('border-transparent', 'text-gray-500', 'dark:text-gray-400');
        });
        btn.classList.add('active', 'border-primary', 'text-primary');
        btn.classList.remove('border-transparent', 'text-gray-500', 'dark:text-gray-400');
    }
</script>