<?php
include 'includes/session.php';
// broadcasts.php - Broadcast Management List
$typeFilter = $_GET['type'] ?? '';
$pageTitle = "Broadcasts";
if ($typeFilter) {
    if ($typeFilter === 'sms')
        $pageTitle = "SMS Blasts";
    elseif ($typeFilter === 'email')
        $pageTitle = "Email Campaigns";
    elseif ($typeFilter === 'popup')
        $pageTitle = "Portal Popups";
    elseif ($typeFilter === 'banner')
        $pageTitle = "Dashboard Banners";
    else
        $pageTitle = ucfirst($typeFilter) . " Broadcasts";
} else {
    $pageTitle = "Broadcasts";
}

$currentPage = "broadcasts";
require_once 'includes/header.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">

    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">

        <!-- Header -->
        <div
            class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 animate-fade-in-down relative z-50 overflow-visible">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight"><?php echo $pageTitle; ?>
                </h1>
                <p class="text-gray-500 dark:text-gray-400 mt-1">Manage and send messages to stores, apps, and
                    customers.</p>
            </div>

            <!-- Controls Bar -->
            <div
                class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto overflow-visible">

                <!-- Search (Transparent) -->
                <div class="relative group w-full sm:w-48 shrink-0">
                    <ion-icon name="search-outline"
                        class="absolute left-2 top-2.5 text-gray-400 group-focus-within:text-primary transition-colors text-lg"></ion-icon>
                    <input type="text" id="broadcastSearch"
                        class="pl-8 pr-4 py-2 bg-transparent border-none focus:ring-0 outline-none w-full text-sm text-gray-600 dark:text-gray-200 placeholder-gray-400 font-medium bg-transparent"
                        placeholder="Search...">
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Status Filter -->
                <div class="relative z-20" id="broadcastStatusFilter">
                    <button id="statusFilterBtn"
                        class="flex items-center gap-2 px-3 py-2 bg-transparent hover:bg-white dark:hover:bg-slate-700 rounded-lg text-sm text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white transition-all border border-transparent hover:border-gray-200 dark:hover:border-gray-600 min-w-[120px] justify-between">
                        <div class="flex items-center gap-2">
                            <ion-icon name="filter-outline" class="text-gray-400 text-xs"></ion-icon>
                            <span id="currentStatusFilter" class="font-medium">All Status</span>
                        </div>
                        <ion-icon name="chevron-down-outline"
                            class="text-xs text-gray-400 h-3 w-3 transition-transform duration-300"></ion-icon>
                    </button>
                </div>

                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600 hidden sm:block"></div>

                <!-- Create Button -->
                <a href="broadcast_create.php<?php echo $typeFilter ? '?type=' . $typeFilter : ''; ?>"
                    class="flex items-center gap-2 px-4 py-2 bg-primary hover:bg-orange-600 text-white text-sm font-bold rounded-lg shadow-lg shadow-orange-500/30 transition-all transform hover:-translate-y-0.5 shrink-0 ml-1">
                    <ion-icon name="add-circle-outline" class="text-lg"></ion-icon>
                    <span>New <?php echo $typeFilter ? ucfirst($typeFilter) : 'Broadcast'; ?></span>
                </a>
            </div>
        </div>

        <!-- Data Table -->
        <div class="glass-panel rounded-2xl overflow-hidden animate-fade-in-up delay-100 relative z-0">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                            <th
                                class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">
                                Title</th>
                            <th
                                class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">
                                Type / Channels</th>
                            <th
                                class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">
                                Target Audience</th>
                            <th
                                class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider">
                                Schedule / Sent</th>
                            <th
                                class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider text-center">
                                Status</th>
                            <th
                                class="p-4 text-xs font-semibold uppercase text-gray-500 dark:text-gray-400 tracking-wider text-right">
                                Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">

                        <!-- Mock Row 1: System Update -->
                        <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                            <td class="p-4">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-10 h-10 rounded-lg bg-blue-100 dark:bg-blue-500/20 text-blue-600 dark:text-blue-400 flex items-center justify-center text-xl">
                                        <ion-icon name="notifications-outline"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="font-semibold text-gray-800 dark:text-white">System Maintenance
                                        </div>
                                        <div class="text-xs text-gray-400">ID: #BC-1001</div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="flex gap-2">
                                    <span
                                        class="inline-flex items-center gap-1 px-2 py-0.5 rounded text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300">
                                        <ion-icon name="alert-circle-outline"></ion-icon> Popup
                                    </span>
                                    <span
                                        class="inline-flex items-center gap-1 px-2 py-0.5 rounded text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300">
                                        <ion-icon name="mail-outline"></ion-icon> Email
                                    </span>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="text-sm text-gray-700 dark:text-gray-300">All Portal Users</div>
                                <div class="text-xs text-gray-400">Roles: Admin, Manager</div>
                            </td>
                            <td class="p-4">
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <div class="font-medium text-gray-700 dark:text-gray-300">Jan 22, 2026</div>
                                    <div>10:00 AM</div>
                                </div>
                            </td>
                            <td class="p-4 text-center">
                                <span
                                    class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400 border border-green-200 dark:border-green-800">
                                    Sent
                                </span>
                            </td>
                            <td class="p-4 text-right">
                                <div class="flex items-center justify-end gap-3">
                                    <button
                                        class="p-1.5 text-gray-400 hover:text-blue-500 hover:bg-blue-50 dark:hover:bg-blue-900/10 rounded-lg transition-colors"
                                        title="View Report">
                                        <ion-icon name="stats-chart-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <button
                                        class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors"
                                        title="Duplicate">
                                        <ion-icon name="copy-outline" class="text-lg"></ion-icon>
                                    </button>
                                </div>
                            </td>
                        </tr>

                        <!-- Mock Row 2: Holiday Sale -->
                        <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                            <td class="p-4">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-10 h-10 rounded-lg bg-orange-100 dark:bg-orange-500/20 text-orange-600 dark:text-orange-400 flex items-center justify-center text-xl">
                                        <ion-icon name="pricetag-outline"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="font-semibold text-gray-800 dark:text-white">Weekend Sale Blast
                                        </div>
                                        <div class="text-xs text-gray-400">ID: #BC-1002</div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="flex gap-2">
                                    <span
                                        class="inline-flex items-center gap-1 px-2 py-0.5 rounded text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300">
                                        <ion-icon name="phone-portrait-outline"></ion-icon> SMS
                                    </span>
                                    <span
                                        class="inline-flex items-center gap-1 px-2 py-0.5 rounded text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300">
                                        <ion-icon name="phone-portrait-outline"></ion-icon> App Push
                                    </span>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="text-sm text-gray-700 dark:text-gray-300">End Customers</div>
                                <div class="text-xs text-gray-400">All Registered</div>
                            </td>
                            <td class="p-4">
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <div class="font-medium text-gray-700 dark:text-gray-300">Jan 25, 2026</div>
                                    <div>09:00 AM</div>
                                </div>
                            </td>
                            <td class="p-4 text-center">
                                <span
                                    class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 dark:bg-blue-900/30 text-blue-700 dark:text-blue-400 border border-blue-200 dark:border-blue-800">
                                    Scheduled
                                </span>
                            </td>
                            <td class="p-4 text-right">
                                <div class="flex items-center justify-end gap-3">
                                    <button
                                        class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors"
                                        title="Edit">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <button
                                        class="p-1.5 text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-lg transition-colors"
                                        title="Cancel">
                                        <ion-icon name="close-circle-outline" class="text-lg"></ion-icon>
                                    </button>
                                </div>
                            </td>
                        </tr>

                        <!-- Mock Row 3: Draft -->
                        <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors">
                            <td class="p-4">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-10 h-10 rounded-lg bg-gray-100 dark:bg-slate-700 text-gray-500 dark:text-gray-400 flex items-center justify-center text-xl">
                                        <ion-icon name="document-text-outline"></ion-icon>
                                    </div>
                                    <div>
                                        <div class="font-semibold text-gray-800 dark:text-white">Policy Update Reminder
                                        </div>
                                        <div class="text-xs text-gray-400">ID: #BC-1003</div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="flex gap-2">
                                    <span
                                        class="inline-flex items-center gap-1 px-2 py-0.5 rounded text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300">
                                        <ion-icon name="browsers-outline"></ion-icon> Banner
                                    </span>
                                </div>
                            </td>
                            <td class="p-4">
                                <div class="text-sm text-gray-700 dark:text-gray-300">Store Employees</div>
                                <div class="text-xs text-gray-400">All Stores</div>
                            </td>
                            <td class="p-4">
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    <div class="font-medium text-gray-700 dark:text-gray-300">-</div>
                                </div>
                            </td>
                            <td class="p-4 text-center">
                                <span
                                    class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-400 border border-gray-200 dark:border-gray-600">
                                    Draft
                                </span>
                            </td>
                            <td class="p-4 text-right">
                                <div class="flex items-center justify-end gap-3">
                                    <button
                                        class="p-1.5 text-gray-400 hover:text-primary hover:bg-orange-50 dark:hover:bg-orange-900/10 rounded-lg transition-colors"
                                        title="Edit">
                                        <ion-icon name="create-outline" class="text-lg"></ion-icon>
                                    </button>
                                    <button
                                        class="p-1.5 text-gray-400 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-lg transition-colors"
                                        title="Delete">
                                        <ion-icon name="trash-outline" class="text-lg"></ion-icon>
                                    </button>
                                </div>
                            </td>
                        </tr>

                    </tbody>
                </table>
            </div>

            <!-- Pagination (Mock) -->
            <div class="p-4 border-t border-gray-100 dark:border-gray-700 flex items-center justify-between">
                <span class="pagination-text text-xs text-gray-500 dark:text-gray-400 font-medium">Showing 3 of 3
                    broadcasts</span>
                <div class="flex gap-2">
                    <button
                        class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center disabled:opacity-50 disabled:hover:bg-gray-50 disabled:hover:text-gray-500 cursor-pointer disabled:cursor-not-allowed group"
                        disabled>
                        <ion-icon name="chevron-back-outline"
                            class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                    <button
                        class="w-8 h-8 rounded-full bg-gray-50 dark:bg-slate-700/50 text-gray-500 dark:text-gray-400 hover:bg-primary hover:text-white dark:hover:bg-primary transition-all shadow-sm flex items-center justify-center cursor-pointer group"
                        disabled>
                        <ion-icon name="chevron-forward-outline"
                            class="group-hover:scale-110 transition-transform"></ion-icon>
                    </button>
                </div>
            </div>
        </div>

    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    // Simple filter toggle logic for the status button (mock)
    // In a real app we'd reuse the same JS component as stores.php
</script>
</body>

</html>