<?php
include 'includes/session.php';
// broadcast_create.php - Create/Edit Broadcast
$broadcastId = $_GET['id'] ?? null;
$type = $_GET['type'] ?? null; // 'sms', 'email', 'popup', 'banner'

$mode = $broadcastId ? 'edit' : 'create';
$pageTitle = $mode === 'edit' ? "Edit Broadcast" : "New Broadcast";
if ($type) {
    $pageTitle = "New " . ($type === 'sms' ? 'SMS' : ucfirst($type)) . " Broadcast";
}
$currentPage = "broadcasts";

// Shared Style Classes
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";
$textareaClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-3 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400 min-h-[120px] resize-y";

require_once 'includes/header.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">

    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div id="broadcastFormContent" class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header (Glass Panel) -->
            <div
                class="glass-panel rounded-2xl p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4 animate-fade-in-down relative z-30">
                <div class="flex items-center gap-4">
                    <div
                        class="w-12 h-12 rounded-xl bg-orange-100 dark:bg-orange-900/20 text-primary flex items-center justify-center text-2xl">
                        <ion-icon name="megaphone-outline"></ion-icon>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight"
                            id="pageHeaderTitle">
                            <?php echo $pageTitle; ?>
                        </h1>
                        <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Compose and schedule messages for your
                            network.</p>
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <a href="broadcasts.php"
                        class="px-4 py-2 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-red-500 hover:border-red-200 dark:hover:border-red-900/30 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-xl text-sm font-semibold transition-all shadow-sm flex items-center gap-2">
                        <ion-icon name="close-outline" class="text-lg"></ion-icon>
                        <span>Cancel</span>
                    </a>

                    <button type="submit" form="broadcastForm"
                        class="px-5 py-2 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="paper-plane-outline" class="text-lg"></ion-icon>
                        <span>Send Broadcast</span>
                    </button>
                </div>
            </div>

            <!-- Main Form Card -->
            <div class="glass-panel rounded-2xl animate-fade-in-up">

                <!-- Tabs Header -->
                <div
                    class="border-b border-gray-100 dark:border-gray-700 bg-gray-50/50 dark:bg-slate-800/50 px-6 pt-4 rounded-t-2xl">
                    <div class="flex gap-6 overflow-x-auto custom-scrollbar" id="formTabs">
                        <button
                            class="tab-btn active pb-4 px-2 text-sm font-semibold border-b-2 border-primary text-primary transition-colors whitespace-nowrap"
                            data-target="tab-content">
                            Message Content
                        </button>
                        <?php if (!$type): ?>
                            <button
                                class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap"
                                data-target="tab-channels">
                                Delivery Channels
                            </button>
                        <?php endif; ?>
                        <button
                            class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap"
                            data-target="tab-audience">
                            Target Audience
                        </button>
                        <button
                            class="tab-btn pb-4 px-2 text-sm font-semibold border-b-2 border-transparent text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors whitespace-nowrap"
                            data-target="tab-schedule">
                            Schedule
                        </button>
                    </div>
                </div>

                <!-- Form Content -->
                <form id="broadcastForm" class="p-6 md:p-8" method="POST" action="broadcasts.php">

                    <!-- TAB: Message Content -->
                    <div id="tab-content" class="tab-content space-y-8">
                        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                            <!-- Left: Inputs -->
                            <div class="lg:col-span-2 space-y-6">
                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Broadcast Title
                                        <span class="text-red-500">*</span></label>
                                    <input type="text" class="<?php echo $inputClass; ?>"
                                        placeholder="e.g. System Maintenance Update" required>
                                    <p class="text-xs text-gray-400">Internal reference name for this broadcast.</p>
                                </div>

                                <?php if ($type !== 'sms'): ?>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Public Subject /
                                            Headline <span class="text-red-500">*</span></label>
                                        <input type="text" class="<?php echo $inputClass; ?>"
                                            placeholder="e.g. Important Update: Maintenance Scheduled" required>
                                        <p class="text-xs text-gray-400">This will be the email subject or notification
                                            title.</p>
                                    </div>
                                <?php endif; ?>

                                <?php if ($type === 'banner'): ?>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Alert
                                            Level</label>
                                        <div class="grid grid-cols-3 gap-3">
                                            <label class="cursor-pointer">
                                                <input type="radio" name="alert_level" value="info" class="peer sr-only"
                                                    checked>
                                                <div
                                                    class="p-3 rounded-xl border border-blue-200 dark:border-blue-800 bg-blue-50 dark:bg-blue-900/20 text-blue-700 dark:text-blue-400 peer-checked:ring-2 peer-checked:ring-blue-500 hover:bg-blue-100 dark:hover:bg-blue-900/40 transition-all text-center">
                                                    <div class="text-2xl mb-1"><ion-icon
                                                            name="information-circle"></ion-icon></div>
                                                    <span class="text-xs font-bold uppercase">Info</span>
                                                </div>
                                            </label>
                                            <label class="cursor-pointer">
                                                <input type="radio" name="alert_level" value="warning" class="peer sr-only">
                                                <div
                                                    class="p-3 rounded-xl border border-orange-200 dark:border-orange-800 bg-orange-50 dark:bg-orange-900/20 text-orange-700 dark:text-orange-400 peer-checked:ring-2 peer-checked:ring-orange-500 hover:bg-orange-100 dark:hover:bg-orange-900/40 transition-all text-center">
                                                    <div class="text-2xl mb-1"><ion-icon name="warning"></ion-icon></div>
                                                    <span class="text-xs font-bold uppercase">Warning</span>
                                                </div>
                                            </label>
                                            <label class="cursor-pointer">
                                                <input type="radio" name="alert_level" value="error" class="peer sr-only">
                                                <div
                                                    class="p-3 rounded-xl border border-red-200 dark:border-red-800 bg-red-50 dark:bg-red-900/20 text-red-700 dark:text-red-400 peer-checked:ring-2 peer-checked:ring-red-500 hover:bg-red-100 dark:hover:bg-red-900/40 transition-all text-center">
                                                    <div class="text-2xl mb-1"><ion-icon name="alert-circle"></ion-icon>
                                                    </div>
                                                    <span class="text-xs font-bold uppercase">Critical</span>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="space-y-2">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">
                                        <?php echo $type === 'sms' ? 'SMS Content (Text Only)' : 'Message Body'; ?>
                                    </label>
                                    <textarea class="<?php echo $textareaClass; ?>"
                                        placeholder="<?php echo $type === 'sms' ? 'Type your SMS message here...' : 'Type your message here...'; ?>"></textarea>
                                    <?php if ($type === 'sms'): ?>
                                        <p class="text-xs text-gray-400">Character count: <span id="charCount">0</span>/160
                                        </p>
                                    <?php endif; ?>
                                </div>

                                <?php if ($type !== 'sms'): ?>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Action Link /
                                            URL</label>
                                        <div class="relative">
                                            <ion-icon name="link-outline"
                                                class="absolute left-4 top-3.5 text-gray-400 text-lg"></ion-icon>
                                            <input type="url" class="<?php echo $inputClass; ?> pl-10"
                                                placeholder="https://">
                                        </div>
                                        <p class="text-xs text-gray-400">Optional: Where users should go when they click the
                                            message.</p>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Right: Media & Preview Helper -->
                            <div class="space-y-6">
                                <?php if ($type !== 'sms' && $type !== 'banner'): ?>
                                    <div class="space-y-2">
                                        <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Featured
                                            Image</label>
                                        <div
                                            class="w-full h-48 rounded-2xl bg-gray-50 dark:bg-slate-800 border-2 border-dashed border-gray-300 dark:border-gray-600 flex flex-col items-center justify-center text-gray-400 hover:border-primary hover:text-primary transition-all cursor-pointer group">
                                            <ion-icon name="cloud-upload-outline"
                                                class="text-4xl mb-2 group-hover:scale-110 transition-transform"></ion-icon>
                                            <span class="text-sm font-medium">Click to Upload</span>
                                            <span class="text-xs text-gray-500 mt-1">JPG, PNG (Max 2MB)</span>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div
                                    class="p-4 bg-blue-50 dark:bg-blue-900/20 rounded-xl border border-blue-100 dark:border-blue-800/30">
                                    <div class="flex gap-3">
                                        <ion-icon name="information-circle-outline"
                                            class="text-xl text-blue-500 shrink-0"></ion-icon>
                                        <div class="text-sm text-blue-800 dark:text-blue-300">
                                            <p class="font-semibold mb-1">Tip</p>
                                            <?php if ($type === 'sms'): ?>
                                                <p>SMS messages should be short and concise. Avoid special characters to
                                                    ensure deliverability.</p>
                                            <?php else: ?>
                                                <p>Keep your headline short (under 60 chars) for best results on mobile
                                                    devices.</p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TAB: Delivery Channels -->
                    <div id="tab-channels" class="tab-content hidden space-y-8">
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">

                            <!-- Channel: Portal Popup -->
                            <label class="cursor-pointer group relative">
                                <input type="checkbox" name="channel_popup" class="peer sr-only" <?php echo ($type === 'popup' || !$type) ? 'checked' : ''; ?>>
                                <div
                                    class="p-6 rounded-2xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 hover:border-primary/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all h-full flex flex-col gap-4">
                                    <div class="flex items-start justify-between">
                                        <div
                                            class="w-12 h-12 rounded-xl bg-orange-100 dark:bg-orange-900/30 text-primary flex items-center justify-center text-2xl">
                                            <ion-icon name="alert-circle-outline"></ion-icon>
                                        </div>
                                        <div
                                            class="w-6 h-6 rounded-full border-2 border-gray-300 dark:border-gray-600 peer-checked:border-primary peer-checked:bg-primary text-white flex items-center justify-center opacity-0 peer-checked:opacity-100 transition-opacity">
                                            <ion-icon name="checkmark-outline" class="text-sm"></ion-icon>
                                        </div>
                                    </div>
                                    <div>
                                        <h3 class="font-bold text-gray-800 dark:text-white text-lg">Portal Popup</h3>
                                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Displays a modal dialog
                                            when users log in to the web portal.</p>
                                    </div>
                                </div>
                            </label>

                            <!-- Channel: App Notification -->
                            <label class="cursor-pointer group relative">
                                <input type="checkbox" name="channel_push" class="peer sr-only" <?php echo ($type === 'push') ? 'checked' : ''; ?>>
                                <div
                                    class="p-6 rounded-2xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 hover:border-primary/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all h-full flex flex-col gap-4">
                                    <div class="flex items-start justify-between">
                                        <div
                                            class="w-12 h-12 rounded-xl bg-purple-100 dark:bg-purple-900/30 text-purple-600 dark:text-purple-400 flex items-center justify-center text-2xl">
                                            <ion-icon name="notifications-outline"></ion-icon>
                                        </div>
                                        <div
                                            class="w-6 h-6 rounded-full border-2 border-gray-300 dark:border-gray-600 peer-checked:border-primary peer-checked:bg-primary text-white flex items-center justify-center opacity-0 peer-checked:opacity-100 transition-opacity">
                                            <ion-icon name="checkmark-outline" class="text-sm"></ion-icon>
                                        </div>
                                    </div>
                                    <div>
                                        <h3 class="font-bold text-gray-800 dark:text-white text-lg">App Push</h3>
                                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Sends a push
                                            notification to installed Till Apps and Admin Apps.</p>
                                    </div>
                                </div>
                            </label>

                            <!-- Channel: Email -->
                            <label class="cursor-pointer group relative">
                                <input type="checkbox" name="channel_email" class="peer sr-only" <?php echo ($type === 'email') ? 'checked' : ''; ?>>
                                <div
                                    class="p-6 rounded-2xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 hover:border-primary/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all h-full flex flex-col gap-4">
                                    <div class="flex items-start justify-between">
                                        <div
                                            class="w-12 h-12 rounded-xl bg-blue-100 dark:bg-blue-900/30 text-blue-600 dark:text-blue-400 flex items-center justify-center text-2xl">
                                            <ion-icon name="mail-outline"></ion-icon>
                                        </div>
                                        <div
                                            class="w-6 h-6 rounded-full border-2 border-gray-300 dark:border-gray-600 peer-checked:border-primary peer-checked:bg-primary text-white flex items-center justify-center opacity-0 peer-checked:opacity-100 transition-opacity">
                                            <ion-icon name="checkmark-outline" class="text-sm"></ion-icon>
                                        </div>
                                    </div>
                                    <div>
                                        <h3 class="font-bold text-gray-800 dark:text-white text-lg">Email Blast</h3>
                                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Sends an HTML email to
                                            the registered email addresses of the target audience.</p>
                                    </div>
                                </div>
                            </label>

                            <!-- Channel: SMS -->
                            <label class="cursor-pointer group relative">
                                <input type="checkbox" name="channel_sms" class="peer sr-only" <?php echo ($type === 'sms') ? 'checked' : ''; ?>>
                                <div
                                    class="p-6 rounded-2xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 hover:border-primary/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all h-full flex flex-col gap-4">
                                    <div class="flex items-start justify-between">
                                        <div
                                            class="w-12 h-12 rounded-xl bg-green-100 dark:bg-green-900/30 text-green-600 dark:text-green-400 flex items-center justify-center text-2xl">
                                            <ion-icon name="chatbox-ellipses-outline"></ion-icon>
                                        </div>
                                        <div
                                            class="w-6 h-6 rounded-full border-2 border-gray-300 dark:border-gray-600 peer-checked:border-primary peer-checked:bg-primary text-white flex items-center justify-center opacity-0 peer-checked:opacity-100 transition-opacity">
                                            <ion-icon name="checkmark-outline" class="text-sm"></ion-icon>
                                        </div>
                                    </div>
                                    <div>
                                        <h3 class="font-bold text-gray-800 dark:text-white text-lg">SMS</h3>
                                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Sends a text message.
                                            Additional carrier fees may apply.</p>
                                    </div>
                                </div>
                            </label>

                            <!-- Channel: Banner -->
                            <label class="cursor-pointer group relative">
                                <input type="checkbox" name="channel_banner" class="peer sr-only" <?php echo ($type === 'banner') ? 'checked' : ''; ?>>
                                <div
                                    class="p-6 rounded-2xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 hover:border-primary/50 peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all h-full flex flex-col gap-4">
                                    <div class="flex items-start justify-between">
                                        <div
                                            class="w-12 h-12 rounded-xl bg-pink-100 dark:bg-pink-900/30 text-pink-600 dark:text-pink-400 flex items-center justify-center text-2xl">
                                            <ion-icon name="browsers-outline"></ion-icon>
                                        </div>
                                        <div
                                            class="w-6 h-6 rounded-full border-2 border-gray-300 dark:border-gray-600 peer-checked:border-primary peer-checked:bg-primary text-white flex items-center justify-center opacity-0 peer-checked:opacity-100 transition-opacity">
                                            <ion-icon name="checkmark-outline" class="text-sm"></ion-icon>
                                        </div>
                                    </div>
                                    <div>
                                        <h3 class="font-bold text-gray-800 dark:text-white text-lg">Dashboard Banner
                                        </h3>
                                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Adds a persistent alert
                                            banner to the top of the interface.</p>
                                    </div>
                                </div>
                            </label>

                        </div>
                    </div>

                    <!-- TAB: Audience -->
                    <div id="tab-audience" class="tab-content hidden space-y-8">
                        <div class="space-y-6">
                            <h3 class="text-lg font-bold text-gray-800 dark:text-white">Who should receive this?</h3>

                            <!-- Scope & Audience Type -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">

                                <!-- Scope Selector -->
                                <div class="space-y-3">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Broadcast
                                        Scope</label>
                                    <div class="flex gap-4">
                                        <label class="cursor-pointer">
                                            <input type="radio" name="scope" value="all" class="peer sr-only" checked
                                                onchange="toggleTargetSearch(false)">
                                            <div
                                                class="px-4 py-3 rounded-xl border border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 peer-checked:bg-orange-50 peer-checked:border-primary peer-checked:text-primary hover:border-orange-300 transition-all flex items-center gap-2">
                                                <ion-icon name="radio-button-on-outline"
                                                    class="peer-checked:block hidden text-lg"></ion-icon>
                                                <ion-icon name="radio-button-off-outline"
                                                    class="peer-checked:hidden block text-lg text-gray-400"></ion-icon>
                                                <span class="font-medium text-sm">Full Broadcast (All)</span>
                                            </div>
                                        </label>
                                        <label class="cursor-pointer">
                                            <input type="radio" name="scope" value="targeted" class="peer sr-only"
                                                onchange="toggleTargetSearch(true)">
                                            <div
                                                class="px-4 py-3 rounded-xl border border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 peer-checked:bg-orange-50 peer-checked:border-primary peer-checked:text-primary hover:border-orange-300 transition-all flex items-center gap-2">
                                                <ion-icon name="radio-button-on-outline"
                                                    class="peer-checked:block hidden text-lg"></ion-icon>
                                                <ion-icon name="radio-button-off-outline"
                                                    class="peer-checked:hidden block text-lg text-gray-400"></ion-icon>
                                                <span class="font-medium text-sm">Targeted (Individual)</span>
                                            </div>
                                        </label>
                                    </div>
                                </div>

                                <!-- Audience Type -->
                                <div class="space-y-3">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Audience
                                        Type</label>
                                    <div class="flex gap-2">
                                        <label class="cursor-pointer flex-1">
                                            <input type="checkbox" name="audience_partners" class="peer sr-only"
                                                checked>
                                            <div
                                                class="px-3 py-3 rounded-xl border border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 peer-checked:bg-orange-50 peer-checked:border-primary peer-checked:text-primary hover:border-orange-300 transition-all text-center">
                                                <span class="font-medium text-sm">Store Partners</span>
                                            </div>
                                        </label>
                                        <label class="cursor-pointer flex-1">
                                            <input type="checkbox" name="audience_customers" class="peer sr-only">
                                            <div
                                                class="px-3 py-3 rounded-xl border border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 peer-checked:bg-orange-50 peer-checked:border-primary peer-checked:text-primary hover:border-orange-300 transition-all text-center">
                                                <span class="font-medium text-sm">End Customers</span>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Targeted Search Input -->
                            <div id="targetSearchWrapper" class="hidden animate-fade-in-down space-y-2">
                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Search
                                    Recipients</label>
                                <div class="relative">
                                    <ion-icon name="search-outline"
                                        class="absolute left-4 top-3.5 text-gray-400 text-lg"></ion-icon>
                                    <input type="text" class="<?php echo $inputClass; ?> pl-10"
                                        placeholder="Type name, email, or store ID...">
                                    <button type="button"
                                        class="absolute right-3 top-2.5 px-3 py-1 bg-gray-100 dark:bg-slate-700 rounded-lg text-xs font-semibold text-gray-600 dark:text-gray-300 hover:bg-gray-200 transition-colors">Search</button>
                                </div>
                                <p class="text-xs text-gray-400">Search for specific stores, managers, or customers to
                                    add to the list.</p>
                            </div>

                            <div class="h-px bg-gray-100 dark:bg-gray-700"></div>

                            <!-- Role Filters -->
                            <div class="space-y-3">
                                <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Filter by
                                    Role</label>
                                <div class="grid grid-cols-2 sm:grid-cols-4 gap-3">
                                    <label
                                        class="flex items-center gap-2 cursor-pointer bg-gray-50 dark:bg-gray-800 p-3 rounded-xl border border-transparent hover:border-gray-200 dark:hover:border-gray-700">
                                        <input type="checkbox" name="role_superuser"
                                            class="w-4 h-4 text-primary rounded border-gray-300 focus:ring-primary"
                                            checked>
                                        <span class="text-sm text-gray-700 dark:text-gray-300">Super Admin</span>
                                    </label>
                                    <label
                                        class="flex items-center gap-2 cursor-pointer bg-gray-50 dark:bg-gray-800 p-3 rounded-xl border border-transparent hover:border-gray-200 dark:hover:border-gray-700">
                                        <input type="checkbox" name="role_owner"
                                            class="w-4 h-4 text-primary rounded border-gray-300 focus:ring-primary"
                                            checked>
                                        <span class="text-sm text-gray-700 dark:text-gray-300">Store Owner</span>
                                    </label>
                                    <label
                                        class="flex items-center gap-2 cursor-pointer bg-gray-50 dark:bg-gray-800 p-3 rounded-xl border border-transparent hover:border-gray-200 dark:hover:border-gray-700">
                                        <input type="checkbox" name="role_manager"
                                            class="w-4 h-4 text-primary rounded border-gray-300 focus:ring-primary"
                                            checked>
                                        <span class="text-sm text-gray-700 dark:text-gray-300">Manager</span>
                                    </label>
                                    <label
                                        class="flex items-center gap-2 cursor-pointer bg-gray-50 dark:bg-gray-800 p-3 rounded-xl border border-transparent hover:border-gray-200 dark:hover:border-gray-700">
                                        <input type="checkbox" name="role_employee"
                                            class="w-4 h-4 text-primary rounded border-gray-300 focus:ring-primary">
                                        <span class="text-sm text-gray-700 dark:text-gray-300">Employee</span>
                                    </label>
                                </div>
                            </div>

                            <div class="h-px bg-gray-100 dark:bg-gray-700"></div>

                            <!-- Store Filters -->
                            <div class="space-y-4">
                                <div class="flex items-center justify-between">
                                    <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Target
                                        Stores</label>
                                    <label class="flex items-center gap-2 cursor-pointer">
                                        <input type="checkbox" id="allStoresToggle"
                                            class="w-4 h-4 text-primary rounded border-gray-300 focus:ring-primary"
                                            checked
                                            onchange="document.getElementById('storeSelectWrapper').classList.toggle('hidden', this.checked)">
                                        <span class="text-sm text-gray-600 dark:text-gray-400">All Stores</span>
                                    </label>
                                </div>

                                <div id="storeSelectWrapper" class="hidden animate-fade-in-down">
                                    <select class="<?php echo $inputClass; ?>" multiple size="5">
                                        <option value="1001">Cardiff Central (Restaurant)</option>
                                        <option value="1002">Newport Express (Grocery)</option>
                                        <option value="1003">Bristol Pop-up (Restaurant)</option>
                                        <option value="1004">London Main (Retail)</option>
                                    </select>
                                    <p class="text-xs text-gray-400 mt-1">Hold Ctrl/Cmd to select multiple stores.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TAB: Schedule -->
                    <div id="tab-schedule" class="tab-content hidden space-y-8">
                        <div class="max-w-xl">
                            <h3 class="text-lg font-bold text-gray-800 dark:text-white mb-6">When should this send?</h3>

                            <div class="space-y-4">
                                <label class="cursor-pointer relative block">
                                    <input type="radio" name="schedule_type" value="now" class="peer sr-only" checked
                                        onchange="toggleScheduleDate(false)">
                                    <div
                                        class="p-4 rounded-xl border border-gray-200 dark:border-gray-700 hover:border-primary peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all flex items-center gap-3">
                                        <div
                                            class="w-5 h-5 rounded-full border border-gray-300 peer-checked:border-primary peer-checked:bg-primary flex items-center justify-center">
                                            <div class="w-2 h-2 rounded-full bg-white"></div>
                                        </div>
                                        <span class="font-medium text-gray-700 dark:text-gray-300">Send
                                            Immediately</span>
                                    </div>
                                </label>

                                <label class="cursor-pointer relative block">
                                    <input type="radio" name="schedule_type" value="later" class="peer sr-only"
                                        onchange="toggleScheduleDate(true)">
                                    <div
                                        class="p-4 rounded-xl border border-gray-200 dark:border-gray-700 hover:border-primary peer-checked:border-primary peer-checked:bg-orange-50 dark:peer-checked:bg-primary/10 transition-all flex items-center gap-3">
                                        <div
                                            class="w-5 h-5 rounded-full border border-gray-300 peer-checked:border-primary peer-checked:bg-primary flex items-center justify-center">
                                            <div class="w-2 h-2 rounded-full bg-white"></div>
                                        </div>
                                        <span class="font-medium text-gray-700 dark:text-gray-300">Schedule for
                                            Later</span>
                                    </div>
                                </label>

                                <div id="scheduleParams" class="hidden pl-8 space-y-4 animate-fade-in-down">
                                    <div class="grid grid-cols-2 gap-4">
                                        <div class="space-y-2">
                                            <label
                                                class="text-sm font-medium text-gray-700 dark:text-gray-300">Date</label>
                                            <input type="date" class="<?php echo $inputClass; ?>">
                                        </div>
                                        <div class="space-y-2">
                                            <label
                                                class="text-sm font-medium text-gray-700 dark:text-gray-300">Time</label>
                                            <input type="time" class="<?php echo $inputClass; ?>">
                                        </div>
                                    </div>
                                    <div
                                        class="flex items-center gap-2 text-amber-600 bg-amber-50 dark:bg-amber-900/10 p-3 rounded-lg text-sm border border-amber-100 dark:border-amber-800/30">
                                        <ion-icon name="time-outline" class="text-lg"></ion-icon>
                                        <span>Based on System Time (UTC)</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </form>
            </div>

        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script>
    // Tab Switching Logic
    const tabs = document.querySelectorAll('.tab-btn');
    const contents = document.querySelectorAll('.tab-content');

    tabs.forEach(tab => {
        tab.addEventListener('click', () => {
            // Remove active state from all
            tabs.forEach(t => {
                t.classList.remove('active', 'border-primary', 'text-primary');
                t.classList.add('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'dark:text-gray-400', 'dark:hover:text-gray-200');
            });
            contents.forEach(c => c.classList.add('hidden'));

            // Add active state to clicked
            tab.classList.add('active', 'border-primary', 'text-primary');
            tab.classList.remove('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'dark:text-gray-400', 'dark:hover:text-gray-200');

            // Show content
            const targetId = tab.dataset.target;
            document.getElementById(targetId).classList.remove('hidden');

            // Fade in effect
            document.getElementById(targetId).classList.add('animate-fade-in-up');
        });
    });

    function toggleScheduleDate(show) {
        const el = document.getElementById('scheduleParams');
        if (show) {
            el.classList.remove('hidden');
        } else {
            el.classList.add('hidden');
        }
    }

    function toggleTargetSearch(show) {
        const el = document.getElementById('targetSearchWrapper');
        if (show) {
            el.classList.remove('hidden');
        } else {
            el.classList.add('hidden');
        }
    }
</script>
</body>

</html>