<?php
include 'includes/session.php';
$pageTitle = "System Audit Logs";
$currentPage = "audit_logs";

// Styles
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';

// Mock Data
$logs = [
    [
        'id' => 10234,
        'time' => '2026-01-16 14:32:10',
        'actor' => 'Ali K.',
        'actor_role' => 'Manager',
        'store' => 'FNF Cardiff',
        'device' => 'Back Office PC',
        'action' => 'user.update',
        'entity' => 'User: Sarah J.',
        'summary' => 'Updated permissions',
        'ip' => '192.168.1.10',
        'meta' => json_encode([
            'before' => ['role' => 'Cashier', 'access' => ['till']],
            'after' => ['role' => 'Supervisor', 'access' => ['till', 'portal']]
        ], JSON_PRETTY_PRINT)
    ],
    [
        'id' => 10233,
        'time' => '2026-01-16 14:30:05',
        'actor' => 'System',
        'actor_role' => 'Bot',
        'store' => 'FNF Cardiff',
        'device' => 'Server',
        'action' => 'sync.inventory',
        'entity' => 'Catalog',
        'summary' => 'Auto-sync completed',
        'ip' => '127.0.0.1',
        'meta' => json_encode([
            'status' => 'success',
            'items_updated' => 45,
            'duration' => '1.2s'
        ], JSON_PRETTY_PRINT)
    ],
    [
        'id' => 10232,
        'time' => '2026-01-16 14:15:22',
        'actor' => 'John D.',
        'actor_role' => 'Cashier',
        'store' => 'FNF Newport',
        'device' => 'Till 1',
        'action' => 'order.void',
        'entity' => 'Order #9921',
        'summary' => 'Voided entire order',
        'ip' => '192.168.2.20',
        'meta' => json_encode([
            'reason' => 'Customer left without paying',
            'amount' => 12.50,
            'items' => ['Milk', 'Bread']
        ], JSON_PRETTY_PRINT)
    ],
    [
        'id' => 10231,
        'time' => '2026-01-16 14:10:00',
        'actor' => 'Sarah J.',
        'actor_role' => 'Admin',
        'store' => 'FNF Bristol',
        'device' => 'iPad Pro',
        'action' => 'settings.change',
        'entity' => 'Tax Rate',
        'summary' => 'Changed global VAT',
        'ip' => '10.0.0.15',
        'meta' => json_encode([
            'old_value' => '20.0%',
            'new_value' => '20.0% (Verified)'
        ], JSON_PRETTY_PRINT)
    ]
];

?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20 overflow-y-auto custom-scrollbar">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header & Filters -->
            <div class="glass-panel rounded-2xl p-6 relative z-30">
                <div class="flex flex-col lg:flex-row lg:items-center justify-between gap-6 mb-8">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 rounded-2xl bg-primary/10 flex items-center justify-center text-primary">
                            <ion-icon name="shield-checkmark" class="text-2xl"></ion-icon>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">System Audit Logs</h1>
                            <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Detailed secure record of all system events and user actions.</p>
                        </div>
                    </div>
                    <div class="flex items-center gap-3">
                        <button class="px-4 py-2.5 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-primary hover:border-primary/30 rounded-xl text-sm font-bold transition-all shadow-sm flex items-center gap-2 group">
                            <ion-icon name="download-outline" class="text-lg"></ion-icon>
                            <span>Export CSV</span>
                        </button>
                    </div>
                </div>

                <!-- Filters -->
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-4 items-end">
                    <!-- Date Range -->
                    <div class="lg:col-span-1">
                        <label class="block text-[11px] font-bold text-gray-400 dark:text-gray-500 uppercase tracking-widest mb-2 px-1">Date Range</label>
                        <?php 
                            $pickerId = 'audit_date'; 
                            $btnClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group cursor-pointer";
                            include 'includes/components/date_picker.php'; 
                        ?>
                    </div>

                    <!-- Store -->
                    <div>
                        <label class="block text-[11px] font-bold text-gray-400 dark:text-gray-500 uppercase tracking-widest mb-2 px-1">Store</label>
                         <?php 
                            echo renderCustomSelect('All Stores', 'store_id', [
                                'all' => 'All Stores',
                                '1001' => 'FNF Cardiff',
                                '1002' => 'FNF Newport'
                            ], 'all'); 
                        ?>
                    </div>

                    <!-- Actor -->
                     <div>
                        <label class="block text-[11px] font-bold text-gray-400 dark:text-gray-500 uppercase tracking-widest mb-2 px-1">Actor / User</label>
                        <input type="text" class="<?php echo $inputClass; ?>" placeholder="e.g. Ali K.">
                    </div>

                     <!-- Action -->
                     <div>
                        <label class="block text-[11px] font-bold text-gray-400 dark:text-gray-500 uppercase tracking-widest mb-2 px-1">Action Key</label>
                        <input type="text" class="<?php echo $inputClass; ?>" placeholder="e.g. user.update">
                    </div>

                     <!-- Filter Btn -->
                     <div>
                         <button class="w-full px-4 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold transition-all shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transform hover:-translate-y-0.5">
                             Apply Filters
                         </button>
                     </div>
                </div>
            </div>

            <!-- Audit Table -->
            <div class="glass-panel rounded-2xl overflow-hidden border-none shadow-sm">
                <div class="overflow-x-auto custom-scrollbar">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest w-10 text-center"></th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">Time</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">Actor</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest font-mono">Context</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-center">Action</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">Summary</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">IP Address</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50 dark:divide-gray-700/30">
                            <?php foreach ($logs as $log): ?>
                            <tr class="group hover:bg-gray-50/50 dark:hover:bg-slate-800/30 transition-all cursor-pointer" onclick="toggleDetails(this, 'row-<?php echo $log['id']; ?>')">
                                <td class="py-4 px-6 text-center">
                                    <div class="w-8 h-8 rounded-lg flex items-center justify-center text-gray-400 hover:bg-white dark:hover:bg-slate-700 hover:text-primary transition-all shadow-sm group-hover:shadow-md border border-transparent group-hover:border-gray-100 dark:group-hover:border-gray-700">
                                        <ion-icon name="chevron-forward-outline" class="text-lg transition-transform duration-300 details-chevron"></ion-icon>
                                    </div>
                                </td>
                                
                                <td class="py-4 px-6 whitespace-nowrap">
                                    <div class="text-sm font-bold text-gray-800 dark:text-white font-mono"><?php echo date('H:i:s', strtotime($log['time'])); ?></div>
                                    <div class="text-[11px] text-gray-500 font-medium uppercase tracking-tighter mt-0.5"><?php echo date('M d, Y', strtotime($log['time'])); ?></div>
                                </td>

                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-3">
                                        <div class="w-9 h-9 rounded-xl bg-orange-100 dark:bg-orange-500/10 text-orange-600 dark:text-orange-400 flex items-center justify-center text-xs font-bold shadow-sm">
                                            <?php echo substr($log['actor'], 0, 1); ?>
                                        </div>
                                        <div>
                                            <div class="text-sm font-bold text-gray-800 dark:text-white"><?php echo $log['actor']; ?></div>
                                            <div class="text-[10px] text-gray-400 font-bold uppercase tracking-widest"><?php echo $log['actor_role']; ?></div>
                                        </div>
                                    </div>
                                </td>

                                <td class="py-4 px-6 font-mono">
                                    <div class="text-sm text-gray-700 dark:text-gray-300 font-bold"><?php echo $log['store']; ?></div>
                                    <div class="text-[10px] text-gray-500 flex items-center gap-1 mt-0.5 uppercase tracking-wide">
                                        <ion-icon name="hardware-chip-outline" class="text-xs"></ion-icon> <?php echo $log['device']; ?>
                                    </div>
                                </td>

                                <td class="py-4 px-6 text-center">
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-lg bg-gray-100 dark:bg-slate-700/50 text-[10px] font-bold font-mono text-gray-600 dark:text-gray-300 border border-gray-200 dark:border-gray-600/50 uppercase">
                                        <?php echo $log['action']; ?>
                                    </span>
                                </td>

                                <td class="py-4 px-6">
                                    <div class="text-sm text-gray-800 dark:text-white font-extrabold tracking-tight"><?php echo $log['entity']; ?></div>
                                    <div class="text-xs text-gray-500 font-medium mt-0.5"><?php echo $log['summary']; ?></div>
                                </td>

                                <td class="py-4 px-6 text-right">
                                    <span class="text-xs font-mono font-bold text-gray-400 bg-gray-50 dark:bg-slate-800/50 px-2 py-1 rounded-lg border border-gray-100 dark:border-gray-700/50"><?php echo $log['ip']; ?></span>
                                </td>
                            </tr>
                            
                            <!-- Expanded Meta -->
                            <tr id="row-<?php echo $log['id']; ?>" class="hidden bg-gray-50/30 dark:bg-slate-800/20">
                                <td colspan="7" class="p-8">
                                    <div class="bg-white dark:bg-slate-900 rounded-3xl border border-gray-100 dark:border-gray-700/50 p-6 shadow-xl relative overflow-hidden">
                                        <div class="absolute top-0 right-0 p-8 opacity-5">
                                            <ion-icon name="code-working-outline" class="text-8xl"></ion-icon>
                                        </div>
                                        <div class="relative z-10">
                                            <div class="flex items-center gap-2 mb-4">
                                                <div class="w-1.5 h-1.5 rounded-full bg-primary shadow-[0_0_8px_rgba(255,102,0,0.5)]"></div>
                                                <div class="text-[11px] font-extrabold text-gray-400 uppercase tracking-widest">Metadata Payload (JSON)</div>
                                            </div>
                                            <div class="bg-gray-50 dark:bg-slate-800/50 rounded-2xl p-6 border border-gray-100 dark:border-gray-700/30">
                                                <pre class="text-xs font-mono text-gray-600 dark:text-gray-300 whitespace-pre-wrap leading-relaxed"><?php echo $log['meta']; ?></pre>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                 <div class="border-t border-gray-50 dark:border-gray-700/30 bg-gray-50/30 dark:bg-slate-800/30 px-6 py-4 flex items-center justify-between">
                    <span class="text-xs font-bold text-gray-400 dark:text-gray-500 uppercase tracking-widest">Showing 1-4 of 1,284 logs</span>
                    <div class="flex gap-2">
                        <button class="px-3 py-1.5 rounded-xl border border-gray-200 dark:border-gray-700 text-xs font-bold text-gray-400 disabled:opacity-50 transition-all cursor-not-allowed" disabled>
                            <ion-icon name="chevron-back" class="align-middle"></ion-icon>
                        </button>
                        <button class="px-3 py-1.5 rounded-xl border border-gray-200 dark:border-gray-700 text-xs font-bold text-gray-600 dark:text-gray-300 hover:text-primary hover:border-primary/30 transition-all shadow-sm">
                            <ion-icon name="chevron-forward" class="align-middle"></ion-icon>
                        </button>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initCustomSelects(); 
        });

        function toggleDetails(row, targetId) {
            const detailRow = document.getElementById(targetId);
            const chevron = row.querySelector('.details-chevron');
            
            const isHidden = detailRow.classList.contains('hidden');
            
            if (!isHidden) {
                // Close it
                detailRow.classList.add('hidden');
                chevron.classList.remove('rotate-90', 'text-primary');
                row.classList.remove('bg-orange-50/50', 'dark:bg-primary/5');
            } else {
                // Open it
                detailRow.classList.remove('hidden');
                chevron.classList.add('rotate-90', 'text-primary');
                row.classList.add('bg-orange-50/50', 'dark:bg-primary/5');
            }
        }

        // --- Custom Select Logic ---
        function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);

                    const isHidden = dropdown.classList.contains('invisible');
                    if (isHidden) {
                        dropdown.classList.remove('opacity-0', 'invisible', '-translate-y-2');
                        trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.add('rotate-180', 'text-primary');
                    } else {
                        dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                        trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                });
            });
            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }

       // Handle Date Change
       function handleDateChange(fullUrl, pickerId, formattedDate) {
           console.log("Date changed to:", formattedDate);
           // window.location.href = fullUrl;
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
