<?php
include 'includes/session.php';
$pageTitle = "Attendance";
$currentPage = "attendance";

// Shared Style Classes (Reused)
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';

// Reuse helper
function renderCustomSelect($label, $name, $options, $selectedVal = '', $wrapperClass = '', $btnClass = '') {
    $selectedLabel = $label; 
    foreach ($options as $val => $text) {
        if ((string)$val === (string)$selectedVal) {
            $selectedLabel = $text;
            break;
        }
    }
    if ($selectedVal === '' && !empty($options)) {
         $valRef = array_keys($options)[0];
         $selectedVal = $valRef;
         $selectedLabel = $options[$valRef];
    }
    // ... Simplified reuse (Assuming same logic or including a helper file eventually) ...
    // For now, I'll inline the full logic to ensure it works immediately without a separate file refactor
    $optionsHtml = '';
    foreach ($options as $val => $text) {
        $activeClass = ((string)$val === (string)$selectedVal) ? 'active' : '';
        $checkOpacity = ((string)$val === (string)$selectedVal) ? 'opacity-100' : 'opacity-0';
        $optionsHtml .= '
        <div class="custom-select-option group flex items-center justify-between w-full px-3 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-slate-700/50 rounded-lg cursor-pointer transition-colors '.$activeClass.'" data-value="'.$val.'" data-label="'.htmlspecialchars($text).'">
            <span class="truncate">'.$text.'</span>
            <ion-icon name="checkmark-circle" class="text-primary text-lg ml-2 '.$checkOpacity.' check-icon"></ion-icon>
        </div>';
    }
    return '
    <div class="relative custom-select-container '.$wrapperClass.'">
        <input type="hidden" name="'.$name.'" value="'.$selectedVal.'">
        <button type="button" class="custom-select-trigger w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group '.$btnClass.'">
            <span class="truncate select-label">'.$selectedLabel.'</span>
            <ion-icon name="chevron-down-outline" class="text-gray-400 text-lg transition-transform duration-200 group-focus:text-primary"></ion-icon>
        </button>
        <div class="custom-select-dropdown absolute top-full left-0 mt-1 w-full bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-xl shadow-xl shadow-gray-200/50 dark:shadow-black/50 opacity-0 invisible transform -translate-y-2 transition-all duration-200 overflow-hidden z-50 max-h-60 overflow-y-auto custom-scrollbar">
            <div class="p-1 space-y-0.5">'.$optionsHtml.'</div>
        </div>
    </div>';
}
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20 overflow-y-auto custom-scrollbar">
        <div class="max-w-[1600px] mx-auto space-y-6">

            <!-- Header & Filters -->
            <div class="glass-panel rounded-2xl p-6 relative z-30">
                <div class="flex flex-col lg:flex-row lg:items-center justify-between gap-6">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 rounded-2xl bg-primary/10 flex items-center justify-center text-primary">
                            <ion-icon name="finger-print" class="text-2xl"></ion-icon>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Attendance</h1>
                            <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Track staff clock-ins, breaks, and hours.</p>
                        </div>
                    </div>

                    <div class="flex flex-col sm:flex-row items-center gap-3">
                        <!-- Date Picker -->
                        <div class="w-full sm:w-64">
                            <input type="hidden" id="filter_date" name="date" value="<?php echo date('Y-m-d'); ?>">
                            <?php 
                                $pickerId = 'att_date'; 
                                $urlParam = 'date';
                                $autoApply = true;
                                $showApplyButton = false;
                                $btnClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 flex items-center justify-between group cursor-pointer";
                                include 'includes/components/date_picker.php'; 
                            ?>
                        </div>

                        <!-- Store Selector -->
                        <div class="w-full sm:w-56">
                             <?php 
                                echo renderCustomSelect('All Stores', 'store_id', [
                                    'all' => 'All Stores',
                                    '1001' => 'FNF Cardiff',
                                    '1002' => 'FNF Swansea'
                                ], 'all'); 
                            ?>
                        </div>

                        <button class="px-4 py-2.5 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-primary hover:border-primary/30 rounded-xl text-sm font-bold transition-all shadow-sm flex items-center gap-2">
                            <ion-icon name="download-outline" class="text-lg"></ion-icon>
                            <span>Export</span>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Attendance Table -->
            <div class="glass-panel rounded-2xl overflow-hidden border-none shadow-sm">
                <div class="overflow-x-auto custom-scrollbar">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">Employee</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-center">Date</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-center">Clock In</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-center">Clock Out</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-center">Breaks</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">Net Hours</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-center">Status</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50 dark:divide-gray-700/30">
                            <!-- Mock Row 1 -->
                            <tr class="hover:bg-gray-50/50 dark:hover:bg-slate-800/30 transition-all group">
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-xl bg-orange-100 dark:bg-orange-500/10 text-orange-600 dark:text-orange-400 flex items-center justify-center text-sm font-bold shadow-sm transition-transform group-hover:scale-105">JD</div>
                                        <div>
                                            <div class="font-bold text-sm text-gray-800 dark:text-white">John Doe</div>
                                            <div class="text-[11px] text-gray-500 dark:text-gray-400 font-medium">Manager</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-sm text-center font-medium text-gray-600 dark:text-gray-300">Jan 16, 2026</td>
                                <td class="py-4 px-6 text-sm text-center font-mono font-bold text-gray-600 dark:text-gray-300 bg-gray-50/30 dark:bg-slate-800/30">08:55</td>
                                <td class="py-4 px-6 text-sm text-center font-mono font-bold text-gray-600 dark:text-gray-300">17:05</td>
                                <td class="py-4 px-6 text-sm text-center font-medium text-gray-500 dark:text-gray-400">30m</td>
                                <td class="py-4 px-6 text-sm font-extrabold text-gray-800 dark:text-white text-right font-mono tracking-tight">7h 40m</td>
                                <td class="py-4 px-6 text-center">
                                    <span class="inline-flex items-center gap-1.5 px-3 py-1 rounded-lg text-[11px] font-bold bg-green-50 text-green-600 dark:bg-green-500/10 dark:text-green-400 border border-green-100 dark:border-green-500/20">
                                        <div class="w-1.5 h-1.5 rounded-full bg-green-500 shadow-[0_0_8px_rgba(34,197,94,0.4)]"></div>
                                        ON TIME
                                    </span>
                                </td>
                                <td class="py-4 px-6 text-right">
                                    <button onclick="openModal('editAttendanceModal')" class="p-2 text-gray-400 hover:text-primary hover:bg-primary/5 rounded-lg transition-all" title="Request Correction">
                                        <ion-icon name="create-outline" class="text-xl"></ion-icon>
                                    </button>
                                </td>
                            </tr>
                            <!-- Mock Row 2 -->
                            <tr class="hover:bg-gray-50/50 dark:hover:bg-slate-800/30 transition-all group">
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-xl bg-blue-100 dark:bg-blue-500/10 text-blue-600 dark:text-blue-400 flex items-center justify-center text-sm font-bold shadow-sm transition-transform group-hover:scale-105">SS</div>
                                        <div>
                                            <div class="font-bold text-sm text-gray-800 dark:text-white">Sarah Smith</div>
                                            <div class="text-[11px] text-gray-500 dark:text-gray-400 font-medium">Sr. Cashier</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-sm text-center font-medium text-gray-600 dark:text-gray-300">Jan 16, 2026</td>
                                <td class="py-4 px-6 text-sm text-center font-mono font-bold text-red-500 bg-red-50/30 dark:bg-red-500/5">09:10</td>
                                <td class="py-4 px-6 text-sm text-center font-mono font-bold text-gray-400 dark:text-gray-600">--:--</td>
                                <td class="py-4 px-6 text-sm text-center font-medium text-gray-500 dark:text-gray-400">0m</td>
                                <td class="py-4 px-6 text-sm font-extrabold text-gray-400 dark:text-gray-600 text-right font-mono">...</td>
                                <td class="py-4 px-6 text-center">
                                    <span class="inline-flex items-center gap-1.5 px-3 py-1 rounded-lg text-[11px] font-bold bg-red-50 text-red-600 dark:bg-red-500/10 dark:text-red-400 border border-red-100 dark:border-red-500/20">
                                        <div class="w-1.5 h-1.5 rounded-full bg-red-500 shadow-[0_0_8px_rgba(239,68,68,0.4)]"></div>
                                        LATE IN
                                    </span>
                                </td>
                                <td class="py-4 px-6 text-right">
                                    <button onclick="openModal('editAttendanceModal')" class="p-2 text-gray-400 hover:text-primary hover:bg-primary/5 rounded-lg transition-all" title="Request Correction">
                                        <ion-icon name="create-outline" class="text-xl"></ion-icon>
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <!-- Pagination -->
                 <div class="border-t border-gray-50 dark:border-gray-700/30 bg-gray-50/30 dark:bg-slate-800/30 px-6 py-4 flex items-center justify-between">
                    <span class="text-xs font-bold text-gray-400 dark:text-gray-500 uppercase tracking-widest">Page 1 of 1</span>
                    <div class="flex gap-2">
                        <button class="px-3 py-1.5 rounded-xl border border-gray-200 dark:border-gray-700 text-xs font-bold text-gray-400 disabled:opacity-50 transition-all cursor-not-allowed" disabled>
                            <ion-icon name="chevron-back" class="align-middle"></ion-icon>
                        </button>
                        <button class="px-3 py-1.5 rounded-xl border border-gray-200 dark:border-gray-700 text-xs font-bold text-gray-400 disabled:opacity-50 transition-all cursor-not-allowed" disabled>
                            <ion-icon name="chevron-forward" class="align-middle"></ion-icon>
                        </button>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- Edit Attendance Modal -->
    <div id="editAttendanceModal" class="fixed inset-0 z-50 hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="fixed inset-0 bg-gray-900/60 backdrop-blur-sm transition-opacity opacity-0" id="modalBackdrop"></div>
        <div class="fixed inset-0 z-10 overflow-y-auto">
            <div class="flex min-h-full items-end justify-center p-4 text-center sm:items-center sm:p-0">
                <div class="relative transform overflow-hidden rounded-[2rem] bg-white dark:bg-slate-900 text-left shadow-2xl transition-all sm:my-8 sm:w-full sm:max-w-md opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" id="modalPanel">
                    
                    <div class="p-8 pb-4">
                        <div class="flex items-center justify-between mb-6">
                            <div class="flex items-center gap-4">
                                <div class="w-12 h-12 rounded-2xl bg-orange-50 dark:bg-orange-500/10 flex items-center justify-center text-primary">
                                    <ion-icon name="time" class="text-2xl"></ion-icon>
                                </div>
                                <div>
                                    <h3 class="text-xl font-bold text-gray-900 dark:text-white">Attendance Correction</h3>
                                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">Define correct timings for this session.</p>
                                </div>
                            </div>
                            <button onclick="closeModal('editAttendanceModal')" class="w-10 h-10 flex items-center justify-center rounded-xl hover:bg-gray-100 dark:hover:bg-slate-800 transition-colors text-gray-400">
                                <ion-icon name="close-outline" class="text-2xl"></ion-icon>
                            </button>
                        </div>

                        <div class="space-y-6">
                            <div class="p-4 bg-orange-50 dark:bg-orange-500/10 border border-orange-100 dark:border-orange-500/20 rounded-2xl flex items-start gap-3">
                                <ion-icon name="information-circle" class="text-primary text-xl mt-0.5"></ion-icon>
                                <p class="text-xs font-medium text-orange-800 dark:text-orange-400 leading-relaxed">
                                    Log corrections will be submitted to management for final approval before wages are adjusted.
                                </p>
                            </div>

                            <div class="grid grid-cols-2 gap-6">
                                <div class="space-y-2">
                                    <label class="text-[11px] font-bold text-gray-500 dark:text-gray-400 ml-1 uppercase tracking-widest">Clock In</label>
                                    <div class="relative">
                                        <?php 
                                            $pickerId = 'start_time'; 
                                            $value = '08:55';
                                            $nextPickerId = 'end_time';
                                            include 'includes/components/time_picker.php'; 
                                        ?>
                                    </div>
                                </div>
                                <div class="space-y-2">
                                    <label class="text-[11px] font-bold text-gray-500 dark:text-gray-400 ml-1 uppercase tracking-widest">Clock Out</label>
                                    <div class="relative">
                                        <?php 
                                            $pickerId = 'end_time'; 
                                            $value = '17:05';
                                            include 'includes/components/time_picker.php'; 
                                        ?>
                                    </div>
                                </div>
                            </div>

                             <div class="space-y-2">
                                <label class="text-[11px] font-bold text-gray-500 dark:text-gray-400 ml-1 uppercase tracking-widest">Reason for Correction</label>
                                <textarea rows="3" class="<?php echo $inputClass; ?> resize-none" placeholder="e.g. System failed to clock out automatically..."></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="bg-gray-50 dark:bg-slate-800/50 p-8 pt-4 sm:flex sm:flex-row-reverse gap-3">
                        <button type="button" class="px-8 py-3 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center justify-center gap-2 sm:w-auto w-full" onclick="closeModal('editAttendanceModal'); showToast('Correction requested successfully', 'success')">
                            <ion-icon name="send-outline" class="text-lg"></ion-icon>
                            <span>Submit Request</span>
                        </button>
                        <button type="button" class="px-6 py-3 bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white rounded-xl text-sm font-bold transition-all sm:w-auto w-full" onclick="closeModal('editAttendanceModal')">
                            Cancel
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initCustomSelects(); 
        });

       function openModal(modalId) {
            const modal = document.getElementById(modalId);
            const backdrop = modal.querySelector('#modalBackdrop');
            const panel = modal.querySelector('#modalPanel');
            modal.classList.remove('hidden');
            setTimeout(() => {
                backdrop.classList.remove('opacity-0');
                if(panel) {
                    panel.classList.remove('opacity-0', 'translate-y-4', 'sm:translate-y-0', 'sm:scale-95');
                    panel.classList.add('opacity-100', 'translate-y-0', 'sm:scale-100');
                }
            }, 10);
        }

        function closeModal(modalId) {
            const modal = document.getElementById(modalId);
            const backdrop = modal.querySelector('#modalBackdrop');
            const panel = modal.querySelector('#modalPanel');
            backdrop.classList.add('opacity-0');
            if(panel) {
                panel.classList.add('opacity-0', 'translate-y-4', 'sm:translate-y-0', 'sm:scale-95');
                panel.classList.remove('opacity-100', 'translate-y-0', 'sm:scale-100');
            }
            setTimeout(() => {
                modal.classList.add('hidden');
            }, 300);
        }

        // --- Custom Select Logic ---
        function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);

                    const isHidden = dropdown.classList.contains('invisible');
                    if (isHidden) {
                        dropdown.classList.remove('opacity-0', 'invisible', '-translate-y-2');
                        trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.add('rotate-180', 'text-primary');
                    } else {
                        dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                        trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                });
            });
            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }

       // Required for component interaction
       function handleDateChange(fullUrl, pickerId, formattedDate) {
           console.log("Date changed to:", formattedDate);
           // window.location.href = fullUrl; // Uncomment for real reload
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
