function initStoresPage() {
    console.log("Initializing Stores Page...");

    // Check if we are on the stores page
    const storesTable = document.getElementById('storesTableBody');
    if (!storesTable) return;

    // --- STORES TABLE FILTERING ---
    window.updateStoresTable = function (type, status) {
        const searchInput = document.getElementById('storeSearch');
        const searchTerm = searchInput ? searchInput.value.toLowerCase() : '';
        const rows = document.querySelectorAll('#storesTableBody tr');
        let visibleCount = 0;

        rows.forEach(row => {
            const rowType = row.dataset.type;
            const rowStatus = row.dataset.status;
            const rowText = row.innerText.toLowerCase();

            const typeMatch = (type === 'all' || type === rowType);
            const statusMatch = (status === 'all' || status === rowStatus);
            const searchMatch = (searchTerm === '' || rowText.includes(searchTerm));

            if (typeMatch && statusMatch && searchMatch) {
                row.style.display = '';
                row.classList.add('animate-fade-in-up');
                setTimeout(() => row.classList.remove('animate-fade-in-up'), 500);
                visibleCount++;
            } else {
                row.style.display = 'none';
            }
        });

        const totalRows = rows.length;
        const pagText = document.querySelector('.pagination-text');
        if (pagText) pagText.textContent = `Showing ${visibleCount} of ${totalRows} stores`;
    };

    // Re-initialize Search Listener
    const searchInput = document.getElementById('storeSearch');
    if (searchInput && !searchInput.dataset.initialized) {
        searchInput.dataset.initialized = "true";
        searchInput.addEventListener('input', () => {
            triggerStoreUpdate();
        });
    }

    // Filter Options Listeners (Type & Status)
    document.querySelectorAll('.type-filter-option, .status-filter-option').forEach(btn => {
        if (btn.dataset.initialized) return;
        btn.dataset.initialized = "true";
        btn.addEventListener('click', () => {
            setTimeout(() => {
                triggerStoreUpdate();
            }, 50); // Slightly longer delay for layout.js to finish class updates
        });
    });

    function triggerStoreUpdate() {
        let type = 'all';
        const activeType = document.querySelector('#typeFilterDropdown .type-filter-option.active');
        if (activeType) type = activeType.dataset.value;

        let status = 'all';
        const activeStatus = document.querySelector('#statusFilterDropdown .status-filter-option.active');
        if (activeStatus) status = activeStatus.dataset.value;

        window.updateStoresTable(type, status);
    }

    // Initial Run
    window.updateStoresTable('all', 'all');
}

// Support both initial load and SPA transitions
document.addEventListener('DOMContentLoaded', initStoresPage);

if (!window.stores_initialized) {
    document.addEventListener('pageLoaded', (e) => {
        if (e.detail.url.includes('stores.php')) {
            initStoresPage();
        }
    });
    window.stores_initialized = true;
}

// Status Toggle Listeners (Button) - Use Global Delegated Listener once
if (!document.stores_delegated_listener) {
    document.addEventListener('click', function (e) {
        const btn = e.target.closest('.status-toggle-btn');
        if (btn) {
            const rowId = btn.getAttribute('data-row-id');
            const currentStatus = btn.getAttribute('data-status');
            const badgeSpan = document.getElementById(`status-badge-${rowId}`);
            const row = btn.closest('tr');

            const newStatus = (currentStatus === 'active') ? 'inactive' : 'active';

            if (newStatus === 'active') {
                btn.className = 'status-toggle-btn p-1.5 rounded-lg transition-colors text-emerald-600 bg-emerald-50 hover:bg-emerald-100 dark:text-emerald-400 dark:bg-emerald-900/20 border border-emerald-100 dark:border-emerald-800/30';
                btn.title = 'Deactivate Store';
                btn.setAttribute('data-status', 'active');
            } else {
                btn.className = 'status-toggle-btn p-1.5 rounded-lg transition-colors text-red-600 bg-red-50 hover:bg-red-100 dark:text-red-400 dark:bg-red-900/20 border border-red-100 dark:border-red-800/30';
                btn.title = 'Activate Store';
                btn.setAttribute('data-status', 'inactive');
            }

            if (badgeSpan) {
                if (newStatus === 'active') {
                    badgeSpan.className = 'inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400 border border-green-200 dark:border-green-800';
                    badgeSpan.textContent = 'Active';
                } else {
                    badgeSpan.className = 'inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 dark:bg-red-900/30 text-red-700 dark:text-red-400 border border-red-200 dark:border-red-800';
                    badgeSpan.textContent = 'Inactive';
                }
            }

            if (row) {
                row.dataset.status = newStatus;
            }

            if (window.updateStoresTable) {
                // Trigger refresh based on current active filters
                let type = 'all';
                const activeType = document.querySelector('#typeFilterDropdown .type-filter-option.active');
                if (activeType) type = activeType.dataset.value;

                let status = 'all';
                const activeStatus = document.querySelector('#statusFilterDropdown .status-filter-option.active');
                if (activeStatus) status = activeStatus.dataset.value;

                window.updateStoresTable(type, status);
            }
        }
    });
    document.stores_delegated_listener = true;
}
