<?php
include 'includes/session.php';
$pageTitle = "Approvals Log";
$currentPage = "approvals_log";
require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';

// Mock Data
$approvals = [
    [
        'id' => 8821,
        'time' => '2026-01-16 11:45:00',
        'store' => 'FNF Cardiff',
        'requestor' => 'Temp Staff',
        'approver' => 'Ali K.',
        'action' => 'Void Item',
        'entity' => 'Crystal Bar (x5)',
        'reason' => 'Customer changed mind at till'
    ],
    [
        'id' => 8820,
        'time' => '2026-01-16 10:30:15',
        'store' => 'FNF Bristol',
        'requestor' => 'Junior Cashier',
        'approver' => 'Sarah J.',
        'action' => 'Refund',
        'entity' => 'Order #9221',
        'reason' => 'Defective product return'
    ],
    [
        'id' => 8819,
        'time' => '2026-01-15 16:20:00',
        'store' => 'FNF Newport',
        'requestor' => 'System',
        'approver' => 'Admin Override',
        'action' => 'Price Override',
        'entity' => 'Bulk Buy Deal',
        'reason' => 'Manager discretion for loyal customer'
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20 overflow-y-auto custom-scrollbar">
        <div class="max-w-[1600px] mx-auto space-y-8">

            <!-- Header & Filters -->
            <div class="glass-panel p-8 rounded-[2rem] relative overflow-hidden group border-none shadow-sm">
                <div class="absolute -top-4 -right-4 w-32 h-32 bg-primary/5 rounded-full blur-3xl group-hover:bg-primary/10 transition-colors"></div>
                <div class="relative z-10">
                    <div class="flex flex-col lg:flex-row lg:items-center justify-between gap-6">
                        <div class="flex items-center gap-4">
                            <div class="w-12 h-12 rounded-2xl bg-primary/10 flex items-center justify-center text-primary shadow-sm border border-primary/10">
                                <ion-icon name="thumbs-up-outline" class="text-2xl"></ion-icon>
                            </div>
                            <div>
                                <h1 class="text-2xl font-bold text-gray-800 dark:text-white tracking-tight">Approvals & Overrides</h1>
                                <p class="text-gray-500 dark:text-gray-400 text-sm mt-1">Audit trail of manager approvals and sensitive actions.</p>
                            </div>
                        </div>

                        <div class="flex flex-col sm:flex-row items-center gap-4 min-w-[300px] lg:min-w-[450px]">
                            <div class="relative group flex-1 w-full scale-100 focus-within:scale-[1.02] transition-transform">
                                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                    <ion-icon name="search-outline" class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                                </div>
                                <input type="text" class="w-full bg-white/50 dark:bg-slate-800/50 border border-gray-100 dark:border-gray-700 rounded-2xl px-5 pl-12 py-3 outline-none focus:ring-4 focus:ring-orange-500/10 focus:border-primary transition-all text-sm font-medium" placeholder="Search approvals by ID, user or action...">
                            </div>
                            <div class="w-full sm:w-56">
                                <?php echo renderCustomSelect('All Approvers', 'approver_id', ['all' => 'All Approvers', 'ali' => 'Ali K.', 'sarah' => 'Sarah J.'], 'all'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Approvals Table -->
            <div class="glass-panel rounded-2xl overflow-hidden shadow-sm border-none">
                <div class="overflow-x-auto custom-scrollbar">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest leading-relaxed">Time</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">Action</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">Flow (Requestor -> Approver)</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">Target Context</th>
                                <th class="py-4 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">Approval Reason</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50 dark:divide-gray-700/30">
                            <?php foreach ($approvals as $approval): ?>
                            <tr class="hover:bg-gray-50/50 dark:hover:bg-slate-800/30 transition-all group">
                                <!-- Time -->
                                <td class="py-4 px-6">
                                    <div class="font-extrabold text-sm text-gray-800 dark:text-white font-mono"><?php echo date('H:i', strtotime($approval['time'])); ?></div>
                                    <div class="text-[10px] text-gray-500 font-bold uppercase tracking-tighter mt-0.5"><?php echo date('M d, Y', strtotime($approval['time'])); ?></div>
                                </td>
                                
                                <!-- Action -->
                                <td class="py-4 px-6">
                                    <span class="inline-flex items-center px-3 py-1 rounded-lg text-[10px] font-extrabold uppercase tracking-widest bg-purple-50 text-purple-600 dark:bg-purple-900/20 dark:text-purple-400 border border-purple-100 dark:border-purple-800/50 shadow-sm">
                                        <?php echo $approval['action']; ?>
                                    </span>
                                </td>

                                <!-- Flow -->
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-3">
                                        <div class="flex flex-col items-end">
                                            <span class="text-sm font-bold text-gray-700 dark:text-gray-300"><?php echo $approval['requestor']; ?></span>
                                            <span class="text-[9px] text-gray-400 uppercase font-extrabold">Requestor</span>
                                        </div>
                                        <div class="flex flex-col items-center">
                                            <ion-icon name="arrow-forward-outline" class="text-primary text-lg animate-pulse-slow"></ion-icon>
                                        </div>
                                        <div class="flex flex-col items-start px-3 py-1 bg-primary/5 dark:bg-primary/10 rounded-xl border border-primary/10">
                                            <span class="text-sm font-extrabold text-primary"><?php echo $approval['approver']; ?></span>
                                            <span class="text-[9px] text-primary/60 uppercase font-extrabold tracking-widest">Authorized By</span>
                                        </div>
                                    </div>
                                </td>

                                <!-- Context -->
                                <td class="py-4 px-6">
                                    <div class="text-sm font-bold text-gray-800 dark:text-white tracking-tight"><?php echo $approval['entity']; ?></div>
                                    <div class="text-[10px] text-gray-500 font-medium flex items-center gap-1.5 mt-0.5">
                                        <ion-icon name="storefront-outline" class="text-xs"></ion-icon>
                                        <?php echo $approval['store']; ?>
                                    </div>
                                </td>

                                <!-- Reason -->
                                <td class="py-4 px-6">
                                    <div class="px-4 py-2 bg-gray-50 dark:bg-slate-800/50 rounded-xl border border-gray-100 dark:border-gray-700/50">
                                        <span class="text-xs text-gray-600 dark:text-gray-400 italic leading-relaxed">"<?php echo $approval['reason']; ?>"</span>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
             initCustomSelects(); 
        });

        // --- Custom Select Logic ---
        function initCustomSelects() {
            document.querySelectorAll('.custom-select-trigger').forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = trigger.closest('.custom-select-container');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    closeAllSelects(trigger);
                    
                    const isHidden = dropdown.classList.contains('invisible');
                    if (isHidden) {
                        dropdown.classList.remove('opacity-0', 'invisible', '-translate-y-2');
                        trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.add('rotate-180', 'text-primary');
                    } else {
                        dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                        trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                    }
                });
            });

            document.querySelectorAll('.custom-select-option').forEach(option => {
                option.addEventListener('click', (e) => {
                    e.stopPropagation();
                    const container = option.closest('.custom-select-container');
                    const hiddenInput = container.querySelector('input[type="hidden"]');
                    const triggerLabel = container.querySelector('.select-label');
                    const dropdown = container.querySelector('.custom-select-dropdown');
                    const trigger = container.querySelector('.custom-select-trigger');
                    
                    hiddenInput.value = option.dataset.value;
                    triggerLabel.textContent = option.dataset.label;
                    
                    container.querySelectorAll('.custom-select-option').forEach(opt => {
                        opt.classList.remove('active');
                        opt.querySelector('.check-icon')?.classList.replace('opacity-100', 'opacity-0');
                    });
                    
                    option.classList.add('active');
                    option.querySelector('.check-icon')?.classList.replace('opacity-0', 'opacity-100');
                    
                    dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                    trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
                });
            });
            document.addEventListener('click', () => closeAllSelects());
       }

       function closeAllSelects(exceptTrigger) {
            document.querySelectorAll('.custom-select-container').forEach(container => {
                const dropdown = container.querySelector('.custom-select-dropdown');
                const trigger = container.querySelector('.custom-select-trigger');
                if (exceptTrigger && trigger === exceptTrigger) return;
                dropdown.classList.add('opacity-0', 'invisible', '-translate-y-2');
                trigger.querySelector('ion-icon[name="chevron-down-outline"]')?.classList.remove('rotate-180', 'text-primary');
            });
       }
    </script>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>
