<?php
include 'includes/session.php';
$pageTitle = "Button Analytics";
$currentPage = "analytics_buttons";

// Styles
$inputClass = "w-full bg-white dark:bg-slate-800 border border-gray-200 dark:border-gray-700 rounded-xl px-4 py-2.5 outline-none focus:ring-2 focus:ring-orange-500/20 focus:border-orange-500 transition-all text-sm shadow-sm font-medium text-gray-600 dark:text-gray-300 placeholder-gray-400";

require_once 'includes/header.php';
require_once 'includes/components/custom_select_renderer.php';

// Mock Data
$topEvents = [
    ['key' => 'btn.cash', 'label' => 'Cash Tender', 'count' => 1250, 'trend' => '+5%'],
    ['key' => 'btn.card', 'label' => 'Card Tender', 'count' => 3400, 'trend' => '+12%'],
    ['key' => 'btn.refund', 'label' => 'Refund Item', 'count' => 45, 'trend' => '-2%'],
    ['key' => 'btn.drawer', 'label' => 'No Sale / Open Drawer', 'count' => 12, 'trend' => '-10%'],
];

?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">

    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20 overflow-y-auto custom-scrollbar">
        <div class="max-w-[1600px] mx-auto space-y-10">

            <!-- Header & Period Filter -->
            <div class="flex flex-col lg:flex-row lg:items-center justify-between gap-6">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Interaction Analytics
                    </h1>
                    <p class="text-gray-500 dark:text-gray-400 text-sm mt-1 font-medium">Analyze staff interactions and
                        hardware UI usage patterns.</p>
                </div>
                <div class="flex items-center gap-4">
                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <ion-icon name="calendar-outline"
                                class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                        </div>
                        <input type="text"
                            class="pl-12 pr-5 py-3 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 rounded-2xl text-sm font-bold focus:ring-4 focus:ring-orange-500/10 focus:border-primary transition-all placeholder-gray-400 w-56 shadow-sm shadow-black/5"
                            placeholder="Last 30 Days">
                    </div>
                    <button
                        class="w-11 h-11 bg-white dark:bg-slate-800 rounded-2xl border border-gray-100 dark:border-gray-700 flex items-center justify-center text-gray-400 hover:text-primary hover:border-primary/30 transition-all shadow-sm">
                        <ion-icon name="refresh-outline" class="text-xl"></ion-icon>
                    </button>
                </div>
            </div>

            <!-- Enhanced KPI Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <?php foreach ($topEvents as $i => $event):
                    $isPositive = strpos($event['trend'], '+') !== false;
                    ?>
                    <div
                        class="glass-panel p-6 rounded-3xl relative overflow-hidden group hover:-translate-y-1.5 transition-all duration-300 border-none shadow-sm hover:shadow-xl hover:shadow-orange-500/5">
                        <div
                            class="absolute -right-4 -bottom-4 w-24 h-24 bg-primary/5 rounded-full blur-2xl group-hover:bg-primary/10 transition-colors">
                        </div>
                        <div class="flex justify-between items-start mb-6">
                            <div
                                class="w-12 h-12 rounded-2xl bg-orange-50 dark:bg-orange-500/10 text-orange-500 flex items-center justify-center shadow-sm border border-orange-100 dark:border-orange-500/10">
                                <ion-icon name="finger-print" class="text-2xl"></ion-icon>
                            </div>
                            <div class="flex flex-col items-end">
                                <span
                                    class="inline-flex items-center px-2.5 py-1 rounded-full text-[10px] font-extrabold <?php echo $isPositive ? 'text-emerald-600 bg-emerald-50 dark:bg-emerald-500/10 border-emerald-100 dark:border-emerald-500/20' : 'text-rose-600 bg-rose-50 dark:bg-rose-500/10 border-rose-100 dark:border-rose-500/20'; ?> border shadow-sm">
                                    <ion-icon name="<?php echo $isPositive ? 'trending-up' : 'trending-down'; ?>"
                                        class="mr-1"></ion-icon>
                                    <?php echo $event['trend']; ?>
                                </span>
                            </div>
                        </div>
                        <div class="space-y-1">
                            <h3 class="text-3xl font-extrabold text-gray-800 dark:text-white tracking-tighter">
                                <?php echo number_format($event['count']); ?></h3>
                            <p class="text-[11px] text-gray-400 font-bold uppercase tracking-widest">
                                <?php echo $event['label']; ?></p>
                        </div>
                        <div
                            class="mt-4 pt-4 border-t border-gray-50 dark:border-gray-800/50 flex items-center justify-between">
                            <span
                                class="text-[10px] font-mono font-bold text-gray-400 dark:text-gray-500 uppercase tracking-widest opacity-60"><?php echo $event['key']; ?></span>
                            <div class="w-1.5 h-1.5 rounded-full bg-primary/40 group-hover:bg-primary transition-colors">
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Charts & Details -->
            <div class="grid grid-cols-1 xl:grid-cols-3 gap-8">
                <!-- Main Chart -->
                <div class="xl:col-span-2 glass-panel p-8 rounded-[2.5rem] border-none shadow-sm group">
                    <div class="flex items-center justify-between mb-8">
                        <div>
                            <h3 class="text-lg font-bold text-gray-800 dark:text-white tracking-tight">Interaction
                                Trends</h3>
                            <p class="text-xs text-gray-500 font-medium">Daily volume of primary POS interactions</p>
                        </div>
                        <div class="flex gap-2">
                            <button
                                class="px-3 py-1.5 bg-gray-50 dark:bg-slate-800 text-[10px] font-bold text-gray-400 uppercase tracking-widest rounded-lg hover:text-primary transition-colors">Week</button>
                            <button
                                class="px-3 py-1.5 bg-primary/10 text-[10px] font-extrabold text-primary uppercase tracking-widest rounded-lg">Month</button>
                        </div>
                    </div>
                    <div id="analyticsChart" class="w-full h-80 min-h-[350px]"></div>
                </div>

                <!-- Breakdown Table -->
                <div
                    class="glass-panel p-0 rounded-[2.5rem] overflow-hidden flex flex-col border-none shadow-sm relative">
                    <div class="absolute top-0 right-0 p-8 opacity-5 pointer-events-none">
                        <ion-icon name="rocket-outline" class="text-6xl"></ion-icon>
                    </div>
                    <div class="p-8 border-b border-gray-50 dark:border-gray-800/50">
                        <h3 class="text-lg font-bold text-gray-800 dark:text-white tracking-tight">Store Breakdown</h3>
                        <p class="text-xs text-gray-500 font-medium">Top performing locations by volume</p>
                    </div>
                    <div class="flex-1 overflow-y-auto max-h-[350px] custom-scrollbar">
                        <table class="w-full text-left">
                            <thead
                                class="bg-gray-50/50 dark:bg-slate-800/50 sticky top-0 backdrop-blur-md z-10 border-b border-gray-100 dark:border-gray-800">
                                <tr>
                                    <th class="py-4 px-8 text-[10px] font-bold text-gray-400 uppercase tracking-widest">
                                        Key Action</th>
                                    <th
                                        class="py-4 px-6 text-[10px] font-bold text-gray-400 uppercase tracking-widest text-right">
                                        Volume</th>
                                    <th
                                        class="py-4 px-8 text-[10px] font-bold text-gray-400 uppercase tracking-widest text-right">
                                        Leader</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-50 dark:divide-gray-800/30">
                                <?php
                                $breakdownItems = [
                                    ['action' => 'Cash Tender', 'val' => '1,250', 'store' => 'Cardiff', 'color' => 'bg-emerald-500'],
                                    ['action' => 'Card Tender', 'val' => '3,400', 'store' => 'Bristol', 'color' => 'bg-blue-500'],
                                    ['action' => 'Park Sale', 'val' => '302', 'store' => 'Newport', 'color' => 'bg-orange-500'],
                                    ['action' => 'Delete Item', 'val' => '150', 'store' => 'Cardiff', 'color' => 'bg-rose-500'],
                                    ['action' => 'Discount', 'val' => '89', 'store' => 'Bristol', 'color' => 'bg-purple-500']
                                ];
                                foreach ($breakdownItems as $item): ?>
                                    <tr class="hover:bg-gray-50/50 dark:hover:bg-slate-800/30 transition-all group">
                                        <td class="py-4 px-8">
                                            <div class="flex items-center gap-3">
                                                <div class="w-2 h-2 rounded-full <?php echo $item['color']; ?> shadow-sm">
                                                </div>
                                                <span
                                                    class="text-sm font-bold text-gray-700 dark:text-gray-300"><?php echo $item['action']; ?></span>
                                            </div>
                                        </td>
                                        <td
                                            class="py-4 px-6 text-sm text-right text-gray-800 dark:text-white font-extrabold font-mono">
                                            <?php echo $item['val']; ?></td>
                                        <td
                                            class="py-4 px-8 text-sm text-right text-gray-400 font-bold uppercase tracking-tighter">
                                            <?php echo $item['store']; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div
                        class="p-6 border-t border-gray-50 dark:border-gray-800/50 text-center bg-gray-50/30 dark:bg-slate-800/20">
                        <a href="#"
                            class="text-[10px] font-extrabold text-primary hover:text-orange-600 transition-all uppercase tracking-widest flex items-center justify-center gap-2">
                            <span>View Full Report</span>
                            <ion-icon name="arrow-forward-outline"></ion-icon>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Detailed Log Table -->
            <div class="glass-panel rounded-3xl overflow-hidden shadow-sm border-none">
                <div
                    class="px-8 py-6 border-b border-gray-50 dark:border-gray-800/50 flex justify-between items-center bg-gray-50/20 dark:bg-slate-800/20">
                    <div class="flex items-center gap-4">
                        <div
                            class="w-10 h-10 rounded-xl bg-primary/10 flex items-center justify-center text-primary border border-primary/20">
                            <ion-icon name="list-outline" class="text-xl"></ion-icon>
                        </div>
                        <h3 class="text-lg font-bold text-gray-800 dark:text-white tracking-tight">Recent Interactions
                            Log</h3>
                    </div>
                    <div class="flex gap-2">
                        <button
                            class="px-4 py-2 bg-white dark:bg-slate-800 text-gray-500 dark:text-gray-400 border border-gray-100 dark:border-gray-700 rounded-xl text-[10px] font-bold uppercase tracking-widest hover:text-primary hover:border-primary/20 transition-all shadow-sm">
                            <ion-icon name="person-outline" class="mr-1"></ion-icon> Filter by User
                        </button>
                    </div>
                </div>
                <div class="overflow-x-auto custom-scrollbar">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr
                                class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th
                                    class="py-5 px-8 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">
                                    Time</th>
                                <th
                                    class="py-5 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">
                                    Button / Action</th>
                                <th
                                    class="py-5 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">
                                    Staff User</th>
                                <th
                                    class="py-5 px-6 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest">
                                    Store Branch</th>
                                <th
                                    class="py-5 px-8 text-[11px] font-bold text-gray-500 dark:text-gray-400 uppercase tracking-widest text-right">
                                    Data Context</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50 dark:divide-gray-800/30">
                            <?php
                            $interactions = [
                                ['time' => '14:45:22', 'action' => 'Refund', 'user' => 'Sarah J.', 'store' => 'FNF Bristol', 'context' => 'Order #1029', 'type' => 'rose'],
                                ['time' => '14:44:10', 'action' => 'Cash Tender', 'user' => 'Ali K.', 'store' => 'FNF Cardiff', 'context' => '£12.50 Sale', 'type' => 'emerald'],
                                ['time' => '14:42:05', 'action' => 'Store Login', 'user' => 'System', 'store' => 'FNF Newport', 'context' => 'Device ID: X88', 'type' => 'amber'],
                                ['time' => '14:40:15', 'action' => 'Price Override', 'user' => 'Ali K.', 'store' => 'FNF Cardiff', 'context' => '-£5.00 Discount', 'type' => 'indigo']
                            ];
                            foreach ($interactions as $row):
                                $colorStr = $row['type'];
                                ?>
                                <tr class="hover:bg-gray-50/50 dark:hover:bg-slate-800/30 transition-all group">
                                    <td class="py-5 px-8">
                                        <div
                                            class="text-sm font-bold text-gray-600 dark:text-gray-400 font-mono tracking-tight">
                                            <?php echo $row['time']; ?></div>
                                    </td>
                                    <td class="py-5 px-6">
                                        <span
                                            class="inline-flex items-center px-3 py-1.5 rounded-xl bg-<?php echo $colorStr; ?>-50 dark:bg-<?php echo $colorStr; ?>-500/10 text-<?php echo $colorStr; ?>-600 dark:text-<?php echo $colorStr; ?>-400 text-[10px] font-extrabold uppercase tracking-widest border border-<?php echo $colorStr; ?>-100 dark:border-<?php echo $colorStr; ?>-500/20 shadow-sm">
                                            <div
                                                class="w-1.5 h-1.5 rounded-full bg-<?php echo $colorStr; ?>-500 mr-2 shadow-[0_0_8px_<?php echo $colorStr; ?>]">
                                            </div>
                                            <?php echo $row['action']; ?>
                                        </span>
                                    </td>
                                    <td class="py-5 px-6">
                                        <div class="text-sm font-bold text-gray-800 dark:text-white">
                                            <?php echo $row['user']; ?></div>
                                    </td>
                                    <td class="py-5 px-6">
                                        <div class="text-sm text-gray-500 font-medium tracking-tight">
                                            <?php echo $row['store']; ?></div>
                                    </td>
                                    <td class="py-5 px-8 text-right">
                                        <div
                                            class="text-[11px] font-bold text-gray-400 dark:text-gray-500 uppercase tracking-widest font-mono">
                                            <?php echo $row['context']; ?></div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>

    <!-- Scripts -->
    <script>
        window.addEventListener('load', () => {
            if (typeof ApexCharts !== 'undefined') {
                renderAnalyticsChart();
            }
        });

        function renderAnalyticsChart() {
            const el = document.querySelector("#analyticsChart");
            if (!el) return;

            const isDark = document.documentElement.classList.contains('dark');
            const textColor = isDark ? '#94a3b8' : '#64748b';
            const gridColor = isDark ? '#1e293b' : '#f1f5f9';
            const isMobile = window.innerWidth < 768;

            const options = {
                chart: {
                    type: 'area',
                    height: 350,
                    fontFamily: 'Inter, sans-serif',
                    background: 'transparent',
                    toolbar: { show: false },
                    zoom: { enabled: false },
                    animations: {
                        enabled: true,
                        easing: 'easeinout',
                        speed: 800,
                        animateGradually: { enabled: true, delay: 150 },
                        dynamicAnimation: { enabled: true, speed: 350 }
                    }
                },
                series: [
                    { name: 'Cash', data: [31, 40, 28, 51, 42, 109, 100] },
                    { name: 'Card', data: [11, 32, 45, 32, 34, 52, 41] },
                    { name: 'Refunds', data: [2, 11, 5, 8, 3, 2, 8] }
                ],
                colors: ['#FF6600', '#10B981', '#F43F5E'],
                dataLabels: { enabled: false },
                stroke: {
                    curve: 'smooth',
                    width: 4,
                    lineCap: 'round'
                },
                fill: {
                    type: 'gradient',
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.45,
                        opacityTo: 0.02,
                        stops: [0, 100]
                    }
                },
                xaxis: {
                    categories: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
                    labels: {
                        style: { colors: textColor, fontWeight: 700, fontSize: '10px' },
                        offsetY: 5
                    },
                    axisBorder: { show: false },
                    axisTicks: { show: false }
                },
                yaxis: {
                    labels: {
                        style: { colors: textColor, fontWeight: 700, fontSize: '10px' },
                        formatter: (val) => val.toLocaleString()
                    }
                },
                legend: {
                    position: 'top',
                    horizontalAlign: 'right',
                    labels: { colors: textColor, useSeriesColors: false },
                    fontFamily: 'Inter',
                    fontWeight: 700,
                    fontSize: '11px',
                    markers: { radius: 12, width: 10, height: 10 }
                },
                grid: {
                    borderColor: gridColor,
                    strokeDashArray: 8,
                    xaxis: { lines: { show: true } },
                    yaxis: { lines: { show: true } },
                    padding: { top: 0, right: 0, bottom: 0, left: 10 }
                },
                tooltip: {
                    theme: isDark ? 'dark' : 'light',
                    x: { show: false }
                },
                markers: {
                    size: 0,
                    hover: { size: 6 }
                }
            };

            const chart = new ApexCharts(el, options);
            chart.render();
        }
    </script>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>