<?php
include 'includes/session.php';
// admin_payables.php - Operational Expenses (Bills CashBox pays)
$pageTitle = "Admin Payables";
$currentPage = "admin_payables";
require_once 'includes/header.php';

// Mock Data for Admin Payables (OpEx)
$bills = [
    [
        'id' => 'INV-AMZ-2024-01',
        'provider' => 'Amazon Web Services',
        'service' => 'Cloud Infrastructure (EC2, S3)',
        'amount' => '1,240.50',
        'due_date' => '2026-02-01',
        'status' => 'Pending',
        'icon' => 'cloud-outline',
        'color' => 'orange'
    ],
    [
        'id' => 'INV-GOOG-2024-01',
        'provider' => 'Google Cloud Platform',
        'service' => 'Maps API & Firebase',
        'amount' => '450.20',
        'due_date' => '2026-01-28',
        'status' => 'Paid',
        'icon' => 'logo-google',
        'color' => 'blue'
    ],
    [
        'id' => 'INV-TWIL-2024-01',
        'provider' => 'Twilio',
        'service' => 'SMS Gateway Services',
        'amount' => '89.99',
        'due_date' => '2026-02-05',
        'status' => 'Pending',
        'icon' => 'chatbubble-ellipses-outline',
        'color' => 'red'
    ],
    [
        'id' => 'INV-STRIPE-2024-01',
        'provider' => 'Stripe Fees',
        'service' => 'Payment Processing',
        'amount' => '320.15',
        'due_date' => '2026-01-15',
        'status' => 'Paid',
        'icon' => 'card-outline',
        'color' => 'purple'
    ]
];
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div
                class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-10">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">Admin Payables</h1>
                    <p class="text-gray-500 dark:text-gray-400 mt-1">Manage operational expenses and service provider
                        bills.</p>
                </div>

                <div
                    class="flex items-center gap-4 bg-gray-50/50 dark:bg-gray-800/50 p-2 rounded-xl border border-gray-100 dark:border-gray-700 w-full xl:w-auto">
                    <div class="relative group w-full sm:w-64 shrink-0">
                        <div class="absolute inset-y-0 left-0 pl-3.5 flex items-center pointer-events-none">
                            <ion-icon name="search-outline"
                                class="text-gray-400 text-lg group-focus-within:text-primary transition-colors"></ion-icon>
                        </div>
                        <input type="text"
                            class="w-full bg-white dark:bg-slate-900 border border-gray-200 dark:border-gray-700 rounded-lg pl-10 pr-4 py-2 text-sm focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all outline-none"
                            placeholder="Search Provider...">
                    </div>

                    <button
                        class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-lg text-sm font-bold shadow-lg shadow-orange-500/30 hover:shadow-orange-500/50 transition-all transform hover:-translate-y-0.5 flex items-center gap-2 whitespace-nowrap">
                        <ion-icon name="add-circle-outline" class="text-xl"></ion-icon>
                        <span>Add Bill</span>
                    </button>
                </div>
            </div>

            <!-- Bills Table -->
            <div
                class="glass-panel rounded-2xl overflow-hidden shadow-sm border border-gray-100 dark:border-gray-700/50">
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr
                                class="bg-gray-50/50 dark:bg-slate-800/50 border-b border-gray-100 dark:border-gray-700">
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Service Provider</th>
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Service Type</th>
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">
                                    Amount</th>
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-center">
                                    Status</th>
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                    Due Date</th>
                                <th
                                    class="py-5 px-6 text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider text-right">
                                    Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-700/50">
                            <?php foreach ($bills as $bill): ?>
                                <tr class="group hover:bg-gray-50 dark:hover:bg-slate-800/30 transition-all">
                                    <td class="py-5 px-6">
                                        <div class="flex items-center gap-4">
                                            <div
                                                class="w-10 h-10 rounded-xl bg-<?php echo $bill['color']; ?>-50 dark:bg-<?php echo $bill['color']; ?>-900/20 flex items-center justify-center text-<?php echo $bill['color']; ?>-500 shadow-sm border border-<?php echo $bill['color']; ?>-100 dark:border-<?php echo $bill['color']; ?>-800/50">
                                                <ion-icon name="<?php echo $bill['icon']; ?>" class="text-xl"></ion-icon>
                                            </div>
                                            <div>
                                                <div
                                                    class="text-sm font-bold text-gray-800 dark:text-white group-hover:text-primary transition-colors">
                                                    <?php echo $bill['provider']; ?>
                                                </div>
                                                <div
                                                    class="text-[11px] font-medium text-gray-400 uppercase tracking-wider mt-0.5">
                                                    <?php echo $bill['id']; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="py-5 px-6">
                                        <div class="text-sm font-bold text-gray-700 dark:text-gray-200">
                                            <?php echo $bill['service']; ?>
                                        </div>
                                    </td>
                                    <td class="py-5 px-6 text-center">
                                        <div class="text-sm font-bold text-gray-700 dark:text-gray-200">£
                                            <?php echo $bill['amount']; ?>
                                        </div>
                                    </td>
                                    <td class="py-5 px-6 text-center">
                                        <?php
                                        $statusClass = '';
                                        $dotClass = '';
                                        if ($bill['status'] == 'Paid') {
                                            $statusClass = 'bg-emerald-50 dark:bg-emerald-900/20 text-emerald-600 dark:text-emerald-400 border-emerald-100 dark:border-emerald-800/50';
                                            $dotClass = 'bg-emerald-500';
                                        } elseif ($bill['status'] == 'Pending') {
                                            $statusClass = 'bg-orange-50 dark:bg-orange-900/20 text-orange-600 dark:text-orange-400 border-orange-100 dark:border-orange-800/50';
                                            $dotClass = 'bg-orange-500';
                                        }
                                        ?>
                                        <span
                                            class="inline-flex items-center px-2.5 py-1 rounded-lg text-[11px] font-bold border <?php echo $statusClass; ?>">
                                            <span class="w-1.5 h-1.5 rounded-full <?php echo $dotClass; ?> mr-2"></span>
                                            <?php echo strtoupper($bill['status']); ?>
                                        </span>
                                    </td>
                                    <td class="py-5 px-6">
                                        <div
                                            class="flex items-center gap-2 text-sm text-gray-600 dark:text-gray-400 font-medium">
                                            <ion-icon name="calendar-outline" class="text-gray-400"></ion-icon>
                                            <?php echo date('M d, Y', strtotime($bill['due_date'])); ?>
                                        </div>
                                    </td>
                                    <td class="py-5 px-6 text-right">
                                        <div
                                            class="flex items-center justify-end gap-2 opacity-0 group-hover:opacity-100 transition-all transform translate-x-2 group-hover:translate-x-0">
                                            <button
                                                class="p-2 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-500 hover:text-primary hover:border-primary/30 rounded-xl shadow-sm transition-all"
                                                title="View Bill">
                                                <ion-icon name="document-text-outline" class="text-lg"></ion-icon>
                                            </button>
                                            <button
                                                class="p-2 bg-white dark:bg-slate-800 border border-gray-100 dark:border-gray-700 text-gray-500 hover:text-emerald-600 hover:border-emerald-500/30 rounded-xl shadow-sm transition-all"
                                                title="Mark Paid">
                                                <ion-icon name="checkmark-circle-outline" class="text-lg"></ion-icon>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>