<?php
include 'includes/session.php';
// admin_dashboard.php - Super Admin Overview
$pageTitle = "Admin Dashboard";
$currentPage = "admin_dashboard";
require_once 'includes/header.php';
?>

<!-- Sidebar -->
<?php include 'includes/sidebar.php'; ?>

<main class="flex-1 flex flex-col relative z-0 overflow-y-auto w-full">
    <!-- Topbar -->
    <?php include 'includes/topbar.php'; ?>

    <!-- Page Content -->
    <div class="flex-1 p-6 md:p-8 pb-20">
        <div class="max-w-[1920px] mx-auto space-y-6">

            <!-- Header -->
            <div
                class="glass-panel rounded-2xl p-6 mb-8 flex flex-col xl:flex-row justify-between items-center gap-6 relative z-10">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800 dark:text-white tracking-tight">System Overview</h1>
                    <p class="text-gray-500 dark:text-gray-400 mt-1">Real-time monitoring of CashBox Portal
                        infrastructure and revenue.</p>
                </div>

                <div class="flex items-center gap-4">
                    <div
                        class="flex items-center gap-2 px-3 py-1.5 bg-emerald-50 dark:bg-emerald-900/20 text-emerald-600 dark:text-emerald-400 rounded-lg text-sm font-medium border border-emerald-100 dark:border-emerald-800/50">
                        <span class="relative flex h-2 w-2">
                            <span
                                class="animate-ping absolute inline-flex h-full w-full rounded-full bg-emerald-400 opacity-75"></span>
                            <span class="relative inline-flex rounded-full h-2 w-2 bg-emerald-500"></span>
                        </span>
                        All Systems Operational
                    </div>
                    <button
                        class="p-2.5 bg-gray-50 dark:bg-slate-800 rounded-xl hover:bg-white dark:hover:bg-slate-700 text-gray-400 hover:text-primary transition-all shadow-sm">
                        <ion-icon name="refresh-outline" class="text-xl"></ion-icon>
                    </button>
                    <button
                        class="px-5 py-2.5 bg-primary hover:bg-orange-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-orange-500/20 hover:shadow-orange-500/40 transition-all transform hover:-translate-y-0.5 flex items-center gap-2">
                        <ion-icon name="cloud-download-outline" class="text-lg"></ion-icon>
                        <span>System Report</span>
                    </button>
                </div>
            </div>

            <!-- KPI Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Total Stores -->
                <div
                    class="glass-panel rounded-2xl p-6 relative group hover:-translate-y-1 transition-transform duration-300">
                    <div class="flex justify-between items-start mb-4">
                        <span class="text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Active
                            Stores</span>
                        <div
                            class="w-10 h-10 rounded-xl bg-blue-50 dark:bg-blue-900/20 flex items-center justify-center text-blue-500">
                            <ion-icon name="storefront-outline" class="text-xl"></ion-icon>
                        </div>
                    </div>
                    <div class="flex items-baseline gap-2">
                        <span class="text-3xl font-bold text-gray-800 dark:text-white">124</span>
                        <span
                            class="text-xs font-bold text-green-500 bg-green-50 dark:bg-green-900/20 px-1.5 py-0.5 rounded">+3
                            this week</span>
                    </div>
                </div>

                <!-- Monthly Revenue -->
                <div
                    class="glass-panel rounded-2xl p-6 relative group hover:-translate-y-1 transition-transform duration-300">
                    <div class="flex justify-between items-start mb-4">
                        <span
                            class="text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Platform
                            Revenue</span>
                        <div
                            class="w-10 h-10 rounded-xl bg-orange-50 dark:bg-orange-900/20 flex items-center justify-center text-orange-500">
                            <ion-icon name="cash-outline" class="text-xl"></ion-icon>
                        </div>
                    </div>
                    <div class="flex items-baseline gap-2">
                        <span class="text-3xl font-bold text-gray-800 dark:text-white">£24.5k</span>
                        <span
                            class="text-xs font-bold text-green-500 bg-green-50 dark:bg-green-900/20 px-1.5 py-0.5 rounded">+12%
                            vs last mo</span>
                    </div>
                </div>

                <!-- API Requests -->
                <div
                    class="glass-panel rounded-2xl p-6 relative group hover:-translate-y-1 transition-transform duration-300">
                    <div class="flex justify-between items-start mb-4">
                        <span class="text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">API
                            Requests (24h)</span>
                        <div
                            class="w-10 h-10 rounded-xl bg-purple-50 dark:bg-purple-900/20 flex items-center justify-center text-purple-500">
                            <ion-icon name="pulse-outline" class="text-xl"></ion-icon>
                        </div>
                    </div>
                    <div class="flex items-baseline gap-2">
                        <span class="text-3xl font-bold text-gray-800 dark:text-white">1.2m</span>
                        <span class="text-xs font-bold text-gray-400">Stable</span>
                    </div>
                </div>

                <!-- Critical Alerts -->
                <div
                    class="glass-panel rounded-2xl p-6 relative group hover:-translate-y-1 transition-transform duration-300">
                    <div class="flex justify-between items-start mb-4">
                        <span class="text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">System
                            Alerts</span>
                        <div
                            class="w-10 h-10 rounded-xl bg-red-50 dark:bg-red-900/20 flex items-center justify-center text-red-500">
                            <ion-icon name="warning-outline" class="text-xl"></ion-icon>
                        </div>
                    </div>
                    <div class="flex items-baseline gap-2">
                        <span class="text-3xl font-bold text-gray-800 dark:text-white">0</span>
                        <span class="text-xs font-bold text-gray-400">All Clear</span>
                    </div>
                </div>
            </div>

            <!-- Main Charts Row -->
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Revenue Trend -->
                <div class="lg:col-span-2 glass-panel rounded-2xl p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-bold text-gray-800 dark:text-white">Revenue Trend</h3>
                        <div class="flex gap-2">
                            <button
                                class="px-3 py-1 text-xs font-bold bg-gray-100 dark:bg-slate-700 text-gray-600 dark:text-gray-300 rounded-lg hover:bg-white dark:hover:bg-slate-600 transition-colors">Weekly</button>
                            <button
                                class="px-3 py-1 text-xs font-bold bg-primary text-white rounded-lg shadow-lg shadow-orange-500/30">Monthly</button>
                        </div>
                    </div>
                    <div id="revenueTrendChart" class="w-full min-h-[350px]"></div>
                </div>

                <!-- System Health -->
                <div class="glass-panel rounded-2xl p-6 flex flex-col">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white mb-6">System Health</h3>
                    <div id="systemHealthChart" class="flex-1 w-full min-h-[300px] flex items-center justify-center">
                    </div>
                    <div class="grid grid-cols-3 gap-2 mt-4 text-center">
                        <div class="p-2 rounded-lg bg-blue-50 dark:bg-blue-900/10">
                            <div class="text-xs text-gray-500 dark:text-gray-400 uppercase font-bold">CPU</div>
                            <div class="text-sm font-bold text-blue-600 dark:text-blue-400">42%</div>
                        </div>
                        <div class="p-2 rounded-lg bg-green-50 dark:bg-green-900/10">
                            <div class="text-xs text-gray-500 dark:text-gray-400 uppercase font-bold">RAM</div>
                            <div class="text-sm font-bold text-green-600 dark:text-green-400">65%</div>
                        </div>
                        <div class="p-2 rounded-lg bg-orange-50 dark:bg-orange-900/10">
                            <div class="text-xs text-gray-500 dark:text-gray-400 uppercase font-bold">DB</div>
                            <div class="text-sm font-bold text-orange-600 dark:text-orange-400">28%</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Secondary Row -->
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">

                <!-- Recent Alerts Widget -->
                <div class="glass-panel rounded-2xl p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-bold text-gray-800 dark:text-white">Recent Alerts</h3>
                        <button class="text-xs text-primary font-bold hover:underline">View Logs</button>
                    </div>
                    <div class="space-y-4">
                        <div
                            class="flex items-start gap-3 p-3 rounded-xl bg-red-50 dark:bg-red-900/10 border border-red-100 dark:border-red-900/20">
                            <ion-icon name="alert-circle" class="text-red-500 text-xl mt-0.5"></ion-icon>
                            <div>
                                <h4 class="text-sm font-bold text-gray-800 dark:text-white">API High Latency</h4>
                                <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">Response time > 2s on
                                    /api/v1/sync</p>
                                <span class="text-[10px] text-gray-400 font-mono mt-2 block">10:42 AM - Today</span>
                            </div>
                        </div>
                        <div
                            class="flex items-start gap-3 p-3 rounded-xl bg-orange-50 dark:bg-orange-900/10 border border-orange-100 dark:border-orange-900/20">
                            <ion-icon name="server-outline" class="text-orange-500 text-xl mt-0.5"></ion-icon>
                            <div>
                                <h4 class="text-sm font-bold text-gray-800 dark:text-white">Backup Warning</h4>
                                <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">Incremental backup took
                                    longer than expected.</p>
                                <span class="text-[10px] text-gray-400 font-mono mt-2 block">04:00 AM - Today</span>
                            </div>
                        </div>
                        <div
                            class="flex items-start gap-3 p-3 rounded-xl bg-green-50 dark:bg-green-900/10 border border-green-100 dark:border-green-900/20">
                            <ion-icon name="checkmark-circle" class="text-green-500 text-xl mt-0.5"></ion-icon>
                            <div>
                                <h4 class="text-sm font-bold text-gray-800 dark:text-white">System Update</h4>
                                <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">Patch v2.4.1 deployed
                                    successfully.</p>
                                <span class="text-[10px] text-gray-400 font-mono mt-2 block">Yesterday</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- OpEx Chart -->
                <div class="glass-panel rounded-2xl p-6">
                    <h3 class="text-lg font-bold text-gray-800 dark:text-white mb-6">Revenue vs Expenses</h3>
                    <div id="opexComparisonChart" class="w-full min-h-[250px]"></div>
                </div>

                <!-- Top Performing Stores -->
                <div class="glass-panel rounded-2xl p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-bold text-gray-800 dark:text-white">Top Stores</h3>
                        <button class="text-xs text-primary font-bold hover:underline">Full Report</button>
                    </div>
                    <div class="space-y-4">
                        <?php
                        $topStores = [
                            ['name' => 'FNF Cardiff', 'rev' => '£8,450', 'trend' => '+12%'],
                            ['name' => 'FNF Swansea', 'rev' => '£6,200', 'trend' => '+5%'],
                            ['name' => '3S Penarth', 'rev' => '£5,100', 'trend' => '-2%'],
                            ['name' => 'City Center', 'rev' => '£4,800', 'trend' => '+8%'],
                            ['name' => 'Bay Side', 'rev' => '£3,200', 'trend' => '+15%'],
                        ];
                        foreach ($topStores as $ts):
                            $isPos = strpos($ts['trend'], '+') !== false;
                            $trendColor = $isPos ? 'text-green-500' : 'text-red-500';
                            $iconColor = $isPos ? 'text-green-500' : 'text-gray-400';
                            $iconBg = $isPos ? 'bg-green-50 dark:bg-green-900/20' : 'bg-gray-50 dark:bg-gray-800';
                            ?>
                            <div
                                class="flex items-center justify-between p-3 rounded-xl hover:bg-gray-50 dark:hover:bg-slate-800/50 transition-colors cursor-pointer group">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-10 h-10 rounded-lg <?php echo $iconBg; ?> flex items-center justify-center <?php echo $iconColor; ?>">
                                        <ion-icon name="storefront" class="text-lg"></ion-icon>
                                    </div>
                                    <div>
                                        <h4 class="text-sm font-bold text-gray-800 dark:text-white">
                                            <?php echo $ts['name']; ?></h4>
                                        <p class="text-xs text-gray-500 dark:text-gray-400">Weekly Revenue</p>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <span
                                        class="block text-sm font-bold text-gray-800 dark:text-white"><?php echo $ts['rev']; ?></span>
                                    <span
                                        class="text-xs font-bold <?php echo $trendColor; ?>"><?php echo $ts['trend']; ?></span>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

            </div>

        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
</main>

<script src="assets/js/admin_dashboard.js?v=<?php echo time(); ?>"></script>