<?php
// DB Connection
$host     = "localhost";
$user     = "root";
$password = "";
$database = "bookerlistdb";
$conn = new mysqli($host, $user, $password, $database);
if ($conn->connect_error) {
    die("DB Connection failed: " . $conn->connect_error);
}

// Fetch store products and product details (product_name, price, category)
$store_id = $_GET['store_id'] ?? 0;
$store_products = [];
if ($store_id) {
    $q = $conn->prepare("
        SELECT sp.id, sp.store_id, sp.product_id, sp.quantity, sp.created_date, 
               p.product_name, p.rrp, p.category
        FROM store_products sp
        JOIN products p ON sp.product_id = p.product_id
        WHERE sp.store_id = ?");
    $q->bind_param("i", $store_id);
    $q->execute();
    $result = $q->get_result();
    while ($row = $result->fetch_assoc()) {
        $store_products[] = $row;
    }
    $q->close();
}

// Fetch store name
$store_name = "";
if ($store_id) {
    $sQ = $conn->prepare("SELECT store_name FROM stores WHERE store_ID = ?");
    $sQ->bind_param("i", $store_id);
    $sQ->execute();
    $store = $sQ->get_result()->fetch_assoc();
    $store_name = $store['store_name'] ?? "Store #{$store_id}";
    $sQ->close();
}

// Handle the action parameter
$action = $_GET['action'] ?? 'view'; // Default to view

// If the action is to edit or view, fetch product details for specific product
if (($action == 'edit' || $action == 'view') && isset($_GET['product_id'])) {
    $product_id = (int)$_GET['product_id'];
    // Get product details
    $product_query = $conn->prepare("SELECT p.product_name, p.rrp, p.category, sp.quantity
                                     FROM store_products sp
                                     JOIN products p ON sp.product_id = p.product_id
                                     WHERE sp.id = ?");
    $product_query->bind_param("i", $product_id);
    $product_query->execute();
    $product_details = $product_query->get_result()->fetch_assoc();
    $product_query->close();
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Store Product Entry - Edit/View</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light p-4">
  <div class="container">
    <h2 class="text-center mb-4"><?= htmlspecialchars($store_name) ?> - Store Products</h2>
    
    <!-- Buttons to switch between Edit and View -->
    <div class="mb-4">
      <a href="view_and_edit.php?store_id=<?= $store_id ?>&action=edit" class="btn btn-primary">Edit Products</a>
      <a href="view_and_edit.php?store_id=<?= $store_id ?>&action=view" class="btn btn-info">View PDF</a>
    </div>

    <!-- Table of store products with full information -->
    <table class="table table-bordered">
      <thead>
        <tr>
          <th>Store Product ID</th>
          <th>Store ID</th>
          <th>Product Name</th>
          <th>Price</th>
          <th>Category</th>
          <th>Quantity</th>
          <th>Created Date</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($store_products as $product): ?>
          <tr>
            <td><?= $product['id'] ?></td>
            <td><?= $product['store_id'] ?></td>
            <td><?= htmlspecialchars($product['product_name']) ?></td>
            <td>£<?= number_format((float)$product['rrp'], 2) ?></td>
            <td><?= htmlspecialchars($product['category']) ?></td>
            <td><?= (int)$product['quantity'] ?></td>
            <td><?= htmlspecialchars($product['created_date']) ?></td>
            <td>
              <a href="view_and_edit.php?store_id=<?= $store_id ?>&product_id=<?= $product['id'] ?>&action=edit" class="btn btn-sm btn-warning">Edit</a>
              <a href="view_and_edit.php?store_id=<?= $store_id ?>&product_id=<?= $product['id'] ?>&action=view" class="btn btn-sm btn-info">View PDF</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <?php if (($action == 'edit' || $action == 'view') && isset($product_details)): ?>
      <!-- Display Product Details when Edit or View is clicked -->
      <div class="mt-4">
        <h3><?= htmlspecialchars($product_details['product_name']) ?> - Product Details</h3>
        <p><strong>Price:</strong> £<?= number_format((float)$product_details['rrp'], 2) ?></p>
        <p><strong>Category:</strong> <?= htmlspecialchars($product_details['category']) ?></p>
        <p><strong>Quantity:</strong> <?= (int)$product_details['quantity'] ?></p>

        <?php if ($action == 'edit'): ?>
          <!-- Edit form for updating product quantity -->
          <form method="POST">
            <div class="mb-3">
              <label for="quantity" class="form-label">Quantity</label>
              <input type="number" id="quantity" name="quantity" class="form-control" value="<?= $product_details['quantity'] ?>" required>
            </div>
            <button type="submit" class="btn btn-success">Save Changes</button>
          </form>
        <?php endif; ?>
      </div>
    <?php endif; ?>

  </div>
</body>
</html>
