<?php
// view.php
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
require('fpdf/fpdf.php');

$host="localhost"; $user="root"; $pwd=""; $db="bookerlistdb";
$conn = new mysqli($host,$user,$pwd,$db);
if($conn->connect_error) die("DB Connection failed: ".$conn->connect_error);

if(!isset($_GET['store_id'],$_GET['created_date'])) {
    die("Missing parameters.");
}
$store_id      = (int)$_GET['store_id'];
$created_date  = $_GET['created_date'];

// Fetch store name
$stmt = $conn->prepare("SELECT store_name FROM stores WHERE store_ID = ?");
$stmt->bind_param("i",$store_id);
$stmt->execute();
$store = $stmt->get_result()->fetch_assoc();
$stmt->close();
$store_name = $store['store_name'] ?? "Store #{$store_id}";

// Fetch items
$stmt = $conn->prepare("
  SELECT p.product_name, p.rrp, p.category, sp.quantity
    FROM store_products sp
    JOIN products p ON sp.product_id = p.product_id
   WHERE sp.store_id = ? AND sp.created_date = ?
   ORDER BY p.category, p.product_name
");
$stmt->bind_param("is",$store_id,$created_date);
$stmt->execute();
$items = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

// Group by category
$groups = [];
foreach($items as $it) {
    // format price
    $num = floatval(preg_replace('/[^\d\.]/','',$it['rrp']));
    $it['price'] = '£'.number_format($num,2);
    $groups[$it['category']][] = $it;
}

// Build PDF
$pdf = new FPDF('P','mm','A4');
$pdf->AddPage();
$pdf->SetFont('Arial','B',16);
$pdf->Cell(0,10,iconv('UTF-8','ISO-8859-1//TRANSLIT',$store_name),0,1,'C');
$pdf->SetFont('Arial','',12);
$pdf->Cell(0,7,"Created: {$created_date}",0,1,'C');
$pdf->Ln(4);

foreach($groups as $cat => $rows) {
    $pdf->SetFont('Arial','B',14);
    $pdf->Cell(0,8,iconv('UTF-8','ISO-8859-1//TRANSLIT',$cat),0,1);
    $pdf->Ln(1);
    $pdf->SetFont('Arial','',12);
    foreach($rows as $r) {
        $line = "{$r['product_name']} - {$r['price']} - {$r['quantity']}";
        $pdf->Cell(0,7,iconv('UTF-8','ISO-8859-1//TRANSLIT',$line),0,1);
    }
    $pdf->Ln(4);
}

$pdf->Output('I',"store_{$store_id}_".str_replace([' ',':'],'',$created_date).".pdf");
exit;
?>
