<?php
$page_title = 'listentries';  // e.g. 'Product Entry' or 'Saved Snapshots'
include 'header.php';
?>
<?php
// list_entries.php
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
$host="localhost"; $user="root"; $pwd=""; $db="bookerlistdb";
$conn = new mysqli($host,$user,$pwd,$db);
if ($conn->connect_error) die("DB Connection failed: ".$conn->connect_error);

// Filters
$filter_store = isset($_GET['filter_store']) && $_GET['filter_store'] !== '' 
    ? (int)$_GET['filter_store'] : '';
$filter_from  = $_GET['filter_from']  ?? '';
$filter_to    = $_GET['filter_to']    ?? '';

// Store list
$stores_res = $conn->query("SELECT store_ID, store_name FROM stores ORDER BY store_name");

// Build snapshot query
$sql = "
  SELECT DISTINCT sp.store_id, sp.created_date, s.store_name
    FROM store_products sp
    JOIN stores s ON sp.store_id = s.store_ID
";
$clauses = [];
if ($filter_store) $clauses[] = "sp.store_id = {$filter_store}";
if ($filter_from)  $clauses[] = "DATE(sp.created_date) >= '{$filter_from}'";
if ($filter_to)    $clauses[] = "DATE(sp.created_date) <= '{$filter_to}'";
if ($clauses)      $sql .= " WHERE ".implode(' AND ',$clauses);
$sql .= " ORDER BY sp.created_date DESC";
$res = $conn->query($sql);
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Saved Product Snapshots</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f8f9fa; }
    .card { border: none; border-radius: 1rem; box-shadow: 0 0.5rem 1.5rem rgba(0,0,0,0.1); }
    .table-hover tbody tr:hover { background-color: rgba(13,110,253,0.05); }
    .btn-rounded { border-radius: 50px; }

    /* Modal backdrop blur */
    .modal-backdrop.show { backdrop-filter: blur(4px); }

    /* Unified modal style */
    .modal-content {
      border-radius: 1rem;
      overflow: hidden;
      border: none;
    }
    .modal-header {
      background: linear-gradient(135deg, #0d6efd 0%, #6610f2 100%);
      color: #fff;
      border-bottom: none;
      padding: 1rem 1.5rem;
    }
    .modal-title {
      font-weight: 600;
      font-size: 1.25rem;
    }
    .modal-header .btn-close {
      filter: invert(1);
      opacity: 0.8;
      transition: opacity 0.2s;
    }
    .modal-header .btn-close:hover {
      opacity: 1;
    }
    .modal-body {
      padding: 0;
    }

    /* Dialog sizing */
    .modal-dialog-centered {
      margin-top: 2rem;
      margin-bottom: 2rem;
    }
    .modal-xl {
      max-width: 95%;
      width: 95%;
    }

    /* Iframe sizing */
    #editModal iframe,
    #pdfModal iframe {
      width: 100%;
      height: 80vh;
      border: none;
    }
    @media (max-width: 768px) {
      #editModal iframe,
      #pdfModal iframe {
        height: 90vh;
      }
    }
  </style>
</head>
<body class="p-4">
  <div class="container">
    <div class="card mb-4">
      <div class="card-header bg-white">
        <h3 class="mb-0">Saved Product Snapshots</h3>
      </div>
      <div class="card-body">
        <form method="GET" class="row g-3 mb-4 align-items-end">
          <div class="col-md-3">
            <label for="filter_store" class="form-label">Store</label>
            <select id="filter_store" name="filter_store" class="form-select">
              <option value="">All Stores</option>
              <?php while($s = $stores_res->fetch_assoc()): ?>
                <option value="<?= $s['store_ID'] ?>"
                  <?= $s['store_ID']==$filter_store?'selected':''?>>
                  <?= htmlspecialchars($s['store_name']) ?>
                </option>
              <?php endwhile; ?>
            </select>
          </div>
          <div class="col-md-3">
            <label for="filter_from" class="form-label">Date From</label>
            <input type="date" id="filter_from" name="filter_from"
                   class="form-control" value="<?= htmlspecialchars($filter_from) ?>">
          </div>
          <div class="col-md-3">
            <label for="filter_to" class="form-label">Date To</label>
            <input type="date" id="filter_to" name="filter_to"
                   class="form-control" value="<?= htmlspecialchars($filter_to) ?>">
          </div>
          <div class="col-md-3 text-end">
            <button type="submit" class="btn btn-primary btn-rounded">Apply</button>
            <a href="listentries.php" class="btn btn-outline-secondary btn-rounded">Clear</a>
          </div>
        </form>

        <div class="table-responsive">
          <table class="table table-striped table-hover align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>Store</th>
                <th>Created Date</th>
                <th class="text-end">Actions</th>
              </tr>
            </thead>
            <tbody>
            <?php while($row = $res->fetch_assoc()): ?>
              <tr>
                <td><?= htmlspecialchars($row['store_name']) ?></td>
                <td><?= htmlspecialchars($row['created_date']) ?></td>
                <td class="text-end">
                  <button
                    class="btn btn-warning btn-sm btn-rounded edit-btn"
                    data-store="<?= $row['store_id'] ?>"
                    data-date="<?= htmlspecialchars($row['created_date']) ?>">
                    Edit
                  </button>
                  <button
                    class="btn btn-primary btn-sm btn-rounded view-btn"
                    data-store="<?= $row['store_id'] ?>"
                    data-date="<?= htmlspecialchars($row['created_date']) ?>">
                    View
                  </button>
                </td>
              </tr>
            <?php endwhile; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

  <!-- Edit Modal -->
  <div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Edit Snapshot</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <iframe id="editFrame" src=""></iframe>
        </div>
      </div>
    </div>
  </div>

  <!-- PDF Preview Modal -->
  <div class="modal fade" id="pdfModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">PDF Preview</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <iframe id="pdfFrame" src=""></iframe>
        </div>
      </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    const encodeDate = d => encodeURIComponent(d);

    // auto-open "To" after "From" selection
    document.getElementById('filter_from').addEventListener('change', () => {
      const to = document.getElementById('filter_to');
      if (to.showPicker) to.showPicker();
      else to.focus();
    });

    document.querySelectorAll('.view-btn').forEach(btn => {
      btn.addEventListener('click', () => {
        document.getElementById('pdfFrame').src =
          `view.php?store_id=${btn.dataset.store}&created_date=${encodeDate(btn.dataset.date)}`;
        new bootstrap.Modal(document.getElementById('pdfModal')).show();
      });
    });

    document.querySelectorAll('.edit-btn').forEach(btn => {
      btn.addEventListener('click', () => {
        document.getElementById('editFrame').src =
          `edit.php?store_id=${btn.dataset.store}&created_date=${encodeDate(btn.dataset.date)}`;
        new bootstrap.Modal(document.getElementById('editModal')).show();
      });
    });
  </script>
</body>
</html>
