<?php
// header.php
// You can set $page_title before including this (defaults to “Shopezy Admin”)
if (!isset($page_title)) {
    $page_title = 'Shopezy Admin';
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= htmlspecialchars($page_title) ?></title>
  <link
    href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css"
    rel="stylesheet"
  >
  <style>
    body { background: #f8f9fa; }
    .navbar { box-shadow: 0 2px 8px rgba(0,0,0,0.05); }
    .btn-rounded { border-radius: 50px; }
    .card { border-radius: 1rem; }
    /* common modal styles */
    .modal-backdrop.show { backdrop-filter: blur(4px); }
    .modal-content {
      border: none;
      border-radius: 1rem;
      overflow: hidden;
    }
    .modal-header {
      background: linear-gradient(135deg, #0d6efd 0%, #6610f2 100%);
      color: #fff;
      border-bottom: none;
    }
    .modal-title { font-weight: 600; }
    .modal-header .btn-close { filter: invert(1); opacity: .8; }
    .modal-header .btn-close:hover { opacity: 1; }
  </style>
</head>
<body>
  <nav class="navbar navbar-expand-lg navbar-light bg-white mb-4">
    <div class="container-fluid">
      <a class="navbar-brand" href="index.php">Booker List Management</a>
      <button
        class="navbar-toggler"
        type="button"
        data-bs-toggle="collapse"
        data-bs-target="#mainNav"
      >
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="mainNav">
        <ul class="navbar-nav ms-auto">
          <li class="nav-item">
            <a class="nav-link" href="index.php">Add New Booker </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="listentries.php">All Booker Lists</a>
          </li>
        </ul>
      </div>
    </div>
  </nav>
