<?php
// edit.php
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
header('Content-Type: text/html; charset=utf-8');

$host="localhost"; $user="root"; $pwd=""; $db="bookerlistdb";
$conn = new mysqli($host,$user,$pwd,$db);
if($conn->connect_error) die("DB Connection failed: ".$conn->connect_error);

if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['action']) && $_POST['action']==='update') {
    $store_id     = (int)$_POST['store_id'];
    $created_date = $_POST['created_date'];
    $products     = $_POST['products'] ?? [];

    // Delete old snapshot
    $del = $conn->prepare("DELETE FROM store_products WHERE store_id=? AND created_date=?");
    $del->bind_param("is",$store_id,$created_date);
    $del->execute();
    $del->close();

    // Insert updated rows
    $ins = $conn->prepare("
      INSERT INTO store_products (store_id, product_id, quantity, created_date)
      VALUES (?, ?, ?, ?)
    ");
    foreach($products as $p) {
        $ins->bind_param("iiis",
          $store_id,
          $p['id'],
          $p['qty'],
          $created_date
        );
        $ins->execute();
    }
    $ins->close();
    echo "<div class='alert alert-success'>Snapshot updated successfully.</div>";
}

// load GET params
$store_id     = isset($_GET['store_id'])     ? (int)$_GET['store_id'] : 0;
$created_date = isset($_GET['created_date']) ? $_GET['created_date']    : '';
if(!$store_id||!$created_date) die("Missing parameters.");

// load products & snapshot...
// (same code as before to build $productData and $selectedProducts)

$pd_res = $conn->query("SELECT * FROM products");
$productData = [];
while($r = $pd_res->fetch_assoc()) {
  $productData[$r['product_name']] = [
    'id'       => $r['product_id'],
    'rrp_raw'  => $r['rrp'],
    'category' => $r['category']
  ];
}
$stmt = $conn->prepare("
  SELECT product_id, quantity
    FROM store_products
   WHERE store_id=? AND created_date=?
");
$stmt->bind_param("is",$store_id,$created_date);
$stmt->execute();
$loaded = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

$selectedProducts = [];
foreach($loaded as $row) {
    foreach($productData as $name => $meta) {
      if($meta['id']==$row['product_id']) {
        $selectedProducts[] = [
          'id'       => $meta['id'],
          'qty'      => (int)$row['quantity'],
          'name'     => $name,
          'rrp_raw'  => $meta['rrp_raw'],
          'category' => $meta['category']
        ];
        break;
      }
    }
}

$stores = $conn->query("SELECT * FROM stores");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Edit Snapshot</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    #suggestions { max-height:200px; overflow-y:auto; }
    td.qty-cell:hover { background-color: #eef; cursor:pointer; }
  </style>
</head>
<body class="bg-light p-4">
  <div class="container">
    <h2 class="mb-4">Edit Snapshot: <?= htmlspecialchars($created_date) ?></h2>
    <form id="editForm" method="POST">
      <input type="hidden" name="action" value="update">
      <input type="hidden" name="store_id" value="<?= $store_id ?>">
      <input type="hidden" name="created_date" value="<?= htmlspecialchars($created_date) ?>">

      <div class="row g-3 mb-3">
        <div class="col-md-3">
          <select class="form-select" disabled>
            <?php while($s = $stores->fetch_assoc()): ?>
              <option value="<?= $s['store_ID'] ?>"
                <?= $s['store_ID']==$store_id?'selected':''?>>
                <?= htmlspecialchars($s['store_name']) ?>
              </option>
            <?php endwhile; ?>
          </select>
        </div>
        <div class="col-md-3 position-relative">
          <input id="product_input" class="form-control" placeholder="Search product…" autocomplete="off">
          <div id="suggestions" class="position-absolute bg-white border rounded w-100" style="z-index:99;"></div>
        </div>
        <div class="col-md-2"><input id="price"    class="form-control" placeholder="Price" readonly></div>
        <div class="col-md-2"><input id="category" class="form-control" placeholder="Category" readonly></div>
        <div class="col-md-2"><input id="qty" type="number" class="form-control" placeholder="Qty"></div>
        <div class="col-12 text-end">
          <button type="button" class="btn btn-success" onclick="addProduct()">+ Add</button>
        </div>
      </div>

      <table class="table table-bordered">
        <tbody id="product_grid"></tbody>
      </table>

      <div class="text-end">
        <button type="submit" class="btn btn-primary">Save Changes</button>
        <button type="button" class="btn btn-secondary view-btn">
          View PDF
        </button>
      </div>
    </form>
  </div>

  <!-- PDF Preview Modal -->
  <div class="modal fade" id="pdfModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl" style="max-width:95%;">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">PDF Preview</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body p-0">
          <iframe id="pdfFrame" src="" width="100%" height="600px" style="border:0;"></iframe>
        </div>
      </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script>
  "use strict";

  // ----- Data from PHP (unchanged lines) -----
  const productData = <?= json_encode($productData, JSON_HEX_TAG) ?>;
  let selectedProducts = <?= json_encode($selectedProducts, JSON_HEX_TAG) ?>;

  // ===== Helpers =====
  function escapeHTML(str){
    return String(str).replace(/[&<>"']/g, s => (
      { "&":"&amp;", "<":"&lt;", ">":"&gt;", '"':"&quot;", "'":"&#39;" }[s]
    ));
  }
  const enc = encodeURIComponent;
  const dec = decodeURIComponent;

  // Build initials: "Euro Shopper Milk Chocolate" -> "esmc"
  function makeInitials(name){
    return name
      .split(/[\s\-\._/]+/)
      .filter(Boolean)
      .map(w => w[0])
      .join('')
      .toLowerCase();
  }
  function tokenize(name){
    return name.toLowerCase().split(/[\s\-\._/]+/).filter(Boolean);
  }

  // Search index
  let searchIndex = []; // [{name, lc, initials, tokens}]

  // Match logic:
  //  - If the query looks like initials (letters only, optional spaces), match initials startsWith (and subsequence fallback)
  //  - Else multi-word AND over name (every term must appear)
  function matchProducts(query){
    const raw = query.trim().toLowerCase();
    if (!raw) return [];
    const initialsQuery  = raw.replace(/\s+/g,''); // "e s" -> "es"
    const isInitialsLike = /^[a-z]+$/.test(initialsQuery) && initialsQuery.length <= 8;
    const terms = raw.split(/\s+/).filter(Boolean);

    return searchIndex.filter(it => {
      if (isInitialsLike) {
        if (it.initials.startsWith(initialsQuery)) return true;
        // subsequence (letters in order)
        let i = 0;
        for (const c of it.initials){
          if (c === initialsQuery[i]) i++;
          if (i === initialsQuery.length) return true;
        }
      }
      // multi-word AND
      const allIn = terms.every(t => it.lc.includes(t));
      if (allIn) return true;
      return false;
    });
  }

  // ===== Autocomplete (no inline onclick) =====
  function autocomplete(inp) {
    const box = document.getElementById('suggestions');

    function render(list){
      if (!list.length) {
        box.innerHTML = '<div class="text-muted px-2">No match</div>';
        return;
      }
      // Cap to 200 for performance
      box.innerHTML = list.slice(0,200).map(it =>
        `<div class="suggestion px-2 py-1" data-name="${enc(it.name)}">${escapeHTML(it.name)}</div>`
      ).join('');
    }

    inp.addEventListener('input', () => {
      const q = inp.value;
      if (!q.trim()) { box.innerHTML = ''; return; }
      render(matchProducts(q));
    });

    // Click selection via delegation
    box.addEventListener('click', (e) => {
      const el = e.target.closest('.suggestion');
      if (!el) return;
      const name = dec(el.dataset.name);
      selectProduct(name);
      box.innerHTML = '';
    });

    // Close on outside click/Escape
    document.addEventListener('click', (e) => {
      if (!box.contains(e.target) && e.target !== inp) box.innerHTML = '';
    });
    inp.addEventListener('keydown', (e) => {
      if (e.key === 'Escape') box.innerHTML = '';
    });
  }

  // ===== Core actions =====
  function selectProduct(name) {
    const pd = productData[name];
    if (!pd) return;
    document.getElementById('product_input').value = name;
    document.getElementById('price').value         = pd.rrp_raw ?? '';
    document.getElementById('category').value      = pd.category ?? '';
    document.getElementById('suggestions').innerHTML = '';
  }

  function addProduct() {
    const name = document.getElementById('product_input').value.trim();
    const qty  = parseInt(document.getElementById('qty').value,10);
    if(!name || !qty || !productData[name]){
      alert('Select a product & valid qty.');
      return;
    }
    selectedProducts.push({
      id:        productData[name].id,
      qty:       qty,
      name:      name,
      rrp_raw:   productData[name].rrp_raw,
      category:  productData[name].category
    });
    ['product_input','price','category','qty'].forEach(id=>document.getElementById(id).value='');
    renderGrid();
  }

  // Expose for buttons already on the page (if any)
  window.addProduct = addProduct;

  function renderGrid() {
    const grid = document.getElementById('product_grid');
    grid.innerHTML = '';
    const groups = {};
    selectedProducts.forEach((p,i)=>{
      (groups[p.category || 'Uncategorized'] = groups[p.category || 'Uncategorized'] || [])
        .push(Object.assign({_idx:i}, p));
    });

    for (const cat in groups) {
      grid.insertAdjacentHTML('beforeend',
        `<tr class="table-light"><td colspan="4"><strong>${escapeHTML(cat)}</strong></td></tr>`
      );
      grid.insertAdjacentHTML('beforeend',
        `<tr class="table-secondary text-dark">
           <th>Product</th><th>Price</th><th>Qty</th><th>Actions</th>
         </tr>`
      );
      groups[cat].forEach(p=>{
        grid.insertAdjacentHTML('beforeend',
          `<tr>
             <td>${escapeHTML(p.name)}</td>
             <td>${escapeHTML(String(p.rrp_raw ?? ''))}</td>
             <td class="qty-cell" data-idx="${p._idx}">${p.qty}</td>
             <td class="text-center">
               <button type="button" class="btn btn-sm btn-outline-danger btn-remove" data-idx="${p._idx}">&times;</button>
             </td>
           </tr>`
        );
      });
    }
  }

  function removeProduct(i) {
    selectedProducts.splice(i,1);
    renderGrid();
  }

  // Keep global for any existing inline uses
  window.removeProduct = removeProduct;

  // ===== Form submit (unchanged, just safer cleanup) =====
  document.getElementById('editForm').onsubmit = ()=>{
    const form = document.getElementById('editForm');
    [...form.querySelectorAll('input[name^="products"]')].forEach(n=>n.remove());
    selectedProducts.forEach((p,i)=>{
      const h1 = document.createElement('input');
      h1.type='hidden'; h1.name=`products[${i}][id]`;  h1.value=p.id;
      const h2 = document.createElement('input');
      h2.type='hidden'; h2.name=`products[${i}][qty]`; h2.value=p.qty;
      form.append(h1,h2);
    });
    return true;
  };

  // ===== Delegation for grid actions & inline qty edit =====
  document.addEventListener('DOMContentLoaded', ()=>{
    // Build search index once DOM is ready
    searchIndex = Object.keys(productData).map(name => ({
      name,
      lc: name.toLowerCase(),
      initials: makeInitials(name),
      tokens: tokenize(name)
    }));

    // View modal (as you had)
    const viewBtn = document.querySelector('.view-btn');
    if (viewBtn) {
      viewBtn.addEventListener('click', ()=>{
        const store = <?= $store_id ?>;
        const date  = encodeURIComponent('<?= htmlspecialchars($created_date) ?>');
        document.getElementById('pdfFrame').src =
          `view.php?store_id=${store}&created_date=${date}`;
        new bootstrap.Modal(document.getElementById('pdfModal')).show();
      });
    }

    // Autocomplete attach
    autocomplete(document.getElementById('product_input'));

    // Initial grid render
    renderGrid();

    // Grid: remove buttons
    const grid = document.getElementById('product_grid');
    grid.addEventListener('click', (e) => {
      const btn = e.target.closest('.btn-remove');
      if (!btn) return;
      const idx = +btn.dataset.idx;
      if (Number.isInteger(idx)) {
        selectedProducts.splice(idx, 1);
        renderGrid();
      }
    });

    // Grid: qty double-click inline edit
    grid.addEventListener('dblclick', (e) => {
      const cell = e.target.closest('td.qty-cell');
      if (!cell) return;
      const idx = +cell.dataset.idx;
      if (!Number.isInteger(idx)) return;
      const old = selectedProducts[idx].qty;

      cell.innerHTML = `<input type="number" min="1" value="${old}" style="width:60px;">`;
      const inp = cell.querySelector('input');
      inp.focus(); inp.select();

      const finish = ()=>{
        const v = parseInt(inp.value,10);
        if (v > 0) selectedProducts[idx].qty = v;
        renderGrid();
      };
      inp.addEventListener('blur', finish);
      inp.addEventListener('keydown', e=>{
        if (e.key === 'Enter') finish();
        if (e.key === 'Escape') renderGrid();
      });
    });
  });

  // Expose selectProduct globally (used by autocomplete)
  window.selectProduct = selectProduct;
</script>

</body>
</html>
