<?php
header('Content-Type: application/json');
$data = json_decode(file_get_contents('php://input'), true);
if (!$data) {
  echo json_encode(['success'=>false,'error'=>'Invalid input']); exit;
}

$host="localhost"; $user="root"; $password=""; $database="bookerlistdb";
$conn = new mysqli($host, $user, $password, $database);
if ($conn->connect_error) {
  echo json_encode(['success'=>false,'error'=>$conn->connect_error]); exit;
}

$stmt = $conn->prepare("
  INSERT INTO products (product_code, product_name, rrp, category)
  VALUES (?, ?, ?, ?)
");
$stmt->bind_param(
  "ssss",
  $data['product_code'],
  $data['product_name'],
  $data['rrp'],
  $data['category']
);

if ($stmt->execute()) {
  $newId = $conn->insert_id;
  echo json_encode([
    'success'      => true,
    'product_id'   => $newId,
    'product_name' => $data['product_name'],
    'rrp'          => $data['rrp'],
    'category'     => $data['category']
  ]);
} else {
  echo json_encode(['success'=>false,'error'=>$stmt->error]);
}

$stmt->close();
$conn->close();
