<?php
$host = "localhost";
$user = "root";
$password = "";
$database = "bookerlistdb";

$conn = new mysqli($host, $user, $password, $database);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['store_id'])) {
    $store_id = $_POST['store_id'];
    $products = $_POST['products'];

    foreach ($products as $product) {
        $product_id = $product['id'];
        $quantity = $product['qty'];

        $check = $conn->query("SELECT * FROM store_products WHERE store_id = $store_id AND product_id = $product_id");

        if ($check->num_rows > 0) {
            $conn->query("UPDATE store_products SET quantity = $quantity WHERE store_id = $store_id AND product_id = $product_id");
        } else {
            $conn->query("INSERT INTO store_products (store_id, product_id, quantity) VALUES ($store_id, $product_id, $quantity)");
        }
    }

    echo "<script>const successModal = new bootstrap.Modal(document.getElementById('successModal')); successModal.show();</script>";
}

$stores = $conn->query("SELECT * FROM stores");
$products = $conn->query("SELECT * FROM products ORDER BY product_name");
$productsList = [];
while ($row = $products->fetch_assoc()) {
    $productsList[$row['product_name']] = $row;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Store Product Entry</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
  <style>
    #suggestions { max-height: 200px; overflow-y: auto; }
    #suggestions div { padding: 5px; cursor: pointer; }
    #suggestions div:hover { background: #f0f0f0; }
    .category-heading { font-weight: bold; background: #e9ecef; padding: 8px; }
  </style>
</head>
<body class="bg-light p-4">
  <div class="container" id="pdf-content">
    <h2 class="mb-4 text-center">Booker List</h2>

    <div class="row g-3 mb-3">
      <div class="col-md-3">
        <select id="store_select" class="form-select">
          <option value="">Select Store</option>
          <?php while($store = $stores->fetch_assoc()): ?>
            <option value="<?= $store['store_ID'] ?>"><?= $store['store_name'] ?> - <?= $store['postcode'] ?></option>
          <?php endwhile; ?>
        </select>
      </div>

      <div class="col-md-3 position-relative">
        <input type="text" id="product_input" class="form-control" placeholder="Search product..." autocomplete="off">
        <div id="suggestions" class="position-absolute bg-white border rounded w-100" style="z-index: 99;"></div>
      </div>

      <div class="col-md-2">
        <input type="text" id="price" class="form-control" placeholder="Price" readonly>
      </div>

      <div class="col-md-2">
        <input type="text" id="category" class="form-control" placeholder="Category" readonly>
      </div>

      <div class="col-md-2">
        <input type="number" id="qty" class="form-control" placeholder="Qty">
      </div>

      <div class="col-md-12 text-end">
        <button class="btn btn-success" onclick="addProduct()">+ Add</button>
      </div>
    </div>

    <div id="product_grid"></div>

    <div class="d-flex gap-3 mt-3">
      <button class="btn btn-primary" onclick="submitForm()">Save to Store</button>
      <button class="btn btn-secondary" onclick="window.print()">Print Page</button>
    </div>
  </div>

  <!-- Modal -->
  <div class="modal fade" id="successModal" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Success</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          Products saved! Would you like to print or export to PDF?
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-outline-primary" onclick="window.print()">Print</button>
          <button type="button" class="btn btn-primary" onclick="exportToPDF()">Export to PDF</button>
        </div>
      </div>
    </div>
  </div>

  <script>
    const productData = <?= json_encode($productsList) ?>;
    const selectedProducts = {};

    function autocomplete(inp) {
      inp.addEventListener("input", function() {
        const val = this.value.toLowerCase();
        const suggestions = Object.keys(productData).filter(p => p.toLowerCase().includes(val));
        const result = suggestions.map(p => `<div onclick='selectProduct("${p}")'>${p}</div>`).join('');
        document.getElementById("suggestions").innerHTML = result || '<div class="text-muted">No match</div>';
      });
    }

    function selectProduct(name) {
      const product = productData[name];
      document.getElementById("product_input").value = name;
      document.getElementById("price").value = product.rrp;
      document.getElementById("category").value = product.category;
      document.getElementById("suggestions").innerHTML = "";
    }

    function addProduct() {
      const name = document.getElementById("product_input").value;
      const price = document.getElementById("price").value;
      const category = document.getElementById("category").value;
      const qty = document.getElementById("qty").value;
      if (!name || !price || !category || !qty) return alert("Fill all fields");

      if (!selectedProducts[category]) {
        selectedProducts[category] = [];
        const block = `<div class='category-heading'>${category}</div>
          <table class='table table-bordered'><thead><tr><th>Product</th><th>Price</th><th>Category</th><th>Quantity</th></tr></thead><tbody id='cat-${category.replace(/\s+/g, '')}'></tbody></table>`;
        document.getElementById("product_grid").insertAdjacentHTML('beforeend', block);
      }

      selectedProducts[category].push({ id: productData[name].product_id, name, price, category, qty });

      const row = `<tr><td>${name}</td><td>${price}</td><td>${category}</td><td>${qty}</td></tr>`;
      document.getElementById(`cat-${category.replace(/\s+/g, '')}`).insertAdjacentHTML('beforeend', row);

      document.getElementById("product_input").value = "";
      document.getElementById("price").value = "";
      document.getElementById("category").value = "";
      document.getElementById("qty").value = "";
    }

    function submitForm() {
      const storeId = document.getElementById("store_select").value;
      if (!storeId) return alert("Please select a store");

      const form = document.createElement('form');
      form.method = 'POST';
      const storeInput = document.createElement('input');
      storeInput.name = 'store_id';
      storeInput.value = storeId;
      form.appendChild(storeInput);

      let i = 0;
      for (const cat in selectedProducts) {
        selectedProducts[cat].forEach(p => {
          for (const key in p) {
            let input = document.createElement('input');
            input.name = `products[${i}][${key}]`;
            input.value = p[key];
            form.appendChild(input);
          }
          i++;
        });
      }
      document.body.appendChild(form);
      form.submit();
    }

    async function exportToPDF() {
      const { jsPDF } = window.jspdf;
      const doc = new jsPDF();
      doc.text("Store Product List", 10, 10);

      const rows = document.querySelectorAll("#product_grid tr");
      let y = 20;
      rows.forEach(row => {
        let x = 10;
        row.querySelectorAll("td").forEach(col => {
          doc.text(col.innerText, x, y);
          x += 45;
        });
        y += 10;
      });
      doc.save("Store_Products.pdf");
    }

    window.onload = () => autocomplete(document.getElementById("product_input"));
  </script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
  const productData = <?= json_encode($productsList) ?>;
  const selectedProducts = {};
  const addedCategories = new Set();

  function autocomplete(inp) {
    inp.addEventListener("input", function () {
      const val = this.value.toLowerCase();
      const suggestions = Object.keys(productData).filter(p => p.toLowerCase().includes(val));
      const result = suggestions.map(p => `<div onclick='selectProduct("${p.replaceAll("\"", "\\\"")}")'>${p}</div>`).join('');
      document.getElementById("suggestions").innerHTML = result || '<div class="text-muted">No match</div>';
    });
  }

  function selectProduct(name) {
    const product = productData[name];
    if (!product) return;
    document.getElementById("product_input").value = name;
    document.getElementById("price").value = product.price;
    document.getElementById("category").value = product.category;
    document.getElementById("suggestions").innerHTML = "";
  }

  function addProduct() {
    const name = document.getElementById("product_input").value;
    const price = document.getElementById("price").value;
    const category = document.getElementById("category").value;
    const qty = document.getElementById("qty").value;
    if (!name || !price || !category || !qty || !productData[name]) return alert("Fill all fields correctly");

    const productID = productData[name].product_id;
    if (!selectedProducts[category]) selectedProducts[category] = [];

    const existingIndex = selectedProducts[category].findIndex(p => p.id === productID);
    if (existingIndex !== -1) return alert("Product already added");

    const newProduct = { id: productID, name, price, category, qty };
    selectedProducts[category].push(newProduct);

    if (!addedCategories.has(category)) {
      const block = `<div class='category-heading'>${category}</div>
        <table class='table table-bordered'><thead><tr><th>Product</th><th>Price</th><th>Category</th><th>Quantity</th><th>Action</th></tr></thead><tbody id='cat-${category.replace(/\s+/g, '')}'></tbody></table>`;
      document.getElementById("product_grid").insertAdjacentHTML('beforeend', block);
      addedCategories.add(category);
    }

    const row = document.createElement('tr');
    row.innerHTML = `<td>${name}</td><td>${price}</td><td>${category}</td><td>${qty}</td>
      <td><button class='btn btn-sm btn-danger' onclick='removeProduct("${category}", ${productID}, this)'>Remove</button></td>`;
    document.getElementById(`cat-${category.replace(/\s+/g, '')}`).appendChild(row);

    document.getElementById("product_input").value = "";
    document.getElementById("price").value = "";
    document.getElementById("category").value = "";
    document.getElementById("qty").value = "";
  }

  function removeProduct(category, productId, button) {
    selectedProducts[category] = selectedProducts[category].filter(p => p.id !== productId);
    const row = button.closest('tr');
    if (row) row.remove();
  }

  function submitForm() {
    const storeId = document.getElementById("store_select").value;
    if (!storeId) return alert("Please select a store");

    const form = document.createElement('form');
    form.method = 'POST';
    form.action = 'export_and_save.php'; // NEW endpoint to handle save + PDF export

    const storeInput = document.createElement('input');
    storeInput.name = 'store_id';
    storeInput.value = storeId;
    form.appendChild(storeInput);

    let i = 0;
    for (const cat in selectedProducts) {
      selectedProducts[cat].forEach(p => {
        for (const key in p) {
          let input = document.createElement('input');
          input.name = `products[${i}][${key}]`;
          input.value = p[key];
          form.appendChild(input);
        }
        i++;
      });
    }
    document.body.appendChild(form);
    form.submit();
  }

  async function exportToPDF() {
    const rows = document.querySelectorAll("#product_grid tr");
    let content = "<table border='1' cellpadding='5'><thead><tr><th>Product</th><th>Price</th><th>Category</th><th>Qty</th></tr></thead><tbody>";
    rows.forEach(row => {
      content += "<tr>";
      row.querySelectorAll("td:not(:last-child)").forEach(td => {
        content += `<td>${td.innerText}</td>`;
      });
      content += "</tr>";
    });
    content += "</tbody></table>";

    const form = document.createElement('form');
    form.method = 'POST';
    form.action = 'generate_pdf.php';

    let htmlInput = document.createElement('input');
    htmlInput.type = 'hidden';
    htmlInput.name = 'html';
    htmlInput.value = content;
    form.appendChild(htmlInput);

    document.body.appendChild(form);
    form.submit();
  }

  window.onload = () => autocomplete(document.getElementById("product_input"));
</script>

</body>
</html>